/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolButton;
import gishur.awt.SymbolImageButton;
import gishur.awt.SymbolbarElement;
import gishur.awt.SymbolbarGrasp;
import gishur.awt.ToolTip;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Menu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;

public class Symbolbar
extends Component
implements ToolTip {
    public String name;
    public static final byte ALIGN_LEFT = 1;
    public static final byte ALIGN_RIGHT = 2;
    public byte alignment = 1;
    private SymbolbarElement[] _symbol;
    private int _active = -1;
    private int _lastloc = -1;
    private int _loc = -1;
    private boolean _dragging = false;
    private boolean _exited = false;
    transient ActionListener _actionListener;

    public synchronized void set(SymbolbarElement symbolbarElement, int n) {
        if (symbolbarElement == null || n < 0 || n >= this._symbol.length) {
            return;
        }
        this._symbol[n] = symbolbarElement;
        this._symbol[n].setParent(this);
    }

    public SymbolbarElement element(int n) {
        if (n < 0 || n >= this._symbol.length) {
            return null;
        }
        return this._symbol[n];
    }

    public SymbolbarElement element(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        while (n < this._symbol.length && this._symbol[n] != null && !string.equals(this._symbol[n].getCommand())) {
            ++n;
        }
        if (n < this._symbol.length) {
            return this._symbol[n];
        }
        return null;
    }

    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    public Symbolbar(String string, int n) {
        this.name = string;
        this._symbol = new SymbolbarElement[n];
        int n2 = 0;
        while (n2 < this._symbol.length) {
            this._symbol[n2] = null;
            ++n2;
        }
        this.addSymbolbarGrasp();
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.enableEvents(128L);
        this.setBackground(Color.lightGray);
    }

    public synchronized void add(SymbolbarElement symbolbarElement) {
        if (symbolbarElement == null) {
            return;
        }
        int n = 0;
        n = 0;
        while (n < this._symbol.length && this._symbol[n] != null) {
            ++n;
        }
        this.set(symbolbarElement, n);
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        graphics.setColor(this.getBackground());
        graphics.fill3DRect(0, 0, rectangle.width, rectangle.height, true);
        graphics.translate(2, 2);
        int n = 0;
        while (n < this._symbol.length && this._symbol[n] != null) {
            graphics.setColor(this.getBackground());
            graphics.setClip(0, 0, this._symbol[n].getSize(), rectangle.height - 4);
            this._symbol[n].update(graphics, rectangle.height - 4);
            this._symbol[n]._needs_repaint = false;
            graphics.translate(this._symbol[n].getSize() + 1, 0);
            ++n;
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        super.processMouseEvent(mouseEvent);
        Rectangle rectangle = this.getBounds();
        this._lastloc = this._loc;
        int n2 = mouseEvent.getY() > 1 && mouseEvent.getY() < rectangle.height - 2 ? this.localize(mouseEvent.getX()) : -1;
        if (n2 >= 0 && !this._symbol[n2].enabled()) {
            n2 = -1;
        }
        this._loc = n2;
        if (mouseEvent.getID() == 505 && this._active >= 0) {
            if (!this._dragging || !this._exited) {
                this._symbol[this._active].mouseExited(mouseEvent);
            }
            this._exited = true;
            if (!this._dragging) {
                n2 = -1;
            }
        }
        if (n2 != this._active && this._active >= 0) {
            n = this.getXPos(this._active);
            switch (mouseEvent.getID()) {
                case 503: 
                case 504: {
                    this._symbol[this._active].mouseExited(new MouseEvent(mouseEvent.getComponent(), 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    break;
                }
                case 501: 
                case 502: 
                case 506: {
                    if (this._dragging) {
                        n2 = this._active;
                    }
                    if (this._exited) break;
                    this._symbol[this._active].mouseExited(new MouseEvent(mouseEvent.getComponent(), 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    this._exited = true;
                }
            }
            if (this._active != n2 && this._active >= 0 && this._symbol[this._active]._needs_repaint) {
                this.repaint();
            }
        }
        if (n2 >= 0) {
            n = this.getXPos(this._active);
            switch (mouseEvent.getID()) {
                case 503: 
                case 504: {
                    if (n2 != this._active) {
                        this._symbol[n2].mouseEntered(new MouseEvent(mouseEvent.getComponent(), 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                        break;
                    }
                    this._symbol[n2].mouseMoved(new MouseEvent(mouseEvent.getComponent(), 503, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    break;
                }
                case 501: {
                    if (this._dragging) break;
                    this._symbol[n2].mousePressed(new MouseEvent(mouseEvent.getComponent(), 501, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    this._exited = false;
                    break;
                }
                case 500: {
                    this._symbol[n2].mouseClicked(new MouseEvent(mouseEvent.getComponent(), 500, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    break;
                }
                case 502: {
                    this._symbol[n2].mouseReleased(new MouseEvent(mouseEvent.getComponent(), 502, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    if (this._dragging && this._loc == n2 && this.localize(mouseEvent.getX()) != n2) {
                        this._symbol[n2].mouseExited(new MouseEvent(mouseEvent.getComponent(), 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                    }
                    this._dragging = false;
                    break;
                }
                case 506: {
                    this._dragging = true;
                    if (this._loc == n2 && this._loc != this._lastloc) {
                        this._symbol[n2].mouseEntered(new MouseEvent(mouseEvent.getComponent(), 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                        this._exited = false;
                    }
                    this._symbol[n2].mouseDragged(new MouseEvent(mouseEvent.getComponent(), 506, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - n, mouseEvent.getY() - 2, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger()));
                }
            }
            if (this._symbol[n2]._needs_repaint) {
                this.repaint();
            }
        }
        this._active = n2;
    }

    public synchronized void insert(SymbolbarElement symbolbarElement, int n) {
        if (n < 0 || n >= this._symbol.length || symbolbarElement == null) {
            return;
        }
        if (this._symbol[n] == null) {
            this.set(symbolbarElement, n);
            return;
        }
        try {
            if (this._symbol.length > 0) {
                System.arraycopy(this._symbol, n, this._symbol, n + 1, this._symbol.length - n - 1);
            }
            this.set(symbolbarElement, n);
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return;
        }
        catch (ArrayStoreException arrayStoreException) {
            return;
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.remove(this._actionListener, actionListener);
    }

    public void addSymbolbarGrasp() {
        if (this._symbol[0] != null && this._symbol[0] instanceof SymbolbarGrasp) {
            return;
        }
        this.insert(new SymbolbarGrasp(), 0);
    }

    public int indexOf(SymbolbarElement symbolbarElement) {
        int n = 0;
        n = 0;
        while (n < this._symbol.length && this._symbol[n] != null && this._symbol[n] != symbolbarElement) {
            ++n;
        }
        if (n >= this._symbol.length || this._symbol[n] == null) {
            return -1;
        }
        return n;
    }

    public void stripEnabledImage(int n, int n2, Image image, Rectangle rectangle, int n3, int n4) {
        if (n < 0 || n > n2 || n2 >= this._symbol.length) {
            return;
        }
        int n5 = n;
        while (n5 <= n2) {
            if (this._symbol[n5] != null && this._symbol[n5] instanceof SymbolImageButton) {
                SymbolImageButton symbolImageButton = (SymbolImageButton)this._symbol[n5];
                symbolImageButton.setEnabledImage(image, rectangle);
                rectangle = new Rectangle(rectangle);
                rectangle.x += n3;
                rectangle.y += n4;
            }
            ++n5;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        this.processMouseEvent(mouseEvent);
    }

    public String getStatusTip(int n, int n2) {
        int n3 = this.localize(n);
        if (n3 < 0) {
            return this.name;
        }
        return this._symbol[n3].label;
    }

    public void processActionEvent(ActionEvent actionEvent) {
        if (this._actionListener != null) {
            this._actionListener.actionPerformed(actionEvent);
        }
    }

    public synchronized void clearAll() {
        int n = 1;
        while (n < this._symbol.length) {
            this._symbol[n] = null;
            ++n;
        }
    }

    public void enableAll() {
        int n = 0;
        while (n < this._symbol.length && this._symbol[n] != null) {
            if (!(this._symbol[n] instanceof SymbolbarGrasp)) {
                this._symbol[n].enable();
            }
            ++n;
        }
    }

    public void disableAll() {
        int n = 0;
        while (n < this._symbol.length && this._symbol[n] != null) {
            if (!(this._symbol[n] instanceof SymbolbarGrasp)) {
                this._symbol[n].disable();
            }
            ++n;
        }
    }

    public void stripImages(int n, int n2, Image image, Image image2, Rectangle rectangle, int n3, int n4) {
        if (n < 0 || n > n2 || n2 >= this._symbol.length) {
            return;
        }
        int n5 = n;
        while (n5 <= n2) {
            if (this._symbol[n5] != null && this._symbol[n5] instanceof SymbolImageButton) {
                SymbolImageButton symbolImageButton = (SymbolImageButton)this._symbol[n5];
                symbolImageButton.setEnabledImage(image, rectangle);
                symbolImageButton.setDisabledImage(image2, rectangle);
                rectangle = new Rectangle(rectangle);
                rectangle.x += n3;
                rectangle.y += n4;
            }
            ++n5;
        }
    }

    public void stripDisabledImage(int n, int n2, Image image, Rectangle rectangle, int n3, int n4) {
        if (n < 0 || n > n2 || n2 >= this._symbol.length) {
            return;
        }
        int n5 = n;
        while (n5 <= n2) {
            if (this._symbol[n5] != null && this._symbol[n5] instanceof SymbolImageButton) {
                SymbolImageButton symbolImageButton = (SymbolImageButton)this._symbol[n5];
                symbolImageButton.setDisabledImage(image, rectangle);
                rectangle = new Rectangle(rectangle);
                rectangle.x += n3;
                rectangle.y += n4;
            }
            ++n5;
        }
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < this._symbol.length && this._symbol[n3] != null) {
            if (this._symbol[n3].getPreferredHeight() > n) {
                n = this._symbol[n3].getPreferredHeight();
            }
            n2 += this._symbol[n3].getSize() + 1;
            ++n3;
        }
        return new Dimension(n2 + 3, n + 4);
    }

    public Dimension getMinimumSize() {
        return new Dimension(40, 40);
    }

    public String getToolTip(int n, int n2) {
        int n3 = this.localize(n);
        if (n3 < 0) {
            return null;
        }
        return this._symbol[n3].label;
    }

    public Rectangle getBounds(int n) {
        if (n < 0 || n >= this._symbol.length) {
            return null;
        }
        Rectangle rectangle = this.getBounds();
        rectangle.y = 2;
        rectangle.x = 2;
        rectangle.height -= 4;
        int n2 = 0;
        while (n2 < n && n2 < this._symbol.length && this._symbol[n2] != null) {
            rectangle.x = rectangle.x + 1 + this._symbol[n2].getSize();
            ++n2;
        }
        rectangle.width = this._symbol[n].getSize();
        return rectangle;
    }

    public int localize(int n) {
        int n2 = -1;
        int n3 = 2;
        n2 = 0;
        while (n2 < this._symbol.length && this._symbol[n2] != null && (n < n3 || n >= n3 + this._symbol[n2].getSize())) {
            n3 = n3 + this._symbol[n2].getSize() + 1;
            ++n2;
        }
        if (n2 < this._symbol.length && this._symbol[n2] != null) {
            return n2;
        }
        return -1;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this._actionListener = AWTEventMulticaster.add(this._actionListener, actionListener);
    }

    private int getXPos(int n) {
        int n2 = 2;
        int n3 = 0;
        while (n3 < this._symbol.length && n3 < n) {
            n2 = n2 + this._symbol[n3].getSize() + 1;
            ++n3;
        }
        return n2;
    }

    public void generateMenu(Menu menu) {
        int n = 0;
        while (n < this._symbol.length) {
            if (this._symbol[n] instanceof SymbolButton) {
                menu.add(((SymbolButton)this._symbol[n]).generateMenuItem());
            }
            ++n;
        }
    }
}

