/*
 * Decompiled with CFR 0.152.
 */
package gishur.awt;

import gishur.awt.SymbolbarElement;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;

public class SymbolbarSlider
extends SymbolbarElement {
    public static final int SYMBOLSLIDER_VALUE_CHANGED = 2204;
    private String left_text;
    private String mid_text;
    private String right_text;
    private String value_text;
    private int _value = 0;
    private int _max_value = 100;
    private int _number_value_offset = 0;
    public Font font = new Font("Helvetica", 0, 7);
    public Color text_color = Color.black;
    public Color text_value_color = Color.darkGray;
    public Color back_color = Color.white;
    public Color bar_color = Color.white;
    public int hspace = 5;
    public int bar_height = 5;
    public int slider_size = 8;
    public int slider_voffset = 0;
    public int text_voffset = -(this.slider_size / 2 - this.bar_height / 2 + 2);
    private Rectangle _slider = null;
    private Rectangle _bar = null;
    private int _rel_x = 0;
    private boolean _drag_slider = false;

    public void setRightText(String string) {
        this.right_text = string;
        this._needs_repaint = true;
    }

    public String rightText() {
        return this.right_text;
    }

    public void setMidText(String string) {
        this.mid_text = string;
        this._needs_repaint = true;
    }

    public void setNumberedValues(int n) {
        this._number_value_offset = n;
        if (this._number_value_offset == Integer.MIN_VALUE) {
            return;
        }
        this.value_text = String.valueOf(this._value + this._number_value_offset);
        this.setNumberedLabels(this._number_value_offset);
        this._needs_repaint = true;
    }

    public void disableNumberedValues() {
        this._number_value_offset = Integer.MIN_VALUE;
    }

    public String midText() {
        return this.mid_text;
    }

    public void setValueText(String string) {
        this.value_text = string;
        this._needs_repaint = true;
    }

    public String valueText() {
        return this.value_text;
    }

    private void drawValue(Graphics graphics, int n) {
        if (this.value_text == null || this.value_text == "") {
            return;
        }
        int n2 = graphics.getFontMetrics().stringWidth(this.value_text);
        int n3 = (int)((float)this.hspace + (float)this._value / (float)this._max_value * (float)(this.width - 2 * this.hspace)) - n2 / 2;
        int n4 = n3 < this.hspace ? this.hspace : (n3 = n3 > this.width - this.hspace - n2 ? this.width - this.hspace - n2 : n3);
        if (this.enabled()) {
            graphics.setColor(this.text_value_color);
        } else {
            graphics.setColor(new Color(123, 123, 123));
        }
        graphics.drawString(this.value_text, n3, n - 1);
    }

    public int maxValue() {
        return this._max_value;
    }

    public void setValue(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this._max_value) {
            n = this._max_value;
        }
        if (this._value == n) {
            return;
        }
        this._value = n;
        this.value_text = this._number_value_offset != Integer.MIN_VALUE ? String.valueOf(this._value + this._number_value_offset) : null;
        this.getParent().dispatchEvent(new ActionEvent(this, 2204, this.command, this.getParent().indexOf(this)));
        this._needs_repaint = true;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this._slider == null) {
            return;
        }
        if (this._slider.contains(mouseEvent.getX(), mouseEvent.getY())) {
            this._drag_slider = true;
            this._rel_x = mouseEvent.getX() - this._slider.x - this._slider.width / 2;
        }
    }

    public void setNumberedLabels(int n) {
        this.left_text = Integer.toString(n);
        this.mid_text = this._max_value > 1 ? Integer.toString(this._max_value / 2 + n) : "";
        this.right_text = this._max_value > 0 ? Integer.toString(this._max_value + n) : "";
        this._needs_repaint = true;
    }

    public SymbolbarSlider(String string, String string2, int n, int n2) {
        this.label = string;
        this.command = string2;
        this.width = n;
        this.setValueTo(0);
        this.setMaxValue(n2);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this._drag_slider = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this._drag_slider) {
            return;
        }
        this.changeValueTo(mouseEvent.getX() - this._rel_x);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this._bar == null || this._slider == null) {
            return;
        }
        if (this._slider.contains(mouseEvent.getX(), mouseEvent.getY())) {
            return;
        }
        if (this._bar.contains(mouseEvent.getX(), mouseEvent.getY())) {
            if (this._slider.x > mouseEvent.getX()) {
                this.setValue(this._value - 1);
                return;
            }
            this.setValue(this._value + 1);
        }
    }

    public void setValueTo(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > this._max_value) {
            n = this._max_value;
        }
        this._value = n;
        this.value_text = this._number_value_offset != Integer.MIN_VALUE ? String.valueOf(this._value + this._number_value_offset) : null;
        this._needs_repaint = true;
    }

    public int value() {
        return this._value;
    }

    public void update(Graphics graphics, int n) {
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n2 = this.mid_text == null ? 0 : fontMetrics.stringWidth(this.mid_text);
        int n3 = this.right_text == null ? 0 : fontMetrics.stringWidth(this.right_text);
        int n4 = n / 2 + this.slider_voffset - this.bar_height / 2;
        this._bar = new Rectangle(this.hspace, n4, this.width - 2 * this.hspace, this.bar_height);
        if (this.enabled()) {
            graphics.setFont(this.font);
            graphics.setColor(Color.lightGray);
            graphics.draw3DRect(this._bar.x, this._bar.y, this._bar.width - 1, this._bar.height - 1, false);
            graphics.setColor(this.bar_color);
            graphics.fillRect(this._bar.x + 1, this._bar.y + 1, this._bar.width - 2, this._bar.height - 2);
            graphics.setColor(this.text_color);
            graphics.drawString(this.left_text, this.hspace, n4 + this.text_voffset);
            graphics.drawString(this.mid_text, this.hspace + (this.width - 2 * this.hspace) / 2 - n2 / 2, n4 + this.text_voffset);
            graphics.drawString(this.right_text, this.width - this.hspace - n3, n4 + this.text_voffset);
            this.drawSlider(graphics, n);
            this.drawValue(graphics, n);
            return;
        }
        graphics.setFont(this.font);
        graphics.setColor(Color.lightGray);
        graphics.draw3DRect(this._bar.x, this._bar.y, this._bar.width - 1, this._bar.height - 1, false);
        graphics.setColor(Color.lightGray);
        graphics.fillRect(this._bar.x + 1, this._bar.y + 1, this._bar.width - 2, this._bar.height - 2);
        graphics.setColor(Color.white);
        graphics.drawString(this.left_text, this.hspace + 1, n4 + this.text_voffset + 1);
        graphics.drawString(this.mid_text, this.hspace + (this.width - 2 * this.hspace) / 2 - n2 / 2 + 1, n4 + this.text_voffset + 1);
        graphics.drawString(this.right_text, this.width - this.hspace - n3 + 1, n4 + this.text_voffset + 1);
        graphics.setColor(new Color(123, 123, 123));
        graphics.drawString(this.left_text, this.hspace, n4 + this.text_voffset);
        graphics.drawString(this.mid_text, this.hspace + (this.width - 2 * this.hspace) / 2 - n2 / 2, n4 + this.text_voffset);
        graphics.drawString(this.right_text, this.width - this.hspace - n3, n4 + this.text_voffset);
        this.drawSlider(graphics, n);
    }

    public void setMaxValue(int n) {
        if (n < 0) {
            return;
        }
        this._max_value = n;
        if (this._number_value_offset != Integer.MIN_VALUE) {
            this.setNumberedLabels(this._number_value_offset);
        }
        this.setValue(this._value);
    }

    private void changeValueTo(int n) {
        int n2 = this.width - 2 * this.hspace;
        if ((n -= this.hspace) <= 0) {
            this.setValue(0);
            return;
        }
        if (n >= n2) {
            this.setValue(this._max_value);
            return;
        }
        int n3 = Math.round((float)this._max_value / (float)n2 * (float)n);
        if (n3 != this._value) {
            this.setValue(n3);
        }
    }

    private void drawSlider(Graphics graphics, int n) {
        graphics.setColor(Color.lightGray);
        int n2 = (int)((float)this.hspace + (float)this._value / (float)this._max_value * (float)(this.width - 2 * this.hspace));
        int n3 = n / 2 + this.slider_voffset;
        int n4 = this.slider_size / 2;
        this._slider = new Rectangle(n2 - n4, n3 - n4, this.slider_size, this.slider_size);
        graphics.draw3DRect(n2 - n4, n3 - n4, this.slider_size, this.slider_size, true);
        graphics.fill3DRect(n2 - n4 + 1, n3 - n4 + 1, this.slider_size - 1, this.slider_size - 1, true);
    }

    public void setLeftText(String string) {
        this.left_text = string;
        this._needs_repaint = true;
    }

    public String leftText() {
        return this.left_text;
    }
}

