/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

public abstract class ExtMath {
    public static double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / (Math.exp(d) + Math.exp(-d));
    }

    public static double[][] findRoots(double d, double d2, double d3) {
        double d4 = d2 * d2 - 4.0 * d * d3;
        double[][] dArray = null;
        if (d4 < 0.0) {
            dArray = new double[2][2];
            dArray[0][0] = -d2 / (2.0 * d);
            dArray[0][1] = Math.sqrt(-d4) / (2.0 * d);
            dArray[1][0] = -d2 / (2.0 * d);
            dArray[1][1] = -Math.sqrt(-d4) / (2.0 * d);
        } else {
            dArray = new double[2][2];
            dArray[0][1] = 0.0;
            dArray[1][1] = 0.0;
            dArray[0][0] = (-d2 + Math.sqrt(d4)) / (2.0 * d);
            dArray[1][0] = (-d2 - Math.sqrt(d4)) / (2.0 * d);
        }
        return dArray;
    }

    public static double[][] findRoots(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d3 / d - d2 * d2 / (3.0 * d * d);
        double d7 = 2.0 * d2 * d2 * d2 / (27.0 * d * d * d) - d2 * d3 / (3.0 * d * d) + d4 / d;
        double d8 = d7 < 0.0 ? -Math.sqrt(Math.abs(d6) / 3.0) : Math.sqrt(Math.abs(d6) / 3.0);
        double d9 = d6 * d6 * d6 / 27.0 + d7 * d7 / 4.0;
        double[][] dArray = new double[3][2];
        if (d6 < 0.0) {
            if (d9 <= 0.0) {
                d5 = Math.acos(d7 / (2.0 * d8 * d8 * d8));
                dArray[0][0] = -2.0 * d8 * Math.cos(d5 / 3.0);
                dArray[0][1] = 0.0;
                dArray[1][0] = -2.0 * d8 * Math.cos(d5 / 3.0 + 2.0943951023931953);
                dArray[1][1] = 0.0;
                dArray[2][0] = -2.0 * d8 * Math.cos(d5 / 3.0 + 4.1887902047863905);
                dArray[2][1] = 0.0;
            } else {
                d5 = ExtMath.acosh(d7 / (2.0 * d8 * d8 * d8));
                dArray[0][0] = -2.0 * d8 * ExtMath.cosh(d5 / 3.0);
                dArray[0][1] = 0.0;
                dArray[1][0] = d8 * ExtMath.cosh(d5 / 3.0);
                dArray[1][1] = Math.sqrt(3.0) * d8 * ExtMath.sinh(d5 / 3.0);
                dArray[2][0] = dArray[1][0];
                dArray[2][1] = -dArray[1][1];
            }
        } else {
            d5 = ExtMath.asinh(d7 / (2.0 * d8 * d8 * d8));
            dArray[0][0] = -2.0 * d8 * ExtMath.sinh(d5 / 3.0);
            dArray[0][1] = 0.0;
            dArray[1][0] = d8 * ExtMath.sinh(d5 / 3.0);
            dArray[1][1] = Math.sqrt(3.0) * d8 * ExtMath.cosh(d5 / 3.0);
            dArray[2][0] = dArray[1][0];
            dArray[2][1] = -dArray[1][1];
        }
        int n = 0;
        do {
            dArray[n][0] = dArray[n][0] - d2 / (3.0 * d);
        } while (++n < 3);
        return dArray;
    }

    public static double[][] findRoots(double d, double d2, double d3, double d4, double d5) {
        double d6;
        double d7;
        double d8 = -3.0 * d2 * d2 / (8.0 * d * d) + d3 / d;
        double d9 = d2 * d2 * d2 / (8.0 * d * d * d) - d2 * d3 / (2.0 * d * d) + d4 / d;
        double d10 = -3.0 * d2 * d2 * d2 * d2 / (256.0 * d * d * d * d) + d2 * d2 * d3 / (16.0 * d * d * d) - d4 * d2 / (4.0 * d * d) + d5 / d;
        double[][] dArray = ExtMath.findRoots(1.0, 2.0 * d8, d8 * d8 - 4.0 * d10, -d9 * d9);
        int n = 0;
        while (n < dArray.length) {
            d7 = dArray[n][0];
            d6 = dArray[n][1];
            if (d7 != 0.0 || d6 != 0.0) {
                dArray[n][0] = Math.sqrt(Math.sqrt(d7 * d7 + d6 * d6));
                if (d7 != 0.0) {
                    dArray[n][1] = Math.atan(d6 / d7);
                } else {
                    double d11 = dArray[n][1] = d6 > 0.0 ? 1.5707963267948966 : 4.71238898038469;
                }
                if (d7 < 0.0) {
                    double[] dArray2 = dArray[n];
                    dArray2[1] = dArray2[1] + Math.PI;
                }
                dArray[n][1] = 0.5 * dArray[n][1];
            } else {
                dArray[n][0] = 0.0;
                dArray[n][1] = 0.0;
            }
            d7 = dArray[n][0];
            d6 = dArray[n][1];
            dArray[n][0] = d7 * Math.cos(d6);
            dArray[n][1] = d7 * Math.sin(d6);
            ++n;
        }
        d7 = dArray[0][0] * dArray[1][0] * dArray[2][0] - dArray[0][1] * dArray[1][1] * dArray[2][0] - dArray[0][0] * dArray[1][1] * dArray[2][1] - dArray[0][1] * dArray[1][0] * dArray[2][1];
        d6 = -dArray[0][1] * dArray[1][1] * dArray[2][1] + dArray[0][0] * dArray[1][0] * dArray[2][1] + dArray[0][0] * dArray[1][1] * dArray[2][0] + dArray[0][1] * dArray[1][0] * dArray[2][0];
        if (d7 == 0.0 || d9 / d7 < 0.0) {
            dArray[0][0] = -dArray[0][0];
            dArray[1][0] = -dArray[1][0];
            dArray[2][0] = -dArray[2][0];
            dArray[0][1] = -dArray[0][1];
            dArray[1][1] = -dArray[1][1];
            dArray[2][1] = -dArray[2][1];
        }
        double[][] dArray3 = new double[4][2];
        dArray3[0][0] = 0.5 * (dArray[0][0] + dArray[1][0] - dArray[2][0]);
        dArray3[0][1] = 0.5 * (dArray[0][1] + dArray[1][1] - dArray[2][1]);
        dArray3[1][0] = 0.5 * (dArray[0][0] - dArray[1][0] + dArray[2][0]);
        dArray3[1][1] = 0.5 * (dArray[0][1] - dArray[1][1] + dArray[2][1]);
        dArray3[2][0] = 0.5 * (-dArray[0][0] + dArray[1][0] + dArray[2][0]);
        dArray3[2][1] = 0.5 * (-dArray[0][1] + dArray[1][1] + dArray[2][1]);
        dArray3[3][0] = 0.5 * (-dArray[0][0] - dArray[1][0] - dArray[2][0]);
        dArray3[3][1] = 0.5 * (-dArray[0][1] - dArray[1][1] - dArray[2][1]);
        int n2 = 0;
        do {
            if (Math.abs(dArray3[n2][0]) < 1.0E-7) {
                dArray3[n2][0] = 0.0;
            }
            if (!(Math.abs(dArray3[n2][1]) < 1.0E-7)) continue;
            dArray3[n2][1] = 0.0;
        } while (++n2 < 4);
        n2 = 0;
        while (n2 < dArray3.length) {
            dArray3[n2][0] = dArray3[n2][0] - d2 / (4.0 * d);
            ++n2;
        }
        return dArray3;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double atanh(double d) {
        return 0.5 * Math.log((1.0 + d) / (1.0 - d));
    }
}

