/*
 * Decompiled with CFR 0.152.
 */
package gishur.core;

import gishur.core.BasicList;
import gishur.core.Comparitor;
import gishur.core.ListException;
import gishur.core.ListItem;
import java.util.Enumeration;

public class ListView {
    public static final int LISTVIEW_ACCESS = 2001;
    public static final int NO_ACCESS = 0;
    public static final int FULL_READ_ACCESS = 1023;
    public static final int SHOW_KEYS = 1;
    public static final int SHOW_VALUES = 2;
    public static final int SHOW_ITEMS = 4;
    public static final int SHOW_FIRST = 8;
    public static final int SHOW_LAST = 16;
    public static final int ALLOW_FIND = 32;
    public static final int ALLOW_STATISTICS = 64;
    public static final int ALLOW_NEXTPREV = 128;
    public static final int ALLOW_COMPARITORS = 256;
    public static final int ALLOW_CONVERSIONS = 512;
    public static final int ALLOW_NAVIGATION = 220;
    private int _access_mode = 0;
    private BasicList _owner = null;

    public final BasicList owner() {
        return this._owner;
    }

    public ListItem last() {
        this.testAccess(20);
        return this._owner.last();
    }

    public Object[] convertKeysToArray() {
        this.testAccess(513);
        if (this._owner.length() <= 0) {
            return new Object[0];
        }
        int n = this._owner.length();
        Object[] objectArray = new Object[n];
        this._owner.storeInArray(objectArray, 0, n, this._owner.first(), (byte)1, false);
        return objectArray;
    }

    public Enumeration keys() {
        this.testAccess(513);
        return this._owner.enumerate(null, null, -1, (byte)1);
    }

    public Object value(ListItem listItem) {
        this.testAccess(38);
        if (!this.contains(listItem)) {
            throw new ListException(1002);
        }
        return listItem.value();
    }

    public ListItem cyclicRelative(ListItem listItem, int n) {
        this.testAccess(132);
        return this._owner.getListItem(listItem, n, true);
    }

    public Enumeration values() {
        this.testAccess(514);
        return this._owner.enumerate(null, null, -1, (byte)2);
    }

    public Object firstKey() {
        this.testAccess(9);
        if (this._owner.length() > 0) {
            return this._owner.first().key();
        }
        throw new ListException(1000);
    }

    public Object lastKey() {
        this.testAccess(17);
        if (this._owner.length() > 0) {
            return this._owner.last().key();
        }
        throw new ListException(1000);
    }

    public ListItem min(Comparitor comparitor) {
        this.testAccess(293);
        return this._owner.findClosest(null, comparitor, (short)-1, null, null, -1, false);
    }

    public Object[] convertValuesToArray() {
        this.testAccess(514);
        if (this._owner.length() <= 0) {
            return new Object[0];
        }
        int n = this._owner.length();
        Object[] objectArray = new Object[n];
        this._owner.storeInArray(objectArray, 0, n, this._owner.first(), (byte)2, false);
        return objectArray;
    }

    public int length() {
        this.testAccess(64);
        return this._owner.length();
    }

    public final int getAccessMode() {
        return this._access_mode;
    }

    public ListItem findBigger(Object object, Comparitor comparitor) {
        this.testAccess(293);
        return this._owner.findClosest(object, comparitor, (short)1, null, null, -1, false);
    }

    private void testAccess(int n) {
        if ((this._access_mode & n) != n) {
            throw new ListException(1002);
        }
    }

    public ListItem findClass(Class clazz) {
        this.testAccess(37);
        return this._owner.findClass(clazz, 1, null, null, -1, false);
    }

    public int getDistance(ListItem listItem, ListItem listItem2) {
        this.testAccess(132);
        return this._owner.getDistance(listItem, listItem2);
    }

    public ListItem findClass(Class clazz, ListItem listItem) {
        this.testAccess(37);
        return this._owner.findClass(clazz, 1, null, null, -1, false);
    }

    public ListItem findClass(Class clazz, ListItem listItem, int n) {
        this.testAccess(37);
        return this._owner.findClass(clazz, n, null, null, -1, false);
    }

    public ListItem findBigger(Object object, Comparitor comparitor, ListItem listItem) {
        this.testAccess(293);
        return this._owner.findClosest(object, comparitor, (short)1, listItem, null, -1, false);
    }

    public Object firstValue() {
        this.testAccess(10);
        if (this._owner.length() > 0) {
            return this._owner.first().value();
        }
        throw new ListException(1000);
    }

    public Object lastValue() {
        this.testAccess(18);
        if (this._owner.length() > 0) {
            return this._owner.last().value();
        }
        throw new ListException(1000);
    }

    public Object cyclicRelativeValue(ListItem listItem, int n) {
        this.testAccess(130);
        ListItem listItem2 = this._owner.getListItem(listItem, n, false);
        if (listItem2 == null) {
            throw new ListException(1001);
        }
        return listItem2.value();
    }

    public Object getKeyAt(int n) {
        this.testAccess(129);
        ListItem listItem = this._owner.getListItem(null, n, false);
        if (listItem == null) {
            throw new ListException(1001);
        }
        return listItem.key();
    }

    public String toString() {
        return this.getClass().getName() + ":" + this._owner.toString();
    }

    public ListView(BasicList basicList, int n) {
        if (basicList == null || !basicList.requestAccess(2001, this, new Integer(n))) {
            throw new ListException(1002);
        }
        this._owner = basicList;
        this._access_mode = n;
    }

    public ListItem at(int n) {
        this.testAccess(132);
        return this._owner.getListItem(null, n, false);
    }

    public ListItem max(Comparitor comparitor) {
        this.testAccess(293);
        return this._owner.findClosest(null, comparitor, (short)1, null, null, -1, false);
    }

    public ListItem relative(ListItem listItem, int n) {
        this.testAccess(132);
        return this._owner.getListItem(listItem, n, false);
    }

    public ListItem findSmaller(Object object, Comparitor comparitor) {
        this.testAccess(293);
        return this._owner.findClosest(object, comparitor, (short)-1, null, null, -1, false);
    }

    public ListItem findSmaller(Object object, Comparitor comparitor, ListItem listItem) {
        this.testAccess(293);
        return this._owner.findClosest(object, comparitor, (short)-1, listItem, null, -1, false);
    }

    public boolean contains(ListItem listItem) {
        this.testAccess(36);
        return this._owner.contains(listItem);
    }

    public ListItem first() {
        this.testAccess(12);
        return this._owner.first();
    }

    public boolean contains(Object object) {
        this.testAccess(33);
        return this._owner.find(object, this._owner.first(), null, -1, false) != null;
    }

    public Object key(ListItem listItem) {
        this.testAccess(37);
        if (!this._owner.contains(listItem)) {
            throw new ListException(1002);
        }
        return listItem.key();
    }

    public Object getValueAt(int n) {
        this.testAccess(130);
        ListItem listItem = this._owner.getListItem(null, n, false);
        if (listItem == null) {
            throw new ListException(1001);
        }
        return listItem.value();
    }

    public int getIndex(ListItem listItem) {
        this.testAccess(132);
        return this._owner.getIndex(listItem, true);
    }

    public ListItem next(ListItem listItem) {
        this.testAccess(132);
        if (listItem == null) {
            return this._owner.first();
        }
        if (!this._owner.contains(listItem)) {
            return null;
        }
        return listItem.next();
    }

    public ListItem next(ListItem listItem, int n) {
        if (n <= 0) {
            return listItem;
        }
        this.testAccess(132);
        return this._owner.getListItem(listItem, n, false);
    }

    public boolean empty() {
        this.testAccess(64);
        return this._owner.empty();
    }

    public Object relativeValue(ListItem listItem, int n) {
        this.testAccess(130);
        ListItem listItem2 = this._owner.getListItem(listItem, n, false);
        if (listItem2 == null) {
            throw new ListException(1001);
        }
        return listItem2.value();
    }

    public ListItem find(ListItem listItem) {
        this.testAccess(36);
        if (this._owner.contains(listItem)) {
            return listItem;
        }
        return null;
    }

    public ListItem prev(ListItem listItem, int n) {
        if (n <= 0) {
            return listItem;
        }
        this.testAccess(132);
        if (listItem == null) {
            listItem = this._owner.last();
        }
        return this._owner.getListItem(listItem, -n, false);
    }

    public ListItem prev(ListItem listItem) {
        this.testAccess(132);
        if (listItem == null) {
            return this._owner.last();
        }
        if (!this._owner.contains(listItem)) {
            return null;
        }
        return listItem.prev();
    }

    public ListItem find(Object object) {
        this.testAccess(37);
        return this._owner.find(object, null, null, -1, false);
    }

    public ListItem find(Object object, ListItem listItem) {
        this.testAccess(37);
        return this._owner.find(object, listItem, null, -1, false);
    }

    public final boolean checkAccess(int n) {
        return (this._access_mode & n) == n;
    }
}

