/*
 * Decompiled with CFR 0.152.
 */
package gishur.core.algorithms;

import gishur.core.algorithms.TraceException;
import gishur.core.algorithms.TraceObject;
import gishur.core.algorithms.Tracer;
import java.util.Enumeration;

public class TraceLabel {
    public static final int NORMAL_TYPE = 0;
    private Tracer _parent = null;
    private TraceLabel _prev = null;
    private TraceLabel _next = null;
    private String _name = null;
    private int _type = 0;
    private long _timestamp = -1L;
    private int _step = -1;
    private int _level = 0;
    private int _level_nr = -1;

    public long time() {
        return this._timestamp;
    }

    public Object object(String string) {
        TraceObject traceObject = this._parent.object(string);
        if (traceObject == null) {
            return null;
        }
        return traceObject.instance(this._step);
    }

    int step() {
        return this._step;
    }

    public String toString() {
        return this.toString("", true);
    }

    TraceLabel(Tracer tracer, int n, String string, int n2, int n3) {
        if (tracer == null) {
            throw new TraceException(2562);
        }
        this._parent = tracer;
        this._timestamp = System.currentTimeMillis();
        this._step = n;
        this._type = n2;
        this._name = string;
        this._level = n3 < 0 ? 0 : n3;
    }

    synchronized void add(TraceLabel traceLabel) {
        traceLabel._timestamp -= this._next._timestamp;
        traceLabel._next = this._next;
        this._next._prev = traceLabel;
        traceLabel._prev = this;
        this._next = traceLabel;
        TraceLabel traceLabel2 = this;
        while (traceLabel2._level > traceLabel._level) {
            traceLabel2 = traceLabel2._prev;
        }
        if (traceLabel2._level < traceLabel._level) {
            traceLabel._level_nr = 1;
            return;
        }
        traceLabel._level_nr = traceLabel2._level_nr + 1;
    }

    TraceLabel next_pr() {
        return this._next;
    }

    public String toString(String string, boolean bl) {
        if (this._level < 0) {
            return (string == null ? "" : string) + (bl ? "TraceLabel[" + this._name + "]" : this._name);
        }
        if (this._parent.recordMode()) {
            return (string == null ? "" : string) + (bl ? "TraceLabel[" : "") + this._name + ",(recording)" + (bl ? "]" : "");
        }
        String string2 = (string == null ? "" : string) + (bl ? "TraceLabel[" : "");
        String string3 = "" + this._level_nr;
        TraceLabel traceLabel = this.prevUp();
        while (traceLabel != null && traceLabel._level >= 0) {
            string3 = traceLabel._level_nr + "." + string3;
            traceLabel = traceLabel.prevUp();
        }
        String string4 = "\n" + new String("                                                                                 ").substring(0, string2.length() + string3.length() - 2);
        string3 = string3 + " " + this._name + "(" + this._timestamp + "ms)";
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this._parent.objects();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(string4);
            TraceObject traceObject = (TraceObject)enumeration.nextElement();
            stringBuffer.append("   " + traceObject.name() + "=" + traceObject.instance(this._step));
        }
        return string2 + string3 + stringBuffer + (bl ? "]" : "");
    }

    public TraceLabel nextUp() {
        TraceLabel traceLabel = this._next;
        while (traceLabel != null && traceLabel._level >= this._level) {
            traceLabel = traceLabel._next;
        }
        if (traceLabel != null && traceLabel._level < 0) {
            traceLabel = null;
        }
        return traceLabel;
    }

    public int number() {
        return this._level_nr;
    }

    synchronized void initFirst() {
        this._next = this._prev = this;
        this._level = -1;
        this._step = -1;
    }

    public int type() {
        return this._type;
    }

    public Tracer parent() {
        return this._parent;
    }

    TraceLabel prev_pr() {
        return this._prev;
    }

    public TraceLabel prevUp() {
        TraceLabel traceLabel = this._prev;
        while (traceLabel != null && traceLabel._level >= this._level) {
            traceLabel = traceLabel._prev;
        }
        if (traceLabel != null && traceLabel._level < 0) {
            traceLabel = null;
        }
        return traceLabel;
    }

    public TraceLabel next() {
        if (this._next == null || this._next._level < 0) {
            return null;
        }
        return this._next;
    }

    public TraceLabel next(int n) {
        n = n >= 0 ? n : 0;
        TraceLabel traceLabel = this._next;
        while (traceLabel != null && traceLabel._level > n) {
            traceLabel = traceLabel._next;
        }
        if (traceLabel != null && traceLabel._level < 0) {
            traceLabel = null;
        }
        return traceLabel;
    }

    public Object[] objectHistory(String string) {
        TraceObject traceObject = this._parent.object(string);
        if (traceObject == null) {
            return null;
        }
        return traceObject.instances(this.prevUp()._step, this._step);
    }

    public int level() {
        return this._level;
    }

    public TraceLabel prev() {
        if (this._prev == null || this._prev._level < 0) {
            return null;
        }
        return this._prev;
    }

    public TraceLabel prev(int n) {
        n = n >= 0 ? n : 0;
        TraceLabel traceLabel = this._prev;
        while (traceLabel != null && traceLabel._level > n) {
            traceLabel = traceLabel._prev;
        }
        if (traceLabel != null && traceLabel._level < 0) {
            traceLabel = null;
        }
        return traceLabel;
    }

    public String name() {
        return this._name;
    }
}

