/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;

public abstract class PyDescriptor
extends PyObject
implements Traverseproc {
    protected PyType dtype;
    protected String name;

    protected void checkCallerType(PyType type) {
        if (type == this.dtype || type.isSubType(this.dtype)) {
            return;
        }
        String msg = String.format("descriptor '%s' requires a '%s' object but received a '%s'", this.name, this.dtype.fastGetName(), type.fastGetName());
        throw Py.TypeError(msg);
    }

    protected void checkGetterType(PyType type) {
        if (type == this.dtype || type.isSubType(this.dtype)) {
            return;
        }
        String msg = String.format("descriptor '%s' for '%s' objects doesn't apply to '%s' object", this.name, this.dtype.fastGetName(), type.fastGetName());
        throw Py.TypeError(msg);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        return this.dtype != null ? visit.visit(this.dtype, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob == this.dtype;
    }
}

