/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.swipe.swing.impl;

import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlCreationException;
import org.gvsig.fmap.mapcontrol.MapControlLocator;
import org.gvsig.fmap.mapcontrol.MapControlManager;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.PanListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomInListenerImpl;
import org.gvsig.fmap.mapcontrol.tools.ZoomOutListenerImpl;
import org.gvsig.swipe.swing.SwipePanel;
import org.gvsig.swipe.swing.SwipeSwingLocator;
import org.gvsig.swipe.swing.SwipeSwingManager;
import org.gvsig.swipe.swing.SwipeSwingServices;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.util.LabeledValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSwipePanel
implements SwipePanel {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractSwipePanel.class);
    private JSplitPane splitPanel;

    protected AbstractSwipePanel() {
    }

    public JComponent asJComponent() {
        return this.getView();
    }

    protected void configureCombosActions() throws LocatorException {
        SwipeSwingManager swingManager = SwipeSwingLocator.getSwipeSwingManager();
        SwipeSwingServices services = swingManager.getDefaultServices();
        MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
        this.getComboDocuments1().addActionListener(e -> {
            LabeledValue selectedItem1 = (LabeledValue)this.getComboDocuments1().getSelectedItem();
            MapContext selected = (MapContext)selectedItem1.getValue();
            IProjection proj = null;
            if (selected != null) {
                proj = selected.getProjection();
                final MapContext mCtx = selected.cloneFMap();
                LOGGER.info("SetMapContext " + mCtx.toString());
                this.getMapControl1().setMapContext(mCtx);
                mCtx.getViewPort().addViewPortListener(new ViewPortListener(){
                    private boolean changing;

                    public void extentChanged(ExtentEvent e) {
                        try {
                            if (this.changing) {
                                return;
                            }
                            this.changing = true;
                            AbstractSwipePanel.this.getMapControl2().getViewPort().setEnvelope(mCtx.getViewPort().getEnvelope());
                        }
                        catch (Exception ex) {
                            LOGGER.warn("Can't synchronize right view port.", (Throwable)ex);
                        }
                        finally {
                            this.changing = false;
                        }
                    }

                    public void backColorChanged(ColorEvent e) {
                    }

                    public void projectionChanged(ProjectionEvent e) {
                    }
                });
            }
            if (proj == null) {
                ComboBoxModel model1 = services.getDocumentsComboBoxModel();
                this.getComboDocuments2().setModel(model1);
                this.getComboDocuments2().setSelectedIndex(0);
                this.getComboDocuments2().setEnabled(false);
                this.getMapControl1().setMapContext(mapContextManager.createMapContext());
            } else {
                MapContext selected2 = null;
                LabeledValue selectedItem2 = (LabeledValue)this.getComboDocuments2().getSelectedItem();
                if (selectedItem2 != null) {
                    selected2 = (MapContext)selectedItem2.getValue();
                }
                if (selected2 == null || selected2.getProjection() != proj) {
                    ComboBoxModel model3 = services.getDocumentsComboBoxModel(proj);
                    this.getComboDocuments2().setModel(model3);
                    this.getComboDocuments2().setSelectedIndex(0);
                    this.getComboDocuments2().setEnabled(true);
                } else {
                    this.getComboDocuments2().setEnabled(true);
                }
            }
        });
        this.getComboDocuments2().addActionListener(e -> {
            LabeledValue selectedItem = (LabeledValue)this.getComboDocuments2().getSelectedItem();
            if (selectedItem != null) {
                MapContext selected = (MapContext)selectedItem.getValue();
                if (selected != null) {
                    final MapContext mCtx = selected.cloneFMap();
                    this.getMapControl2().setMapContext(mCtx);
                    this.getMapControl2().getViewPort().setEnvelope(this.getMapControl1().getViewPort().getEnvelope());
                    mCtx.getViewPort().addViewPortListener(new ViewPortListener(){
                        private boolean changing;

                        public void extentChanged(ExtentEvent e) {
                            try {
                                if (this.changing) {
                                    return;
                                }
                                this.changing = true;
                                AbstractSwipePanel.this.getMapControl1().getViewPort().setEnvelope(mCtx.getViewPort().getEnvelope());
                            }
                            catch (Exception ex) {
                                LOGGER.warn("Can't synchronize left view port.", (Throwable)ex);
                            }
                            finally {
                                this.changing = false;
                            }
                        }

                        public void backColorChanged(ColorEvent e) {
                        }

                        public void projectionChanged(ProjectionEvent e) {
                        }
                    });
                } else {
                    MapContext mCtx = mapContextManager.createMapContext();
                    this.getMapControl2().setMapContext(mCtx);
                }
            }
        });
    }

    protected void configureSplitPanel() {
        this.splitPanel = this.createSplitPanel();
        this.getMapControl1().setPreferredSize(this.getViewSplitPanel().getSize());
        this.getMapControl2().setPreferredSize(this.getViewSplitPanel().getSize());
        this.splitPanel.addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("dividerLocation")) {
                this.adjustJViewPortWindows();
            }
        });
        this.getViewSplitPanel().addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension panelSize = AbstractSwipePanel.this.getViewSplitPanel().getSize();
                AbstractSwipePanel.this.getMapControl2().setPreferredSize(panelSize);
                AbstractSwipePanel.this.getMapControl1().setPreferredSize(panelSize);
                AbstractSwipePanel.this.getMapControl2().revalidate();
                AbstractSwipePanel.this.getMapControl1().revalidate();
                AbstractSwipePanel.this.getMapControl2().getMapContext().invalidate();
                AbstractSwipePanel.this.getMapControl1().getMapContext().invalidate();
                AbstractSwipePanel.this.adjustJViewPortWindows();
            }
        });
        SwingUtilities.invokeLater(() -> this.splitPanel.setDividerLocation(0.5));
    }

    protected void configureCombos() throws LocatorException {
        SwipeSwingManager swingManager = SwipeSwingLocator.getSwipeSwingManager();
        SwipeSwingServices services = swingManager.getDefaultServices();
        ComboBoxModel model = services.getDocumentsComboBoxModel();
        this.getComboDocuments1().setModel(model);
        ComboBoxModel model2 = services.getDocumentsComboBoxModel();
        this.getComboDocuments2().setModel(model2);
        this.getComboDocuments1().setEnabled(true);
        this.getComboDocuments2().setEnabled(false);
    }

    protected MapControl createMapControl() {
        try {
            MapContextManager mapContextManager = MapContextLocator.getMapContextManager();
            MapContext mapCtx = mapContextManager.createMapContext();
            MapControlManager mapControlManager = MapControlLocator.getMapControlManager();
            MapControl mapControl = mapControlManager.createJMapControlPanel(mapCtx);
            mapControl.setMapControlDrawer(mapControlManager.createDefaultMapControlDrawer());
            ZoomOutListenerImpl zoomOutListener = new ZoomOutListenerImpl(mapControl);
            mapControl.addBehavior("zoomOut", (Behavior)new PointBehavior((PointListener)zoomOutListener));
            ZoomInListenerImpl zoomInListener = new ZoomInListenerImpl(mapControl);
            mapControl.addBehavior("zoomIn", new Behavior[]{new RectangleBehavior((RectangleListener)zoomInListener), new PointBehavior((PointListener)zoomOutListener, 4)});
            PanListenerImpl panListener = new PanListenerImpl(mapControl);
            mapControl.addBehavior("pan", (Behavior)new MoveBehavior((PanListener)panListener, 1));
            mapControl.addCombinedBehavior((Behavior)new MouseWheelBehavior());
            mapControl.addCombinedBehavior((Behavior)new MoveBehavior((PanListener)panListener, 2));
            mapControl.setTool("zoomIn");
            return mapControl;
        }
        catch (MapControlCreationException ex) {
            throw new RuntimeException("Can't create map control", ex);
        }
    }

    protected void doZoomAllView1() {
        try {
            this.getMapControl1().getViewPort().setEnvelope(this.getMapControl1().getMapContext().getFullEnvelope());
        }
        catch (Exception ex) {
            LOGGER.trace("Can't zoom to all left view.", (Throwable)ex);
        }
    }

    protected void doZoomAllView2() {
        try {
            this.getMapControl2().getViewPort().setEnvelope(this.getMapControl2().getMapContext().getFullEnvelope());
        }
        catch (Exception ex) {
            LOGGER.trace("Can't zoom to all right view.", (Throwable)ex);
        }
    }

    protected abstract MapControl getMapControl1();

    protected abstract MapControl getMapControl2();

    protected abstract JComboBox<LabeledValue<MapContext>> getComboDocuments1();

    protected abstract JComboBox<LabeledValue<MapContext>> getComboDocuments2();

    protected abstract void adjustJViewPortWindows();

    protected abstract JSplitPane createSplitPanel();

    protected abstract JComponent getView();

    protected abstract JPanel getViewSplitPanel();
}

