/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.eventtheme.dal.feature;

import java.util.Arrays;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.feature.AbstractFeatureStoreTransform;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryTypeNotSupportedException;
import org.gvsig.fmap.geom.type.GeometryTypeNotValidException;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventThemeTransform
extends AbstractFeatureStoreTransform {
    private static Logger LOGGER = LoggerFactory.getLogger(EventThemeTransform.class);
    public static final String PERSISTENCE_DEFINITION_NAME = "EventThemeTransform";
    public static int MAX_INI_FEATURES = 200;
    private String xFieldName = null;
    private String yFieldName = null;
    private String geometryFieldName = null;
    private IProjection projection = null;
    private FeatureType originalFeatureType;
    private GeometryManager geometryManager = GeometryLocator.getGeometryManager();
    private Envelope envelope;

    public void setValues(FeatureStore store, String geometryFieldName, String xFieldName, String yFieldName, IProjection projection) throws DataException {
        this.setFeatureStore(store);
        this.xFieldName = xFieldName;
        this.yFieldName = yFieldName;
        this.projection = projection;
        this.geometryFieldName = StringUtils.isEmpty((CharSequence)geometryFieldName) ? "the_geom" : geometryFieldName;
    }

    public void setUp() throws Exception {
        this.originalFeatureType = this.getFeatureStore().getDefaultFeatureType();
        EditableFeatureType type = this.originalFeatureType.getEditable();
        if (type.get(this.geometryFieldName) == null) {
            EditableFeatureAttributeDescriptor attributeDescriptor = type.add(this.geometryFieldName, 66);
            try {
                attributeDescriptor.setGeometryType(this.geometryManager.getGeometryType(1, 0));
            }
            catch (GeometryTypeNotSupportedException | GeometryTypeNotValidException e) {
                throw new InitializeException(e);
            }
            attributeDescriptor.setSRS(this.projection);
            attributeDescriptor.setFeatureAttributeEmulator(new FeatureAttributeEmulator(){

                public Object get(Feature feature) {
                    Point point = null;
                    Object xval = feature.get(EventThemeTransform.this.xFieldName);
                    Object yval = feature.get(EventThemeTransform.this.yFieldName);
                    if (xval == null || yval == null) {
                        LOGGER.info("Found row with null coordinates in event theme (created null geometry)");
                        return null;
                    }
                    try {
                        point = EventThemeTransform.this.geometryManager.createPoint(Double.parseDouble(xval.toString()), Double.parseDouble(yval.toString()), 0);
                    }
                    catch (org.gvsig.fmap.geom.exception.CreateGeometryException createGeometryException) {
                        // empty catch block
                    }
                    return point;
                }

                public void set(EditableFeature feature, Object value) {
                    throw new UnsupportedOperationException("Not supported yet.");
                }

                public boolean allowSetting() {
                    return false;
                }

                public String[] getRequiredFieldNames() {
                    return new String[]{EventThemeTransform.this.xFieldName, EventThemeTransform.this.yFieldName};
                }

                public JsonObject toJson() {
                    return null;
                }

                public JsonObjectBuilder toJsonBuilder() {
                    return null;
                }

                public void fromJson(JsonObject json) {
                }
            });
        }
        try {
            this.initEnvelope(this.getFeatureStore(), MAX_INI_FEATURES);
        }
        catch (CreateEnvelopeException e) {
            throw new CreateGeometryException((Throwable)e);
        }
        type.setDefaultGeometryAttributeName(this.geometryFieldName);
        FeatureType[] types = new FeatureType[]{type.getNotEditableCopy()};
        this.setFeatureTypes(Arrays.asList(types), types[0]);
    }

    private void initEnvelope(FeatureStore theStore, int max_feats) throws CreateEnvelopeException {
        this.envelope = this.geometryManager.createEnvelope(0);
        FeatureSet fset = null;
        DisposableIterator diter = null;
        Feature feat = null;
        try {
            fset = theStore.getFeatureSet();
            diter = fset.fastIterator();
            int countused = 0;
            int nextwait = 1;
            int index = 0;
            while (diter.hasNext() && countused < max_feats) {
                feat = (Feature)diter.next();
                if (++index != nextwait) continue;
                index = 0;
                if (countused > 5) {
                    ++nextwait;
                }
                this.updateEnvelope(feat);
                ++countused;
            }
            diter.dispose();
        }
        catch (Exception dex) {
            throw new CreateEnvelopeException(0, (Throwable)dex);
        }
    }

    public void setEnvelope(Envelope env) {
        this.envelope = env;
    }

    public void applyTransform(Feature source, EditableFeature target) throws DataException {
        target.copyFrom(source);
    }

    private void updateEnvelope(Feature feat) throws org.gvsig.fmap.geom.exception.CreateGeometryException {
        Point point = this.geometryManager.createPoint(Double.parseDouble(feat.get(this.xFieldName).toString()), Double.parseDouble(feat.get(this.yFieldName).toString()), 0);
        this.envelope.add(point.getEnvelope());
    }

    public FeatureType getSourceFeatureTypeFrom(FeatureType targetFeatureType) {
        return this.originalFeatureType;
    }

    public boolean isTransformsOriginalValues() {
        return true;
    }

    public static void registerPersistent() {
        DynStruct definition;
        PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
        if (persistenceManager.getDefinition(AbstractFeatureStoreTransform.class) == null) {
            AbstractFeatureStoreTransform.registerPersistent();
        }
        if ((definition = persistenceManager.getDefinition(PERSISTENCE_DEFINITION_NAME)) == null) {
            definition = persistenceManager.addDefinition(EventThemeTransform.class, PERSISTENCE_DEFINITION_NAME, "EventThemeTransform Persistence definition", null, null);
            definition.extend("Persistence", "AbstractFeatureStoreTransform");
            definition.addDynFieldString("geometryFieldName").setMandatory(true);
            definition.addDynFieldString("xFieldName").setMandatory(true);
            definition.addDynFieldString("yFieldName").setMandatory(true);
            definition.addDynFieldObject("projection").setType(65);
        }
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set("geometryFieldName", this.geometryFieldName);
        state.set("xFieldName", this.xFieldName);
        state.set("yFieldName", this.yFieldName);
        state.set("projection", (Object)this.projection);
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.geometryFieldName = state.getString("geometryFieldName");
        this.xFieldName = state.getString("xFieldName");
        this.yFieldName = state.getString("yFieldName");
        this.projection = (IProjection)state.get("projection");
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if ("CRS".equals(name)) {
            return this.projection;
        }
        if ("Envelope".equals(name)) {
            return this.envelope;
        }
        return null;
    }

    public boolean hasDynValue(String name) {
        return "CRS".equals(name) || "Envelope".equals(name);
    }
}

