/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.wmts.io;

import java.awt.geom.Rectangle2D;
import java.util.List;
import org.cresques.cts.IProjection;
import org.gvsig.compat.net.ICancellable;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.coverage.store.RasterDataServerExplorer;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.wmts.io.WMTSDataParameters;
import org.gvsig.raster.wmts.io.WMTSProvider;
import org.gvsig.raster.wmts.io.WMTSServerExplorer;
import org.gvsig.raster.wmts.ogc.WMTSClient;
import org.gvsig.raster.wmts.ogc.struct.WMTSLayer;
import org.gvsig.raster.wmts.ogc.struct.WMTSStyle;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DelegatedDynObject;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.LoggerFactory;

public class WMTSDataParametersImpl
extends AbstractRasterDataParameters
implements WMTSDataParameters {
    private DelegatedDynObject delegatedDynObject = null;
    private WMTSClient ogcClient = null;
    private ICancellable cancel = null;
    private WMTSStyle style = null;
    private WMTSLayer layer = null;

    public WMTSDataParametersImpl() {
        this.initialize();
    }

    protected void initialize() {
        this.delegatedDynObject = (DelegatedDynObject)ToolsLocator.getDynObjectManager().createDynObject(WMTSDataParametersImpl.registerDynClass());
    }

    public static DynStruct registerDynClass() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition("WMTSDataParameters_Persistent");
        if (definition == null) {
            definition = manager.addDefinition(WMTSDataParametersImpl.class, "WMTSDataParameters_Persistent", "WMTS DataParameters Persistency", null, null);
        }
        AbstractRasterDataParameters.registerDynClass((DynStruct)definition);
        definition.addDynFieldBoolean("deletecache").setDescription("Flag to delete cache the next request").setMandatory(false);
        definition.addDynFieldInt("width").setDescription("Width").setMandatory(false);
        definition.addDynFieldInt("height").setDescription("Height").setMandatory(false);
        definition.addDynFieldBoolean("override").setDescription("Override a host capabilities").setMandatory(false);
        definition.addDynFieldString("srsstr").setDescription("String that represents the SRS").setMandatory(false);
        definition.addDynFieldString("name").setDescription("Layer name").setMandatory(false);
        definition.addDynFieldString("infoformat").setDescription("Info Format").setMandatory(false);
        definition.addDynFieldString("imageformat").setDescription("Image Format").setMandatory(false);
        definition.addDynFieldString("style").setDescription("Style").setMandatory(false);
        definition.addDynFieldObject("extent").setClassOfValue(Rectangle2D.class).setDescription("Bounding box").setMandatory(false);
        definition.addDynFieldString("dimension").setDescription("Dimensions").setMandatory(false);
        definition.addDynFieldString("selected_dimension_value").setDescription("Value selected for the current dimension").setMandatory(false);
        return definition;
    }

    @Override
    public String getDimension() {
        return (String)this.getDynValue("dimension");
    }

    @Override
    public void setDimension(String dimension) {
        this.setDynValue("dimension", dimension);
    }

    @Override
    public String getDimensionSelectedValue() {
        return (String)this.getDynValue("selected_dimension_value");
    }

    @Override
    public void setDimensionSelectedValue(String dimension) {
        this.setDynValue("selected_dimension_value", dimension);
    }

    @Override
    public Rectangle2D getExtent() {
        return (Rectangle2D)this.getDynValue("extent");
    }

    @Override
    public void setExtent(Rectangle2D bBox) {
        this.setDynValue("extent", bBox);
    }

    @Override
    public void setStyle(WMTSStyle style) {
        this.setDynValue("style", style.getTitle());
        this.style = style;
    }

    @Override
    public WMTSStyle getStyle() {
        return this.style;
    }

    @Override
    public String getImageFormat() {
        return (String)this.getDynValue("imageformat");
    }

    @Override
    public void setImageFormat(String format) {
        this.setDynValue("imageformat", format);
    }

    @Override
    public String getInfoFormat() {
        return (String)this.getDynValue("infoformat");
    }

    @Override
    public void setInfoFormat(String format) {
        this.setDynValue("infoformat", format);
    }

    @Override
    public String getSRSCode() {
        return (String)this.getDynValue("srsstr");
    }

    @Override
    public void setSRS(String m_srs) {
        m_srs = this.srsValidation(m_srs);
        this.setDynValue("srsstr", m_srs);
        if (this.getEPSG(m_srs) != null) {
            this.setSRS(CRSFactory.getCRS((String)this.getEPSG(m_srs)));
        }
    }

    private String srsValidation(String srs) {
        if (srs == null) {
            return null;
        }
        if (srs.contains("CRS:84") || srs.contains("CRS84")) {
            return "EPSG:4326";
        }
        if (srs.startsWith("EPSG") && !srs.startsWith("EPSG:")) {
            return "EPSG:" + srs.substring(srs.lastIndexOf("EPSG") + 1);
        }
        if (srs.contains("EPSG:") && !srs.startsWith("EPSG:")) {
            return "EPSG:" + srs.substring(srs.lastIndexOf(":") + 1);
        }
        return srs;
    }

    @Override
    public boolean isProjected() {
        IProjection proj = this.getSRS();
        if (proj == null) {
            return true;
        }
        try {
            return proj.isProjected();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(WMTSDataParameters.class).debug("error in projection", (Throwable)e);
            return true;
        }
    }

    @Override
    public String getEPSG(String value) {
        if (value != null) {
            if (value.compareTo("CRS:84") == 0) {
                return "EPSG:4326";
            }
            String s = value.substring(value.lastIndexOf(":") + 1);
            return "EPSG:" + s;
        }
        return null;
    }

    @Override
    public String getName() {
        return (String)this.getDynValue("name");
    }

    @Override
    public void setName(String name) {
        this.setDynValue("name", name);
    }

    @Override
    public boolean isOverridingHost() {
        Boolean b = (Boolean)this.getDynValue("override");
        if (b != null) {
            return b;
        }
        return false;
    }

    @Override
    public void setOverrideHost(boolean over) {
        this.setDynValue("override", new Boolean(over));
    }

    @Override
    public void setWidth(int w) {
        this.setDynValue("width", new Integer(w));
    }

    @Override
    public void setHeight(int h) {
        this.setDynValue("height", new Integer(h));
    }

    @Override
    public int getWidth() {
        Integer b = (Integer)this.getDynValue("width");
        if (b != null) {
            return b;
        }
        return 0;
    }

    @Override
    public int getHeight() {
        Integer b = (Integer)this.getDynValue("height");
        if (b != null) {
            return b;
        }
        return 0;
    }

    public void deleteCache(boolean deleteCache) {
        this.setDynValue("deletecache", new Boolean(deleteCache));
    }

    public boolean isDeletingCache() {
        return (Boolean)this.getDynValue("deletecache");
    }

    public String getDataStoreName() {
        return WMTSProvider.NAME;
    }

    public String getDescription() {
        return WMTSProvider.DESCRIPTION;
    }

    public String getExplorerName() {
        return WMTSServerExplorer.NAME;
    }

    public boolean isValid() {
        return this.getURI() != null;
    }

    protected DelegatedDynObject getDelegatedDynObject() {
        return this.delegatedDynObject;
    }

    public WMTSDataParameters clone() {
        WMTSDataParametersImpl p = new WMTSDataParametersImpl();
        p.setImageFormat(this.getImageFormat());
        p.setInfoFormat(this.getInfoFormat());
        p.setHeight(this.getHeight());
        p.setWidth(this.getWidth());
        p.setExtent(this.getExtent());
        p.setURI(this.getURI());
        p.setName(this.getName());
        p.setOverrideHost(this.isOverridingHost());
        p.setSRS(this.getSRS());
        p.setSRS(this.getSRSCode());
        p.setCancellable(this.getCancellable());
        return p;
    }

    @Override
    public boolean isSizeFixed() {
        return true;
    }

    @Override
    public WMTSClient getOGCClient() {
        return this.ogcClient;
    }

    @Override
    public void setOGCClient(WMTSClient ogcClient) {
        this.ogcClient = ogcClient;
    }

    @Override
    public void setLayer(WMTSLayer layer) {
        this.setName(layer.getTitle());
        this.layer = layer;
    }

    @Override
    public WMTSLayer getLayer() {
        return this.layer;
    }

    @Override
    public void setCancellable(ICancellable cancel) {
        this.cancel = cancel;
    }

    @Override
    public ICancellable getCancellable() {
        return this.cancel;
    }

    public void assignFields(RasterDataParameters par, RasterDataServerExplorer explorer) {
        super.assignFields(par, explorer);
        WMTSDataParameters p = null;
        if (!(par instanceof WMTSDataParameters)) {
            return;
        }
        p = (WMTSDataParameters)par;
        this.setWidth(p.getWidth());
        this.setHeight(p.getHeight());
        this.setImageFormat(p.getImageFormat());
        this.setInfoFormat(p.getInfoFormat());
        this.setName(p.getName());
        this.setSRS(p.getSRSCode());
        this.setOverrideHost(p.isOverridingHost());
        this.setExtent(p.getExtent());
        if (explorer instanceof WMTSServerExplorer) {
            WMTSLayer wmtsLayer = ((WMTSServerExplorer)explorer).getOGCClient().getLayer(p.getName());
            this.setLayer(wmtsLayer);
            List wmtsStyles = wmtsLayer.getStyle();
            for (int i = 0; i < wmtsStyles.size(); ++i) {
                WMTSStyle style = (WMTSStyle)wmtsStyles.get(i);
                if (style.getTitle() == null || !style.getTitle().equals((String)this.getDynValue("style"))) continue;
                this.style = style;
            }
            if (this.style == null && wmtsStyles.size() > 0) {
                this.style = (WMTSStyle)wmtsStyles.get(0);
            }
        }
    }
}

