/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.driver.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gvsig.fmap.mapcontext.exceptions.WriteLegendException;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.legend.driver.ILegendWriter;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.persistence.PersistenceManager;

public class PersistenceBasedLegendWriter
implements ILegendWriter {
    public static final String LONG_LEGEND_PERSISTENCE_FORMAT = "application/zip; subtype=gvsleg";

    public void write(ILegend legend, File outFile, String format) throws WriteLegendException, IOException {
        String legext = ".gvsleg".substring(1).toLowerCase();
        String fmt = format.toLowerCase();
        if (fmt.compareTo(legext) != 0 && fmt.compareTo(LONG_LEGEND_PERSISTENCE_FORMAT) != 0) {
            throw new WriteLegendException(legend, (Throwable)new Exception("Unexpected format requested: " + format));
        }
        FileOutputStream fos = new FileOutputStream(outFile);
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        manager.putObject((OutputStream)fos, (Object)legend);
        fos.close();
    }
}

