/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.aggregate.MultiSurface;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.task.Cancellable;

public class DrawUtils {
    private static GeometryManager geometryManager = null;

    private static GeometryManager getGeometryManager() {
        if (geometryManager == null) {
            geometryManager = GeometryLocator.getGeometryManager();
        }
        return geometryManager;
    }

    public static void drawInts(Graphics2D g, ViewPort viewPort, Cancellable cancel, double dpi, ISymbol symbol, Feature feature, Geometry geom) throws GeometryOperationException {
        try {
            if (geom instanceof Aggregate) {
                for (Geometry prim : (Aggregate)geom) {
                    DrawUtils.drawInts(g, viewPort, cancel, dpi, symbol, feature, prim);
                }
                return;
            }
            ((CartographicSupport)symbol).setCartographicContext(viewPort, dpi, geom);
            Geometry transformedGeometry = DrawUtils.transformGeometry(geom.cloneGeometry(), viewPort.getAffineTransform());
            symbol.draw(g, null, transformedGeometry, feature, cancel);
        }
        catch (GeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    public static void drawInts(Graphics2D g, ViewPort viewPort, ISymbol symbol, Feature feature, Geometry geom) throws GeometryOperationException {
        try {
            if (geom instanceof Aggregate) {
                for (Geometry prim : (Aggregate)geom) {
                    DrawUtils.drawInts(g, viewPort, symbol, feature, prim);
                }
                return;
            }
            Geometry transformedGeometry = DrawUtils.transformGeometry(geom.cloneGeometry(), viewPort.getAffineTransform());
            symbol.draw(g, viewPort.getAffineTransform(), transformedGeometry, feature, null);
        }
        catch (GeometryException e) {
            throw new GeometryOperationException((Exception)((Object)e));
        }
    }

    private static Geometry transformGeometry(Geometry geom, AffineTransform affineTransform) throws GeometryException {
        if (geom.canBeTransformed(affineTransform)) {
            geom.transform(affineTransform);
            return geom;
        }
        if (geom instanceof Curve || geom instanceof Curve) {
            MultiLine lines = geom.toLines();
            lines.transform(affineTransform);
            return lines;
        }
        if (geom instanceof Surface || geom instanceof MultiSurface) {
            MultiPolygon polygons = geom.toPolygons();
            polygons.transform(affineTransform);
            return polygons;
        }
        return null;
    }
}

