/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.impl;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.impl.AbstractSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol_v2;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.style.IMask;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.Callable;

public abstract class AbstractMarkerSymbol
extends AbstractSymbol
implements IMarkerSymbol_v2 {
    public static final String MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME = "MarkerSymbol";
    private static final String FIELD_COLOR = "color";
    private static final String FIELD_ROTATION = "rotation";
    private static final String FIELD_OFFSET = "offset";
    private static final String FIELD_SIZE = "size";
    private static final String FIELD_MASK = "mask";
    private static final String FIELD_LINETOOFFSETCOLOR = "lineToOffsetColor";
    private static final String FIELD_DRAWLINETOOFFSET = "drawLineToOffset";
    private static final String FIELD_SIZE_EXPRESSION = "sizeExpression";
    private static final String FIELD_OFFSETX_EXPRESSION = "offsetXExpression";
    private static final String FIELD_OFFSETY_EXPRESSION = "offsetYExpression";
    private static final String FIELD_ROTATION_EXPRESSION = "rotationExpression";
    private static final String FIELD_LINETOOFFSETCOLOR_EXPRESSION = "lineToOffsetColorExpression";
    private static final GeometryManager GEOMETRY_MANAGER = GeometryLocator.getGeometryManager();
    private Color color;
    private double rotationDegrees;
    private Point2D offset = new Point2D.Double();
    private double size = 4.0;
    private IMask mask;
    private Color lineToOffsetColor;
    private boolean drawLineToOffset;
    private String sizeExpression;
    private String offsetXExpression;
    private String offsetYExpression;
    private String rotationExpression;
    private String lineToOffsetColorExpression;
    private transient Point point;
    private FeatureSymbolTable symbolTable = null;

    public AbstractMarkerSymbol() {
        this.color = MapContextLocator.getSymbolManager().getSymbolPreferences().getDefaultSymbolFillColor();
        this.lineToOffsetColor = Color.BLACK;
        try {
            this.point = GEOMETRY_MANAGER.createPoint(0.0, 0.0, 0);
        }
        catch (CreateGeometryException createGeometryException) {
            // empty catch block
        }
    }

    protected Point getPoint(double x, double y) {
        this.point.setX(x);
        this.point.setY(y);
        return this.point;
    }

    public final int getSymbolType() {
        return 1;
    }

    public double getRotation() {
        return this.getRotationInDegrees();
    }

    public void setRotation(double r) {
        this.setRotationInDegrees(r);
    }

    public double getRotationInDegrees() {
        return this.rotationDegrees;
    }

    public void setRotationInDegrees(double r) {
        this.rotationDegrees = r;
        this.setRotationExpression(null);
    }

    public double getRotationInRadians() {
        return Math.toRadians(this.rotationDegrees);
    }

    public void setRotationInRadians(double r) {
        this.rotationDegrees = Math.toDegrees(r);
        this.setRotationExpression(null);
    }

    public Point2D getOffset() {
        if (this.offset == null) {
            this.offset = new java.awt.Point();
        }
        return this.offset;
    }

    public void setOffset(Point2D offset) {
        this.offset = offset;
    }

    protected SymbolTable getSymbolTable(Feature f) {
        if (this.symbolTable == null) {
            this.symbolTable = DALLocator.getManager().createFeatureSymbolTable();
            this.symbolTable.addSymbolTable((SymbolTable)ExpressionUtils.createSymbolTable());
        }
        this.symbolTable.setFeature(f);
        return this.symbolTable;
    }

    public Color getLineToOffsetColor() {
        return this.lineToOffsetColor;
    }

    public void setLineToOffsetColor(Color color) {
        this.lineToOffsetColor = color;
    }

    public boolean isDrawLineToOffset() {
        return this.drawLineToOffset;
    }

    public void setDrawLineToOffset(boolean drawLineToOffset) {
        this.drawLineToOffset = drawLineToOffset;
    }

    public String getOffsetXExpression() {
        return this.offsetXExpression;
    }

    public void setOffsetXExpression(String offsetXExpression) {
        this.offsetXExpression = StringUtils.trimToNull((String)offsetXExpression);
    }

    public String getOffsetYExpression() {
        return this.offsetYExpression;
    }

    public void setOffsetYExpression(String offsetYExpression) {
        this.offsetYExpression = StringUtils.trimToNull((String)offsetYExpression);
    }

    public String getRotationExpression() {
        return this.rotationExpression;
    }

    public void setRotationExpression(String rotationExpression) {
        this.rotationExpression = StringUtils.trimToNull((String)rotationExpression);
    }

    public String getSizeExpression() {
        return this.sizeExpression;
    }

    public void setSizeExpression(String sizeExpression) {
        this.sizeExpression = StringUtils.trimToNull((String)sizeExpression);
    }

    public String getLineToOffsetColorExpression() {
        return this.lineToOffsetColorExpression;
    }

    public void setLineToOffsetColorExpression(String lineToOffsetColorExpression) {
        this.lineToOffsetColorExpression = StringUtils.trimToNull((String)lineToOffsetColorExpression);
    }

    public Point2D getEfectiveOffset(Feature f) {
        Point2D p;
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null || StringUtils.isBlank((CharSequence)this.offsetXExpression) || StringUtils.isBlank((CharSequence)this.offsetYExpression)) {
            p = this.getOffset();
            p = new Point2D.Double(this.toCartographicUnits(p.getX()), this.toCartographicUnits(p.getY()));
        } else {
            double offsetX = this.toCartographicUnits(ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.offsetXExpression, (double)((int)this.getOffset().getX())));
            double offsetY = this.toCartographicUnits(ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.offsetYExpression, (double)((int)this.getOffset().getY())));
            p = new Point2D.Double(offsetX, offsetY);
        }
        return p;
    }

    public double getEfectiveRotationInDegres(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.rotationExpression)) {
            return this.getRotationInDegrees();
        }
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null) {
            return this.getRotationInDegrees();
        }
        double r = ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.rotationExpression, (double)this.getRotationInDegrees());
        return r;
    }

    public double getEfectiveRotationInRadians(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.rotationExpression)) {
            return this.getRotationInRadians();
        }
        double r = this.getEfectiveRotationInDegres(f);
        if (r == 0.0) {
            return 0.0;
        }
        r = Math.toRadians(r);
        return r;
    }

    public Color getEfectiveLineToOffsetColor(Feature f) {
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null || StringUtils.isBlank((CharSequence)this.lineToOffsetColorExpression)) {
            return this.getLineToOffsetColor();
        }
        Color theColor = ExpressionUtils.parseColor((SymbolTable)this.getSymbolTable(f), (String)this.lineToOffsetColorExpression, (Color)this.getLineToOffsetColor());
        return theColor;
    }

    public double getEfectiveSize(Feature f) {
        if (StringUtils.isBlank((CharSequence)this.sizeExpression)) {
            return this.getCartographicSize();
        }
        if (f == null) {
            f = this.getFeature();
        }
        if (f == null) {
            return this.getCartographicSize();
        }
        double sz = ExpressionUtils.parseDouble((SymbolTable)this.getSymbolTable(f), (String)this.sizeExpression, (double)-1.0);
        if (sz < 0.0) {
            return this.getCartographicSize();
        }
        return this.toCartographicUnits(sz);
    }

    public boolean isSuitableFor(Geometry geom) {
        return geom.getType() == 1;
    }

    public double getSize() {
        return this.size;
    }

    public void setSize(double size) {
        this.size = size;
        this.setSizeExpression(null);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setAlpha(int outlineAlpha) {
        Color theColor = this.getColor();
        this.setColor(new Color(theColor.getRed(), theColor.getGreen(), theColor.getBlue(), outlineAlpha));
    }

    public final IMask getMask() {
        return this.mask;
    }

    public final void setMask(IMask mask) {
        this.mask = mask;
    }

    protected double getCartographicSize() {
        return this.toCartographicUnits(this.getSize());
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractMarkerSymbol copy = (AbstractMarkerSymbol)((Object)super.clone());
        if (this.offset != null) {
            copy.offset = (Point2D)this.offset.clone();
        }
        if (this.mask != null) {
            copy.mask = (IMask)this.mask.clone();
        }
        return copy;
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.setColor((Color)state.get(FIELD_COLOR));
        this.setMask((IMask)state.get(FIELD_MASK));
        this.setOffset((Point2D)state.get(FIELD_OFFSET));
        this.setRotation(state.getDouble(FIELD_ROTATION));
        this.setSize(state.getDouble(FIELD_SIZE));
        this.setDrawLineToOffset(state.getBoolean(FIELD_DRAWLINETOOFFSET, false));
        this.setLineToOffsetColor((Color)state.get(FIELD_LINETOOFFSETCOLOR));
        this.setSizeExpression(state.getString(FIELD_SIZE_EXPRESSION));
        this.setOffsetXExpression(state.getString(FIELD_OFFSETX_EXPRESSION));
        this.setOffsetYExpression(state.getString(FIELD_OFFSETY_EXPRESSION));
        this.setRotationExpression(state.getString(FIELD_ROTATION_EXPRESSION));
        this.setLineToOffsetColorExpression(state.getString(FIELD_LINETOOFFSETCOLOR_EXPRESSION));
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(FIELD_COLOR, (Object)this.getColor());
        state.set(FIELD_MASK, (Persistent)this.getMask());
        state.set(FIELD_OFFSET, (Object)this.getOffset());
        state.set(FIELD_ROTATION, this.getRotation());
        state.set(FIELD_SIZE, this.getSize());
        state.set(FIELD_LINETOOFFSETCOLOR, (Object)this.getLineToOffsetColor());
        state.set(FIELD_DRAWLINETOOFFSET, this.isDrawLineToOffset());
        state.set(FIELD_OFFSETX_EXPRESSION, this.getOffsetXExpression());
        state.set(FIELD_OFFSETY_EXPRESSION, this.getOffsetYExpression());
        state.set(FIELD_SIZE_EXPRESSION, this.getSizeExpression());
        state.set(FIELD_ROTATION_EXPRESSION, this.getRotationExpression());
        state.set(FIELD_LINETOOFFSETCOLOR_EXPRESSION, this.getLineToOffsetColorExpression());
    }

    protected double getAdjustedSize(Rectangle r, double size) {
        if (r == null) {
            return size;
        }
        double min = Math.min(r.getHeight(), r.getWidth());
        if (size > min) {
            size = min;
        }
        return size;
    }

    protected Geometry getSampleGeometry(Rectangle r) {
        GeometryManager geomManager = GeometryLocator.getGeometryManager();
        try {
            return geomManager.createEnvelope((double)(r.x + 1), (double)(r.y + 1), (double)(r.x + r.width - 2), (double)(r.y + r.height - 2), 0).getGeometry();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create smple geometry.", e);
        }
    }

    public static class RegisterPersistence
    implements Callable {
        public Object call() throws Exception {
            PersistenceManager manager = ToolsLocator.getPersistenceManager();
            if (manager.getDefinition(AbstractMarkerSymbol.MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME) == null) {
                DynStruct definition = manager.addDefinition(AbstractMarkerSymbol.class, AbstractMarkerSymbol.MARKER_SYMBOL_PERSISTENCE_DEFINITION_NAME, "MarkerSymbol Persistence definition", null, null);
                definition.extend(manager.getDefinition("Symbol"));
                definition.addDynFieldObject(AbstractMarkerSymbol.FIELD_COLOR).setMandatory(false).setClassOfValue(Color.class);
                definition.addDynFieldObject(AbstractMarkerSymbol.FIELD_MASK).setMandatory(false).setClassOfValue(IMask.class);
                definition.addDynFieldObject(AbstractMarkerSymbol.FIELD_OFFSET).setMandatory(false).setClassOfValue(Point2D.class);
                definition.addDynFieldDouble(AbstractMarkerSymbol.FIELD_ROTATION).setMandatory(false);
                definition.addDynFieldDouble(AbstractMarkerSymbol.FIELD_SIZE).setMandatory(false);
                definition.addDynFieldBoolean(AbstractMarkerSymbol.FIELD_DRAWLINETOOFFSET).setMandatory(false);
                definition.addDynFieldObject(AbstractMarkerSymbol.FIELD_LINETOOFFSETCOLOR).setClassOfValue(Color.class).setMandatory(false);
                definition.addDynFieldString(AbstractMarkerSymbol.FIELD_OFFSETX_EXPRESSION).setMandatory(false);
                definition.addDynFieldString(AbstractMarkerSymbol.FIELD_OFFSETY_EXPRESSION).setMandatory(false);
                definition.addDynFieldString(AbstractMarkerSymbol.FIELD_LINETOOFFSETCOLOR_EXPRESSION).setMandatory(false);
                definition.addDynFieldString(AbstractMarkerSymbol.FIELD_ROTATION_EXPRESSION).setMandatory(false);
                definition.addDynFieldString(AbstractMarkerSymbol.FIELD_SIZE_EXPRESSION).setMandatory(false);
            }
            return true;
        }
    }
}

