/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.multifile.app.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.gui.beans.table.TableContainer;
import org.gvsig.gui.beans.table.exceptions.NotInitializeException;
import org.gvsig.i18n.Messages;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.fmap.layers.IRasterLayerActions;
import org.gvsig.raster.mainplugin.properties.RasterPropertiesTocMenuEntry;
import org.gvsig.raster.multifile.app.panel.AbstractBandSelectorListener;
import org.gvsig.raster.multifile.app.panel.BandSelectorFileList;
import org.gvsig.raster.multifile.app.panel.BandSelectorNewLayerListener;
import org.gvsig.raster.multifile.app.panel.BandSelectorPropertiesListener;
import org.gvsig.raster.swing.RasterSwingLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BandSelectorPanel
extends AbstractPanel
implements TableModelListener {
    private static final long serialVersionUID = -3370601314380922368L;
    public static final int TYPE_PROPERTIES = 0;
    public static final int TYPE_DIALOG = 1;
    private final String[] columnNames = new String[]{"A", "R", "G", "B", "Band"};
    private final int[] columnWidths = new int[]{22, 22, 22, 22, 334};
    private FLyrRaster fLayer = null;
    private BandSelectorFileList fileList = null;
    private int[] col = new int[]{0, 1};
    private AbstractBandSelectorListener panelListener = null;
    private TableContainer table = null;
    private JButton saveButton = null;
    private JPanel buttonsPanel = null;
    private JComboBox jComboBox = null;
    private static final Logger logger = LoggerFactory.getLogger(BandSelectorPanel.class);

    public BandSelectorPanel() {
        this.panelListener = new BandSelectorPropertiesListener(this);
        this.initialize();
    }

    public BandSelectorPanel(int type) {
        if (type == 0) {
            this.panelListener = new BandSelectorPropertiesListener(this);
        }
        if (type == 1) {
            this.panelListener = new BandSelectorNewLayerListener(this);
        }
        this.initialize();
    }

    public AbstractBandSelectorListener getListener() {
        return this.panelListener;
    }

    protected void initialize() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add(this.getFileList(), gbc);
        gbc.gridy = 1;
        this.add((Component)this.getARGBTable(), gbc);
        gbc.weighty = 0.0;
        gbc.gridy = 2;
        gbc.fill = 13;
        gbc.anchor = 13;
        gbc.insets = new Insets(0, 0, 0, 8);
        if (this.panelListener instanceof BandSelectorPropertiesListener) {
            this.add(this.getButtonsPanel(), gbc);
        }
        this.setPreferredSize(new Dimension(100, 80));
        super.setLabel(Messages.getText((String)"bands_panel"));
        this.setPriority(80);
    }

    public BandSelectorFileList getFileList() {
        if (this.fileList == null) {
            this.fileList = new BandSelectorFileList();
        }
        return this.fileList;
    }

    public TableContainer getARGBTable() {
        if (this.table == null) {
            ArrayList<AbstractBandSelectorListener> listeners = new ArrayList<AbstractBandSelectorListener>();
            listeners.add(this.panelListener);
            this.table = new TableContainer(this.columnNames, this.columnWidths, listeners);
            this.table.setModel("ARGBBandSelectorModel");
            this.table.setControlVisible(false);
            this.table.getModel().addTableModelListener(this);
            this.table.initialize();
        }
        return this.table;
    }

    public JPanel getButtonsPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            this.buttonsPanel.setLayout(new GridBagLayout());
            JLabel lbandasVisibles = new JLabel();
            lbandasVisibles.setText(Messages.getText((String)"bands"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 8, 0, 0);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            this.buttonsPanel.add((Component)lbandasVisibles, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 8, 0, 0);
            gbc.fill = 1;
            gbc.gridx = 1;
            this.getNumBandSelectorCombo().setMinimumSize(new Dimension(50, this.getNumBandSelectorCombo().getMinimumSize().height));
            this.getNumBandSelectorCombo().setPreferredSize(new Dimension(50, this.getNumBandSelectorCombo().getMinimumSize().height));
            this.buttonsPanel.add((Component)this.getNumBandSelectorCombo(), gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(0, 8, 0, 0);
            gbc.fill = 1;
            gbc.weightx = 1.0;
            gbc.gridx = 2;
            this.buttonsPanel.add((Component)this.getSaveButton(), gbc);
        }
        return this.buttonsPanel;
    }

    public JComboBox getNumBandSelectorCombo() {
        if (this.jComboBox == null) {
            String[] list = new String[]{"1", "2", "3"};
            this.jComboBox = new JComboBox<String>(list);
            this.jComboBox.setSelectedIndex(2);
            this.jComboBox.setPreferredSize(new Dimension(36, 25));
        }
        return this.jComboBox;
    }

    public JButton getSaveButton() {
        if (this.saveButton == null) {
            this.saveButton = new JButton(Messages.getText((String)"save"));
            this.saveButton.setToolTipText(Messages.getText((String)"save_color_interpretation"));
            this.saveButton.addActionListener(this.panelListener);
        }
        return this.saveButton;
    }

    public void addFiles(RasterDataStore dstore) throws NotInitializeException {
        int i;
        this.getFileList().clear();
        this.clear();
        if (dstore.isMultiFile()) {
            URI[] uris = dstore.getURIByProvider();
            for (i = 0; i < uris.length; ++i) {
                this.getFileList().addFName(new File(uris[i]).getAbsolutePath());
            }
        } else {
            this.getFileList().addFName(dstore.getName());
        }
        int nbands = dstore.getBandCount();
        for (i = 0; i < nbands; ++i) {
            URI uriByBand = dstore.getURIByBand(i);
            String bandName = "";
            if ("FILE".equalsIgnoreCase(uriByBand.getScheme())) {
                File file = new File(uriByBand);
                bandName = file.getName();
            } else {
                bandName = dstore.getFullName();
            }
            String bandType = "";
            switch (dstore.getDataType()[0]) {
                case 0: {
                    bandType = "8U";
                    break;
                }
                case 3: {
                    bandType = "32";
                    break;
                }
                case 5: {
                    bandType = "64";
                    break;
                }
                case 4: {
                    bandType = "32";
                    break;
                }
                case 2: {
                    bandType = "16";
                    break;
                }
                case 1: {
                    bandType = "16U";
                    break;
                }
                case 32: {
                    bandType = "??";
                }
            }
            this.addBand(i + 1 + " [" + bandType + "] " + bandName);
        }
        if (this.fLayer != null) {
            this.readDrawedBands();
            this.saveStatus();
        }
    }

    public void removeFile(String file) {
        this.getFileList().removeFName(file);
        for (int i = 0; i < this.getARGBTable().getModel().getRowCount(); ++i) {
            if (!((String)this.getARGBTable().getModel().getValueAt(i, 4)).endsWith(file)) continue;
            try {
                if (((Boolean)this.getARGBTable().getModel().getValueAt(i, 0)).booleanValue()) {
                    this.getARGBTable().getModel().setValueAt(new Boolean(true), i - 1, 1);
                }
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                this.getARGBTable().getModel().setValueAt(new Boolean(true), i + 1, 1);
            }
            try {
                if (((Boolean)this.getARGBTable().getModel().getValueAt(i, 1)).booleanValue()) {
                    this.getARGBTable().getModel().setValueAt(new Boolean(true), i - 1, 2);
                }
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                this.getARGBTable().getModel().setValueAt(new Boolean(true), i + 1, 2);
            }
            try {
                if (((Boolean)this.getARGBTable().getModel().getValueAt(i, 2)).booleanValue()) {
                    this.getARGBTable().getModel().setValueAt(new Boolean(true), i - 1, 3);
                }
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                this.getARGBTable().getModel().setValueAt(new Boolean(true), i + 1, 3);
            }
            this.getARGBTable().getModel().removeRow(i);
            --i;
        }
        this.panelListener.setNewBandsPositionInRendering();
    }

    public void resetMode(int mode) {
        DefaultTableModel model = this.getARGBTable().getModel();
        for (int i = 0; i < model.getColumnCount() - 1; ++i) {
            for (int j = 0; j < model.getRowCount(); ++j) {
                model.setValueAt(Boolean.FALSE, j, i);
            }
        }
        if (this.getNBands() >= 1) {
            switch (mode) {
                case 3: {
                    int b = 2;
                    if (this.getNBands() < 3) {
                        b = this.getNBands() - 1;
                    }
                    model.setValueAt(Boolean.TRUE, b, 3);
                }
                case 2: {
                    int g = 1;
                    if (this.getNBands() == 1) {
                        g = 0;
                    }
                    model.setValueAt(Boolean.TRUE, g, 2);
                }
                case 1: {
                    model.setValueAt(Boolean.TRUE, 0, 1);
                }
            }
        }
        this.col[0] = 0;
        this.col[1] = 1;
    }

    private void addBand(String bandName) throws NotInitializeException {
        Object[] row = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(false), bandName};
        this.getARGBTable().addRow(row);
    }

    private void clear() {
        int rows = this.getARGBTable().getModel().getRowCount();
        if (rows > 0) {
            for (int i = 0; i < rows; ++i) {
                this.getARGBTable().getModel().removeRow(0);
            }
        }
    }

    public int getNBands() {
        return this.getARGBTable().getModel().getRowCount();
    }

    public String getBandName(int i) {
        String s = (String)this.getARGBTable().getModel().getValueAt(i, 3);
        return s.substring(s.lastIndexOf("[8U]") + 5, s.length());
    }

    public void assignBand(int nBand, int flag) {
        Boolean t = new Boolean(true);
        try {
            if ((flag & 8) == 8) {
                this.getARGBTable().getModel().setValueAt(t, nBand, 0);
            }
            if ((flag & 1) == 1) {
                this.getARGBTable().getModel().setValueAt(t, nBand, 1);
            }
            if ((flag & 2) == 2) {
                this.getARGBTable().getModel().setValueAt(t, nBand, 2);
            }
            if ((flag & 4) == 4) {
                this.getARGBTable().getModel().setValueAt(t, nBand, 3);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public int getColorInterpretationByColorBandBand(int flag) {
        int nBand;
        DefaultTableModel model = this.getARGBTable().getModel();
        if ((flag & 8) == 8) {
            for (nBand = 0; nBand < this.getARGBTable().getModel().getRowCount(); ++nBand) {
                if (!((Boolean)model.getValueAt(nBand, 0)).booleanValue()) continue;
                return nBand;
            }
        }
        if ((flag & 1) == 1) {
            for (nBand = 0; nBand < this.getARGBTable().getModel().getRowCount(); ++nBand) {
                if (!((Boolean)model.getValueAt(nBand, 1)).booleanValue()) continue;
                return nBand;
            }
        }
        if ((flag & 2) == 2) {
            for (nBand = 0; nBand < this.getARGBTable().getModel().getRowCount(); ++nBand) {
                if (!((Boolean)model.getValueAt(nBand, 2)).booleanValue()) continue;
                return nBand;
            }
        }
        if ((flag & 4) == 4) {
            for (nBand = 0; nBand < this.getARGBTable().getModel().getRowCount(); ++nBand) {
                if (!((Boolean)model.getValueAt(nBand, 3)).booleanValue()) continue;
                return nBand;
            }
        }
        return -1;
    }

    public String getColorInterpretationByBand(int nBand) {
        DefaultTableModel model = this.getARGBTable().getModel();
        for (int col = 0; col < 4; ++col) {
            if (!((Boolean)model.getValueAt(nBand, col)).booleanValue()) continue;
            switch (col) {
                case 0: {
                    return "Alpha";
                }
                case 1: {
                    return "Red";
                }
                case 2: {
                    return "Green";
                }
                case 3: {
                    return "Blue";
                }
            }
        }
        return "Undefined";
    }

    public ColorInterpretation getSelectedColorInterpretation() {
        try {
            String[] colorInter = new String[this.getARGBTable().getRowCount()];
            for (int iBand = 0; iBand < this.getARGBTable().getRowCount(); ++iBand) {
                colorInter[iBand] = this.isSelected(iBand, 1) && this.isSelected(iBand, 2) && this.isSelected(iBand, 3) ? "Gray" : (this.isSelected(iBand, 1) && this.isSelected(iBand, 2) ? "Red_Green" : (this.isSelected(iBand, 1) && this.isSelected(iBand, 3) ? "Red_Blue" : (this.isSelected(iBand, 2) && this.isSelected(iBand, 3) ? "Green_Blue" : (this.isSelected(iBand, 1) ? "Red" : (this.isSelected(iBand, 2) ? "Green" : (this.isSelected(iBand, 3) ? "Blue" : (this.isSelected(iBand, 0) ? "Alpha" : "Undefined")))))));
            }
            return RasterLocator.getManager().getDataStructFactory().createColorInterpretation(colorInter);
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"table_not_initialize"), (Object)this, (Exception)((Object)e));
            return null;
        }
    }

    private boolean isSelected(int iBand, int col) {
        DefaultTableModel model = this.getARGBTable().getModel();
        return (Boolean)model.getValueAt(iBand, col);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.getARGBTable().revalidate();
        this.revalidate();
    }

    public RasterDataStore getResult() {
        return this.panelListener.getResult();
    }

    private void actionEnabled() {
        boolean enabled = true;
        IRasterLayerActions actions = null;
        if (this.fLayer != null && this.fLayer instanceof IRasterLayerActions) {
            actions = (IRasterLayerActions)this.fLayer;
        }
        if (!actions.isActionEnabled(8)) {
            enabled = false;
        }
        this.getFileList().setEnabled(enabled);
        enabled = true;
        if (!actions.isActionEnabled(9)) {
            enabled = false;
        }
        this.getARGBTable().setEnabled(enabled);
        if (!actions.isActionEnabled(8) && !actions.isActionEnabled(9)) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
        if (!actions.isActionEnabled(19)) {
            this.getSaveButton().setVisible(false);
        }
    }

    public void readDrawedBands() {
        if (this.fLayer.getRender() != null) {
            int[] renderBands = this.fLayer.getRender().getRenderColorInterpretation().buildRenderBands();
            Transparency transp = this.fLayer.getRender().getRenderingTransparency();
            if (transp != null && transp.getAlphaBandNumber() != -1) {
                this.assignBand(transp.getAlphaBandNumber(), 8);
            }
            block5: for (int i = 0; i < renderBands.length; ++i) {
                if (renderBands[i] < 0) continue;
                switch (i) {
                    case 0: {
                        this.assignBand(renderBands[i], 1);
                        continue block5;
                    }
                    case 1: {
                        this.assignBand(renderBands[i], 2);
                        continue block5;
                    }
                    case 2: {
                        this.assignBand(renderBands[i], 4);
                    }
                }
            }
        }
    }

    public void accept() {
        if (!this.getPanelGroup().isPanelInGUI((IPanel)this)) {
            return;
        }
        this.onlyApply();
    }

    public void apply() {
        if (!this.getPanelGroup().isPanelInGUI((IPanel)this)) {
            return;
        }
        this.onlyApply();
        this.saveStatus();
    }

    public void onlyApply() {
        if (RasterPropertiesTocMenuEntry.enableEvents) {
            this.panelListener.apply();
        }
    }

    private void saveStatus() {
        ArrayList<String> aux = new ArrayList<String>();
        String[] valuesCI = this.fLayer.getRender().getRenderColorInterpretation().getValues();
        for (int i = 0; i < valuesCI.length; ++i) {
            aux.add(valuesCI[i]);
        }
        this.getPanelGroup().getProperties().put("renderBands", aux);
    }

    public void restoreStatus() {
        if (this.fLayer != null) {
            return;
        }
        List aux = (List)this.getPanelGroup().getProperties().get("renderBands");
        if (this.fLayer.getRender() != null) {
            ColorInterpretation ci = RasterLocator.getManager().getDataStructFactory().createColorInterpretation((String[])aux.toArray());
            this.fLayer.getRender().setRenderColorInterpretation(ci);
        }
        this.fLayer.getMapContext().invalidate();
    }

    public void cancel() {
        if (!this.getPanelGroup().isPanelInGUI((IPanel)this)) {
            return;
        }
        this.restoreStatus();
    }

    public void setEnabled(boolean enabled) {
        if (this.panelListener != null) {
            this.panelListener.setEnabledPanelAction(enabled);
        }
        this.getARGBTable().setEnabled(enabled);
        this.getFileList().setEnabled(enabled);
    }

    public void setReference(Object ref) {
        super.setReference(ref);
        if (!(ref instanceof FLyrRaster)) {
            return;
        }
        this.fLayer = (FLyrRaster)ref;
        this.actionEnabled();
        this.clear();
        this.getFileList().clear();
        if (this.fLayer.existColorTable()) {
            ((BandSelectorPropertiesListener)this.panelListener).init(this.fLayer);
            return;
        }
        try {
            this.addFiles(this.fLayer.getDataStore());
        }
        catch (NotInitializeException e) {
            RasterSwingLibrary.messageBoxError((String)Messages.getText((String)"table_not_initialize"), (Object)this);
        }
        ((BandSelectorPropertiesListener)this.panelListener).init(this.fLayer);
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void selected() {
        this.setReference(this.fLayer);
    }
}

