/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportToJson;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisUtils;

public class ChangeImpl
implements VCSGisChange,
SupportToJson {
    String changeCode;
    String entityCode;
    boolean selected;
    int operation;
    String relatedFeatureCode;
    String data;
    String label;
    int state;

    public ChangeImpl(JsonObject jsonChange) {
        this.changeCode = jsonChange.getString("Code", null);
        this.entityCode = jsonChange.getString("EntityCode", null);
        this.operation = jsonChange.getInt("Operation", -1);
        this.relatedFeatureCode = jsonChange.getString("RelatedFeatureCode", null);
        this.data = jsonChange.getString("Data", null);
        this.selected = jsonChange.getBoolean("Selected", false);
        this.state = jsonChange.getInt("State", 1);
    }

    public String getCode() {
        return this.changeCode;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getOperationLabel() {
        return VCSGisUtils.getOperationLabel(this.operation);
    }

    public String getLabel() {
        return this.label;
    }

    public String getRelatedFeatureCode() {
        return this.relatedFeatureCode;
    }

    public String getRelatedFeatureData() {
        return this.data;
    }

    public JsonObject getRelatedFeatureDataAsJson() {
        return Json.createObject((String)this.data);
    }

    public int getStatus() {
        return this.state;
    }

    public String toString() {
        return super.toString() + " " + StringUtils.replaceChars((String)this.toJson().toString(), (char)'\n', (char)' ');
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("Code", this.changeCode);
        builder.add("EntityCode", this.entityCode);
        builder.add("Operation", this.operation);
        builder.add("RelatedFeatureCode", this.relatedFeatureCode);
        builder.add("Data", this.data);
        builder.add("Selected", this.selected);
        builder.add("State", this.state);
        return builder;
    }
}

