/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.Iterator;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.util.ContainerUtils;
import org.gvsig.tools.util.Size64;
import org.gvsig.vcsgis.lib.UserCancelledException;

public class DisposableIterableAdapter<TSRC, TDST>
implements DisposableIterable<TDST>,
Size64 {
    private final DisposableIterable<TSRC> source;
    private final ItemConverter<TSRC, TDST> itemConverter;

    public DisposableIterableAdapter(DisposableIterable<TSRC> source, ItemConverter<TSRC, TDST> itemConverter) {
        this.source = source;
        this.itemConverter = itemConverter;
    }

    public long size64() {
        return ContainerUtils.size64(this.source);
    }

    public Iterator<TDST> iterator() {
        final Iterator it = this.source.iterator();
        if (this.itemConverter == null) {
            return it;
        }
        return new Iterator<TDST>(){

            @Override
            public boolean hasNext() {
                DisposableIterableAdapter.this.cancelled();
                return it.hasNext();
            }

            @Override
            public TDST next() {
                Object source_item = it.next();
                if (source_item == null) {
                    return null;
                }
                return DisposableIterableAdapter.this.itemConverter.convert(source_item);
            }
        };
    }

    public void dispose() {
        DisposeUtils.disposeQuietly(this.source);
    }

    public void cancelled() throws UserCancelledException {
    }

    public static interface ItemConverter<TSRC, TDST> {
        public TDST convert(TSRC var1);
    }
}

