/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.Collection;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.crs.CRSFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.vcsgis.lib.VCSGisCategories;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;

public class EntityEditableImpl
implements VCSGisEntityEditable {
    String entityCode;
    String userCode;
    String topologyPlanCode;
    String entityName;
    String dataTableName;
    String geometryFieldName;
    String featureIdFieldName;
    String description;
    String repositoryRevisionCode;
    String featureTypeAsJson;
    String fieldForLabel;
    String category;
    String label;
    String authorizations;
    String resources;
    String dataModels;
    int topologyPlanMode;
    FeatureType featureType;
    String crs;
    private VCSGisCategories categories;
    private String customData;

    public EntityEditableImpl() {
        this.initDefaults();
    }

    public EntityEditableImpl(VCSGisEntity entity) {
        this.initDefaults();
        this.copyfrom(entity);
    }

    public EntityEditableImpl(String jsonEntity) {
        this.initDefaults();
        JsonObject json = Json.createObject((String)jsonEntity);
        this.fromJson(json);
    }

    public EntityEditableImpl(JsonObject jsonEntity) {
        this.initDefaults();
        this.fromJson(jsonEntity);
    }

    private void initDefaults() {
        this.entityCode = null;
        this.userCode = null;
        this.topologyPlanCode = null;
        this.entityName = null;
        this.dataTableName = "VCSGISREPO_DATA";
        this.geometryFieldName = null;
        this.featureIdFieldName = "VCSGISCODE";
        this.description = null;
        this.repositoryRevisionCode = null;
        this.featureTypeAsJson = null;
        this.fieldForLabel = null;
        this.category = null;
        this.label = null;
        this.authorizations = null;
        this.resources = null;
        this.dataModels = null;
        this.topologyPlanMode = 0;
        this.featureType = null;
        this.crs = null;
        this.categories = null;
        this.customData = null;
    }

    public void copyfrom(VCSGisEntity entity) {
        VCSGisUtils.copy(entity, this, null);
    }

    public void copyto(VCSGisEntityEditable entity) {
        VCSGisUtils.copy((VCSGisEntity)this, entity, null);
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public String getRepositoryRevisionCode() {
        return this.repositoryRevisionCode;
    }

    public String getUserCode() {
        return this.userCode;
    }

    public String getTopologyPlanCode() {
        return this.topologyPlanCode;
    }

    public int getTopologyPlanMode() {
        return this.topologyPlanMode;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String getDataTableName() {
        return this.dataTableName;
    }

    public String getGeometryFieldName() {
        return this.geometryFieldName;
    }

    public String getFeatureIdFieldName() {
        return this.featureIdFieldName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFeatureTypeAsJson() {
        return this.featureTypeAsJson;
    }

    public FeatureType getFeatureType() {
        if (this.featureType == null) {
            String s = this.getFeatureTypeAsJson();
            JsonObject json = Json.createObject((String)s);
            this.featureType = DALLocator.getDataManager().createFeatureType(json);
        }
        return this.featureType;
    }

    public String getFieldForLabel() {
        return this.fieldForLabel;
    }

    public String getCategory() {
        return this.category;
    }

    public VCSGisCategories getCategoriesAsList() {
        if (this.categories == null) {
            this.categories = new VCSGisCategories(this.getCategory());
        }
        return this.categories;
    }

    public Tags getCategoryTags(String category) {
        VCSGisCategories l = this.getCategoriesAsList();
        if (l == null) {
            return Tags.EMPTY_TAGS;
        }
        return l.getTags(category);
    }

    public String getFirstCategory() {
        VCSGisCategories l = this.getCategoriesAsList();
        if (CollectionUtils.isEmpty((Collection)l)) {
            return null;
        }
        return l.get(0);
    }

    public String getAuthorizations() {
        return this.authorizations;
    }

    public String getLabel() {
        return this.label;
    }

    public VCSGisEntityEditable setEntityCode(String code) {
        this.entityCode = code;
        return this;
    }

    public VCSGisEntityEditable setRepositoryRevisionCode(String revisionCode) {
        this.repositoryRevisionCode = revisionCode;
        return this;
    }

    public VCSGisEntityEditable setUserCode(String userCode) {
        this.userCode = userCode;
        return this;
    }

    public VCSGisEntityEditable setTopologyPlanCode(String topologyplanCode) {
        this.topologyPlanCode = topologyplanCode;
        return this;
    }

    public VCSGisEntityEditable setEntityName(String entityName) {
        this.entityName = entityName;
        return this;
    }

    public VCSGisEntityEditable setDataTableName(String dataTableName) {
        this.dataTableName = dataTableName;
        return this;
    }

    public VCSGisEntityEditable setGeometryFieldName(String geometryFieldName) {
        this.geometryFieldName = geometryFieldName;
        return this;
    }

    public VCSGisEntityEditable setFeatureIdFieldName(String featureIdFieldName) {
        this.featureIdFieldName = featureIdFieldName;
        return this;
    }

    public VCSGisEntityEditable setDescription(String descripcion) {
        this.description = descripcion;
        return this;
    }

    public VCSGisEntityEditable setFieldForLabel(String fieldForLabel) {
        this.fieldForLabel = fieldForLabel;
        return this;
    }

    public VCSGisEntityEditable setCategory(String category) {
        this.category = category;
        return this;
    }

    public VCSGisEntityEditable setAuthorizations(String authorizations) {
        this.authorizations = authorizations;
        return this;
    }

    public VCSGisEntityEditable setTopologyPlanMode(int topologyPlanMode) {
        this.topologyPlanMode = topologyPlanMode;
        return this;
    }

    public VCSGisEntityEditable setLabel(String label) {
        this.label = label;
        return this;
    }

    public VCSGisEntityEditable setFeatureTypeAsJson(String featureType) {
        this.featureTypeAsJson = featureType;
        this.featureType = null;
        return this;
    }

    public void fromJson(JsonObject jsonEntity) {
        VCSGisUtils.fromJson(this, jsonEntity);
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        return VCSGisUtils.toJsonBuilder((VCSGisEntity)this, null);
    }

    public VCSGisEntity getValue() {
        return this;
    }

    public String toString() {
        return VCSGisUtils.getLabelOrName((VCSGisEntity)this);
    }

    public boolean isAuthorized(VCSGisUser user, String operation) {
        return VCSGisUtils.isAuthorized((VCSGisEntity)this, operation, user);
    }

    public VCSGisEntityEditable setResources(String resources) {
        this.resources = resources;
        return this;
    }

    public VCSGisEntityEditable setDataModels(String dataModels) {
        this.dataModels = dataModels;
        return this;
    }

    public String getResources() {
        return this.resources;
    }

    public String getDataModels() {
        return this.dataModels;
    }

    public List<String> getDataModelsAsList() {
        String s = this.getDataModels();
        return VCSGisUtils.getAsList(s, false);
    }

    public String getLabelOrName() {
        return VCSGisUtils.getLabelOrName((VCSGisEntity)this);
    }

    public String getCRS() {
        return this.crs;
    }

    public IProjection getCRSAsProjection() {
        if (StringUtils.isBlank((CharSequence)this.crs)) {
            return null;
        }
        return CRSFactory.getCRS((String)this.crs);
    }

    public VCSGisEntityEditable setCRS(IProjection crs) {
        this.crs = crs.getAbrev();
        return this;
    }

    public VCSGisEntityEditable setCRS(String crs) {
        this.crs = crs;
        return this;
    }

    public boolean isLinkedTable() {
        return VCSGisUtils.isLinkedTable((VCSGisEntity)this);
    }

    public VCSGisRepository getLinkedRepository() {
        return VCSGisUtils.getLinkedRepository((VCSGisEntity)this);
    }

    public VCSGisEntityEditable setCustomData(String customData) {
        this.customData = customData;
        return this;
    }

    public String getCustomData() {
        return this.customData;
    }

    public String getFirstDataModel() {
        List<String> l = this.getDataModelsAsList();
        if (CollectionUtils.isEmpty(l)) {
            return null;
        }
        return l.get(0);
    }
}

