/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;

public class SAJParserImpl {
    private final JsonParser parser;
    private final SAJParserHandler handler;
    private final List<SAJParserContextImpl> contextsStack;

    public SAJParserImpl(InputStream is, SAJParserHandler handler) {
        this(Json.createParser((InputStream)is), handler);
    }

    public SAJParserImpl(Reader reader, SAJParserHandler handler) {
        this(Json.createParser((Reader)reader), handler);
    }

    public SAJParserImpl(JsonParser parser, SAJParserHandler handler) {
        this.parser = parser;
        this.handler = handler;
        this.contextsStack = new ArrayList<SAJParserContextImpl>(10);
    }

    private SAJParserContextImpl getContext(int index) {
        return this.contextsStack.get(index);
    }

    public JsonParser getParser() {
        return this.parser;
    }

    public void close() {
        this.parser.close();
    }

    private JsonObjectBuilder createObjectBuilder() {
        return Json.createObjectBuilder();
    }

    private JsonArrayBuilder createArrayBuilder() {
        return Json.createArrayBuilder();
    }

    private SAJParserContextImpl createContext(JsonObjectBuilder objectBuilder, String name) {
        return this.createContext(objectBuilder, null, name, null);
    }

    private SAJParserContextImpl createContext(JsonArrayBuilder arrayBuilder, String name) {
        return this.createContext(null, arrayBuilder, name, null);
    }

    private SAJParserContextImpl createContext(JsonArrayBuilder arrayBuilder, long index) {
        return this.createContext(null, arrayBuilder, null, index);
    }

    private SAJParserContextImpl createContext(JsonObjectBuilder objectBuilder, long index) {
        return this.createContext(objectBuilder, null, null, index);
    }

    private SAJParserContextImpl createContext(JsonArrayBuilder arrayBuilder) {
        return this.createContext(null, arrayBuilder, null, null);
    }

    private SAJParserContextImpl createContext(JsonObjectBuilder objectBuilder) {
        return this.createContext(objectBuilder, null, null, null);
    }

    private SAJParserContextImpl createContext(JsonObjectBuilder objectBuilder, JsonArrayBuilder arrayBuilder, String name, Long index) {
        SAJParserContextImpl context = new SAJParserContextImpl();
        context.arrayBuilder = arrayBuilder;
        context.objectBuilder = objectBuilder;
        context.name = name;
        context.index = index;
        this.contextsStack.add(context);
        context.stackIndex = this.contextsStack.size() - 1;
        return context;
    }

    private void deleteContext(SAJParserContextImpl context) {
        this.contextsStack.remove(context.stackIndex);
        if (context.stackIndex != this.contextsStack.size()) {
            for (int i = 0; i < this.contextsStack.size(); ++i) {
                this.contextsStack.get(i).stackIndex = i;
                this.contextsStack.get(i).pathName = null;
            }
        }
    }

    public void parse() {
        if (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            if (e == JsonParser.Event.START_ARRAY) {
                SAJParserContextImpl context = this.createContext(this.createArrayBuilder());
                this.handler.handle(context, e, null);
                this.readArray(context);
                this.deleteContext(context);
            } else if (e == JsonParser.Event.START_OBJECT) {
                SAJParserContextImpl context = this.createContext(this.createObjectBuilder());
                this.handler.handle(context, e, null);
                this.readObject(context);
                this.deleteContext(context);
            }
        }
    }

    private void readArray(SAJParserContextImpl context) {
        context.index = 0L;
        while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    SAJParserContextImpl context2 = this.createContext(this.createArrayBuilder(), (long)context.index);
                    this.handler.handle(context2, e, context2.arrayBuilder);
                    this.readArray(context2);
                    if (context.arrayBuilder != null) {
                        if (context2.arrayBuilder == null) {
                            context.arrayBuilder.addNull();
                        } else {
                            context.arrayBuilder.add(context2.arrayBuilder);
                        }
                    }
                    this.deleteContext(context2);
                    break;
                }
                case START_OBJECT: {
                    SAJParserContextImpl context2 = this.createContext(this.createObjectBuilder(), (long)context.index);
                    this.handler.handle(context2, e, context2.objectBuilder);
                    this.readObject(context2);
                    if (context.arrayBuilder != null) {
                        if (context2.objectBuilder == null) {
                            context.arrayBuilder.addNull();
                        } else {
                            context.arrayBuilder.add(context2.objectBuilder);
                        }
                    }
                    this.deleteContext(context2);
                    break;
                }
                case VALUE_STRING: {
                    this.handler.handle(context, e, this.parser.getString());
                    if (context.arrayBuilder == null) break;
                    context.arrayBuilder.add(this.parser.getString());
                    break;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        this.handler.handle(context, e, this.parser.getInt());
                        if (context.arrayBuilder == null) break;
                        context.arrayBuilder.add(this.parser.getInt());
                        break;
                    }
                    this.handler.handle(context, e, this.parser.getBigDecimal());
                    if (context.arrayBuilder == null) break;
                    context.arrayBuilder.add(this.parser.getBigDecimal());
                    break;
                }
                case VALUE_TRUE: {
                    this.handler.handle(context, e, true);
                    if (context.arrayBuilder == null) break;
                    context.arrayBuilder.add(JsonValue.TRUE);
                    break;
                }
                case VALUE_FALSE: {
                    this.handler.handle(context, e, false);
                    if (context.arrayBuilder == null) break;
                    context.arrayBuilder.add(JsonValue.FALSE);
                    break;
                }
                case VALUE_NULL: {
                    this.handler.handle(context, e, null);
                    if (context.arrayBuilder == null) break;
                    context.arrayBuilder.add(JsonValue.NULL);
                    break;
                }
                case END_ARRAY: {
                    this.handler.handle(context, e, context.arrayBuilder);
                    return;
                }
                default: {
                    throw new JsonException("Internal Error");
                }
            }
            SAJParserContextImpl sAJParserContextImpl = context;
            sAJParserContextImpl.index = sAJParserContextImpl.index + 1L;
        }
        throw new JsonException("Internal Error");
    }

    private void readObject(SAJParserContextImpl context) {
        block11: while (this.parser.hasNext()) {
            JsonParser.Event e = this.parser.next();
            switch (e) {
                case START_ARRAY: {
                    SAJParserContextImpl context2 = this.createContext(this.createArrayBuilder(), context.attrname);
                    this.handler.handle(context2, e, context2.arrayBuilder);
                    this.readArray(context2);
                    if (context.objectBuilder != null) {
                        if (context2.arrayBuilder == null) {
                            context.objectBuilder.addNull(context.attrname);
                        } else {
                            context.objectBuilder.add(context.attrname, context2.arrayBuilder);
                        }
                    }
                    this.deleteContext(context2);
                    continue block11;
                }
                case START_OBJECT: {
                    SAJParserContextImpl context2 = this.createContext(this.createObjectBuilder(), context.attrname);
                    this.handler.handle(context2, e, context2.objectBuilder);
                    this.readObject(context2);
                    if (context.objectBuilder != null) {
                        if (context2.objectBuilder == null) {
                            context.objectBuilder.addNull(context.attrname);
                        } else {
                            context.objectBuilder.add(context.attrname, context2.objectBuilder);
                        }
                    }
                    this.deleteContext(context2);
                    continue block11;
                }
                case KEY_NAME: {
                    context.attrname = this.parser.getString();
                    continue block11;
                }
                case VALUE_STRING: {
                    this.handler.handle(context, e, this.parser.getString());
                    if (context.objectBuilder == null) continue block11;
                    context.objectBuilder.add(context.attrname, this.parser.getString());
                    continue block11;
                }
                case VALUE_NUMBER: {
                    if (this.parser.isIntegralNumber()) {
                        this.handler.handle(context, e, this.parser.getInt());
                        if (context.objectBuilder == null) continue block11;
                        context.objectBuilder.add(context.attrname, this.parser.getInt());
                        continue block11;
                    }
                    this.handler.handle(context, e, this.parser.getBigDecimal());
                    if (context.objectBuilder == null) continue block11;
                    context.objectBuilder.add(context.attrname, this.parser.getBigDecimal());
                    continue block11;
                }
                case VALUE_TRUE: {
                    this.handler.handle(context, e, true);
                    if (context.objectBuilder == null) continue block11;
                    context.objectBuilder.add(context.attrname, JsonValue.TRUE);
                    continue block11;
                }
                case VALUE_FALSE: {
                    this.handler.handle(context, e, false);
                    if (context.objectBuilder == null) continue block11;
                    context.objectBuilder.add(context.attrname, JsonValue.FALSE);
                    continue block11;
                }
                case VALUE_NULL: {
                    this.handler.handle(context, e, null);
                    if (context.objectBuilder == null) continue block11;
                    context.objectBuilder.addNull(context.attrname);
                    continue block11;
                }
                case END_OBJECT: {
                    context.attrname = null;
                    this.handler.handle(context, e, context.objectBuilder);
                    return;
                }
            }
            throw new JsonException("Internal Error");
        }
        throw new JsonException("Internal Error");
    }

    private class SAJParserContextImpl
    implements SAJParserContext {
        private JsonObjectBuilder objectBuilder;
        private JsonArrayBuilder arrayBuilder;
        private String name;
        private Long index;
        private String attrname;
        private int stackIndex;
        private String pathName;

        @Override
        public JsonArrayBuilder getArrayBuilder() {
            return this.arrayBuilder;
        }

        @Override
        public void setArrayBuilder(JsonArrayBuilder arrayBuilder) {
            this.arrayBuilder = arrayBuilder;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getAttrName() {
            return this.attrname;
        }

        @Override
        public JsonObjectBuilder getObjectBuilder() {
            return this.objectBuilder;
        }

        @Override
        public Long getIndex() {
            return this.index;
        }

        @Override
        public String getPathName() {
            if (this.pathName == null) {
                StringBuilder builder = new StringBuilder();
                for (int i = 0; i <= this.stackIndex; ++i) {
                    if (((SAJParserImpl)SAJParserImpl.this).getContext((int)i).name != null) {
                        builder.append("/");
                        builder.append(((SAJParserImpl)SAJParserImpl.this).getContext((int)i).name);
                        continue;
                    }
                    if (((SAJParserImpl)SAJParserImpl.this).getContext((int)i).index != null) {
                        builder.append("/?");
                        continue;
                    }
                    if (i == 0) continue;
                    builder.append("/?");
                }
                this.pathName = builder.toString();
            }
            return this.pathName;
        }
    }

    public static interface SAJParserHandler {
        public void handle(SAJParserContext var1, JsonParser.Event var2, Object var3);
    }

    public static interface SAJParserContext {
        public JsonObjectBuilder getObjectBuilder();

        public JsonArrayBuilder getArrayBuilder();

        public String getName();

        public String getAttrName();

        public Long getIndex();

        public String getPathName();

        public void setArrayBuilder(JsonArrayBuilder var1);
    }
}

