/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.dynobject.Tagged;
import org.gvsig.tools.dynobject.Tags;
import org.gvsig.tools.dynobject.impl.DefaultTags;

public class VCSGisCategories
extends AbstractList<String>
implements List<String> {
    private final String categories_s;
    private List<Category> categories;

    public VCSGisCategories(String categories) {
        this.categories_s = categories;
        this.categories = null;
    }

    private List<Category> getCategories() {
        if (this.categories == null) {
            if (StringUtils.isBlank((CharSequence)this.categories_s)) {
                this.categories = Collections.EMPTY_LIST;
            } else {
                try {
                    String[] ss;
                    ArrayList<Category> r = new ArrayList<Category>();
                    for (String s1 : ss = StringUtils.split((String)this.categories_s, (String)",")) {
                        if (StringUtils.isBlank((CharSequence)s1)) continue;
                        Category category = new Category(s1);
                        r.add(category);
                    }
                    this.categories = r;
                }
                catch (Exception ex) {
                    this.categories = Collections.EMPTY_LIST;
                }
            }
        }
        return this.categories;
    }

    @Override
    public String get(int index) {
        return this.getCategories().get(index).getName();
    }

    @Override
    public int size() {
        return this.getCategories().size();
    }

    public Tags getTags(String name) {
        for (Category category : this.getCategories()) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)category.getName())) continue;
            return category.getTags();
        }
        return Tags.EMPTY_TAGS;
    }

    private static class Category
    implements Tagged {
        private final String category_s;
        private String name;
        private DefaultTags tags;

        public Category(String category) {
            this.category_s = category;
            this.parse();
        }

        private void parse() {
            this.tags = new DefaultTags();
            this.name = "unknown";
            Object[] ss = StringUtils.split((String)this.category_s, (String)";");
            if (ArrayUtils.isEmpty((Object[])ss)) {
                return;
            }
            this.name = StringUtils.strip((String)ss[0]);
            for (int i = 1; i < ss.length; ++i) {
                Object s1 = ss[i];
                if (StringUtils.isBlank((CharSequence)s1)) continue;
                int n = ((String)s1).indexOf("=");
                if (n < 0) {
                    this.tags.set(StringUtils.strip((String)s1), null);
                    continue;
                }
                String tagname = StringUtils.strip((String)StringUtils.substring((String)s1, (int)0, (int)n));
                String tagvalue = StringUtils.stripToNull((String)StringUtils.substring((String)s1, (int)(n + 1)));
                this.tags.set(tagname, (Object)tagvalue);
            }
        }

        public String getName() {
            return this.name;
        }

        public Tags getTags() {
            return this.tags;
        }
    }
}

