/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.identitymanagement.UnauthorizedException;
import org.gvsig.tools.identitymanagement.spi.AbstractSimpleIdentity;
import org.gvsig.tools.identitymanagement.spi.AbstractSimpleIdentityManager;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceDescriptor;

public class VCSGisIdentityManager
extends AbstractSimpleIdentityManager {
    private VCSGisIdentity currentUser = new VCSGisIdentity(this);

    public VCSGisIdentity getIdentity(String identityid) {
        return null;
    }

    public void login(String domain, String identityid, String password) throws UnauthorizedException {
        throw new UnauthorizedException(identityid, "login", null, null);
    }

    public void logout() {
        this.currentUser = null;
    }

    public SimpleIdentity getCurrentIdentity() {
        return this.currentUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sudo(String domain, String identityid, Runnable acction) {
        VCSGisIdentity save = this.currentUser;
        this.currentUser = this.getIdentity(identityid);
        try {
            acction.run();
        }
        finally {
            this.currentUser = save;
        }
    }

    public void setCurrentUser(VCSGisWorkspace ws, VCSGisUser user) {
        if (this.currentUser == null) {
            this.currentUser = new VCSGisIdentity(this);
        }
        this.currentUser.add(ws, user);
    }

    private static class VCSGisIdentity
    extends AbstractSimpleIdentity {
        private final Map<String, VCSGisUserAndWorkspace> users = new LinkedHashMap<String, VCSGisUserAndWorkspace>();
        private List<Expression> rules = new ArrayList<Expression>();
        private MutableSymbolTable symbolTable;

        public VCSGisIdentity(VCSGisIdentityManager manager) {
            super((SimpleIdentityManager)manager);
        }

        public String getCode() {
            return this.getFirstUser().getUserCode();
        }

        public String getID() {
            return this.getFirstUser().getIdentifier();
        }

        public boolean isAuthenticated() {
            return this.getFirstUser() == VCSGisUser.GUEST;
        }

        public List<String> getRoles() {
            if (this.users == null || this.users.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            ArrayList<String> r = new ArrayList<String>();
            for (VCSGisUserAndWorkspace user : this.users.values()) {
                r.addAll(user.getUser().getRolesAsList());
            }
            return r;
        }

        public boolean isAuthorized(String actionName, Object resource, String resourceName) {
            if (this.rules.isEmpty()) {
                return true;
            }
            if (this.symbolTable == null) {
                this.symbolTable = ExpressionUtils.createSymbolTable();
            }
            this.symbolTable.setVar("actionName", (Object)actionName);
            this.symbolTable.setVar("resource", resource);
            this.symbolTable.setVar("resourceName", (Object)resourceName);
            for (Expression rule : this.rules) {
                boolean x = DataTypeUtils.toBoolean((Object)rule.execute((SymbolTable)this.symbolTable), (boolean)true);
                if (!x) continue;
                return false;
            }
            return true;
        }

        private VCSGisUser getFirstUser() {
            if (this.users == null || this.users.isEmpty()) {
                return VCSGisUser.GUEST;
            }
            return this.users.values().iterator().next().getUser();
        }

        public void add(VCSGisWorkspace ws, VCSGisUser user) {
            this.users.put(ws.getCode(), new VCSGisUserAndWorkspace(ws.getCode(), user));
            for (String op : user.getAllowedOperationsAsList()) {
                if (!StringUtils.startsWith((CharSequence)op, (CharSequence)"@DESKTOPRULE ")) continue;
                String s = StringUtils.removeStart((String)op, (String)"@DESKTOPRULE ");
                this.rules.add(ExpressionUtils.createExpression((String)s));
            }
        }
    }

    private static class VCSGisUserAndWorkspace {
        private final VCSGisUser user;
        private final String workspaceid;

        public VCSGisUserAndWorkspace(String workspaceid, VCSGisUser user) {
            this.workspaceid = workspaceid;
            this.user = user;
        }

        public String getWorkspaceId() {
            return this.workspaceid;
        }

        public VCSGisUser getUser() {
            return this.user;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VCSGisWorkspace getWorkspace() {
            VCSGisWorkspace vCSGisWorkspace;
            VCSGisWorkspaceDescriptor descriptor = null;
            try {
                VCSGisManager manager = VCSGisLocator.getVCSGisManager();
                descriptor = manager.getWorkspaceDescriptor(this.workspaceid);
                vCSGisWorkspace = descriptor.getWorkspace();
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(descriptor);
                throw throwable;
            }
            DisposeUtils.disposeQuietly((Disposable)descriptor);
            return vCSGisWorkspace;
        }
    }
}

