/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib;

import java.sql.Timestamp;
import javax.json.JsonObject;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.json.SupportFromJson;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;

public class VCSGisRepositoryDataImpl
implements VCSGisRepositoryData,
SupportFromJson {
    private String dataCode;
    private String entityCode;
    private String revisionCode;
    private int operation;
    private int revisionNumber;
    private String data;
    private Timestamp efectiveDate;
    private String featureRelatedCode;

    public VCSGisRepositoryDataImpl(JsonObject jsonData) {
        this.fromJson(jsonData);
    }

    public VCSGisRepositoryDataImpl(Feature f) {
        this.dataCode = f.getString("COD_DATA");
        this.entityCode = f.getString("COD_ENTITY");
        this.revisionCode = f.getString("COD_REVISION");
        this.operation = f.getInt("DAT_OPERATION");
        this.revisionNumber = f.getInt("DAT_REVNUMBER");
        this.efectiveDate = f.getTimestamp("DAT_EFECTIVEDATE");
        this.featureRelatedCode = f.getString("DAT_FEATURERELATEDCODE");
        this.data = f.getString("DAT_DATA");
    }

    public String getDataCode() {
        return this.dataCode;
    }

    public String getEntityCode() {
        return this.entityCode;
    }

    public String getFeatureRelatedCode() {
        return this.featureRelatedCode;
    }

    public String getRevisionCode() {
        return this.revisionCode;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getOperationLabel() {
        return VCSGisUtils.getOperationLabel(this.getOperation());
    }

    public long getRevisionNumber() {
        return this.revisionNumber;
    }

    public Timestamp getEfectiveDate() {
        return this.efectiveDate;
    }

    public String getData() {
        return this.data;
    }

    public JsonObject getDataAsJson() {
        JsonObject jsonData = Json.createObject((String)this.data);
        return jsonData;
    }

    public JsonObject toJson() {
        return this.toJsonBuilder().build();
    }

    public JsonObjectBuilder toJsonBuilder() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("DataCode", this.getDataCode());
        if (this.getEntityCode() != null) {
            builder.add("EntityCode", this.getEntityCode());
        }
        builder.add("RevisionCode", this.getRevisionCode());
        builder.add("RevisionNumber", this.getRevisionNumber());
        if (this.getEfectiveDate() == null) {
            builder.addNull("EfectiveDate");
        } else {
            builder.add("EfectiveDate", this.getEfectiveDate().toString());
        }
        builder.add("Operation", this.getOperation());
        builder.add("FeatureRelatedCode", this.getFeatureRelatedCode());
        builder.add("Data", this.getData());
        return builder;
    }

    public String toString() {
        return this.toJson().toString().replace("\n", "");
    }

    public void fromJson(JsonObject jsonData) {
        this.dataCode = jsonData.getString("DataCode", null);
        this.entityCode = jsonData.getString("EntityCode", null);
        this.revisionCode = jsonData.getString("RevisionCode", null);
        this.operation = jsonData.getInt("Operation", -1);
        this.revisionNumber = jsonData.getInt("RevisionNumber", -1);
        this.efectiveDate = (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("EfectiveDate", null), null);
        this.featureRelatedCode = jsonData.getString("FeatureRelatedCode", null);
        this.data = jsonData.getString("Data", null);
    }
}

