/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisUser;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequest;
import org.gvsig.vcsgis.lib.requests.RequestHelper;

public abstract class AbstractRequestLocaldb
extends AbstractRequest
implements VCSGisRequest {
    private VCSGisUser user = null;

    public AbstractRequestLocaldb(RequestHelper helper) {
        super(helper);
    }

    @Override
    public VCSGisRepositoryLocaldbImpl getRepository() {
        return (VCSGisRepositoryLocaldbImpl)super.getRepository();
    }

    protected boolean isAuthorized(VCSGisEntity entity) {
        return this.isAuthorized(entity, null);
    }

    protected boolean isAuthorized(VCSGisEntity entity, String permission) {
        if (!this.getRepository().isAuthorized(this)) {
            return false;
        }
        if (!this.getRepository().isAuthorizationRequired()) {
            return true;
        }
        VCSGisUser user = this.getUser();
        if (user == null) {
            this.error(23, "User '" + this.getUserCode() + "' not exists.");
            return false;
        }
        if (StringUtils.isBlank((CharSequence)permission)) {
            permission = this.getRequestName();
        }
        if (entity.isAuthorized(user, permission)) {
            return true;
        }
        this.error(21, "User '" + user.getIdentifier() + "' is not authorized to '" + this.getRequestName() + "' in " + entity.getEntityName() + ".");
        return false;
    }

    protected boolean isAuthorized(String operation) {
        return this.getRepository().isAuthorized(this, operation);
    }

    protected boolean isAuthorized() {
        return this.getRepository().isAuthorized(this);
    }

    public String getAuthenticationToken() {
        return this.helper().getAuthenticationToken();
    }

    public void setAuthenticationToken(String token) {
        this.helper().setAuthenticationToken(token);
    }

    public String getUserCode() {
        return this.helper().getUserCode();
    }

    public VCSGisUser getUser() {
        if (this.user == null) {
            this.user = this.getRepository().getUserByCode(this.getUserCode());
        }
        return this.user;
    }

    public VCSGisUser getUser(String userName) {
        if (this.user == null) {
            try {
                UsersRepoTable users = new UsersRepoTable();
                UsersRepoTable.UserRepoRow theUser = users.getUserById(this.getRepository(), userName);
                this.user = theUser;
            }
            catch (Exception ex) {
                LOGGER.trace("Can't retrieve user '" + this.getUserCode() + "'.", (Throwable)ex);
            }
        }
        return this.user;
    }

    public void setUserCode(String userCode) {
        this.helper().setUserCode(userCode);
        this.user = null;
    }

    public boolean isAutheticated() {
        return this.getRepository().isAuthenticated(this);
    }
}

