/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.json.JsonObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.dal.DataTransaction;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.json.Json;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.logger.FilteredLogger;
import org.gvsig.vcsgis.lib.VCSGisChange;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisEntityEditable;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanStatus;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.TopologyplanRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisCommitRequest;
import org.gvsig.vcsgis.lib.requests.CommitRequestHelper;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspaceEntity;

public class CommitRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisCommitRequest {
    public CommitRequestLocaldb(VCSGisRepositoryLocaldbImpl repository) {
        super(new CommitRequestHelper(repository));
    }

    @Override
    public CommitRequestHelper helper() {
        return (CommitRequestHelper)super.helper();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public Timestamp getRevisionDate() {
        return this.helper().getRevisionDate();
    }

    public void setRevisionDate(Timestamp revisionDate) {
        this.helper().setRevisionDate(revisionDate);
    }

    public String getComment() {
        return this.helper().getComment();
    }

    public void setComment(String comment) {
        this.helper().setComment(comment);
    }

    public VCSGisWorkspaceEntity createEntity(String code, String name) {
        return this.helper().createEntity(code, name);
    }

    public VCSGisWorkspaceEntity createEntity(VCSGisWorkspaceEntity entity) {
        return this.helper().createEntity(entity);
    }

    public void add(VCSGisWorkspaceEntity entity) {
        this.helper().add(entity);
    }

    public void add(DisposableIterable<VCSGisChange> changes) {
        this.helper().add(changes);
    }

    public void markAsNew(VCSGisEntity entity) {
        this.helper().markAsNew(entity);
    }

    public void markAsNew(String entityCode) {
        this.helper().markAsNew(entityCode);
    }

    public List<VCSGisWorkspaceEntity> getChangedLocalEntities() {
        return this.helper().getChangedLocalEntities();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() {
        if (!this.isAuthorized()) {
            return this.getLastErrorCode();
        }
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "'.");
        String currentEntity = null;
        String currentRelatedFeature = null;
        DataTransaction transaction = null;
        try {
            VCSGisEntity entity;
            transaction = DALLocator.getDataManager().createTransaction();
            transaction.begin();
            EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
            RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
            HashMap<String, RevisionsRepoTable.RevisionRepoRow> revisions = new HashMap<String, RevisionsRepoTable.RevisionRepoRow>();
            Map<String, EntitiesRepoTable.EntityRepoRow> repositoryEntities = entitiesTable.getAllAsMap(this.getRepository());
            if (CollectionUtils.isNotEmpty(this.helper().newLocalEntities) && !this.isAuthorized("add")) {
                int n = this.getLastErrorCode();
                return n;
            }
            for (String newLocalEntityCode : this.helper().newLocalEntities) {
                entity = (VCSGisEntity)repositoryEntities.get(newLocalEntityCode);
                if (entity != null) {
                    int n = this.error(510, "Entity '" + entity.getEntityName() + "' already exists, workspace out of date.");
                    return n;
                }
                VCSGisEntityEditable newLocalEntity = this.helper().getChangedLocalEntityByCode(newLocalEntityCode);
                if (newLocalEntity == null) {
                    int n = this.error(510, "Entity '" + newLocalEntityCode + "' is not defined in workspace.");
                    return n;
                }
                for (VCSGisEntity vCSGisEntity : repositoryEntities.values()) {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)vCSGisEntity.getEntityName(), (CharSequence)newLocalEntity.getEntityName())) continue;
                    int n = this.error(510, "Entity '" + newLocalEntity.getEntityName() + "' already exists, workspace out of date.");
                    return n;
                }
            }
            for (VCSGisWorkspaceEntity changedLocalEntity : this.helper().changedLocalEntities) {
                if (this.helper().newLocalEntities.contains(changedLocalEntity.getEntityCode())) continue;
                entity = (VCSGisEntity)repositoryEntities.get(changedLocalEntity.getEntityCode());
                if (entity == null) {
                    int newLocalEntity = this.error(510, "Entity '" + changedLocalEntity.getEntityCode() + "' not exists in repository, workspace out of date.");
                    return newLocalEntity;
                }
                if (!StringUtils.equalsIgnoreCase((CharSequence)entity.getRepositoryRevisionCode(), (CharSequence)changedLocalEntity.getLocalRevisionCode())) {
                    int newLocalEntity = this.error(510, "Revision 'REVISION[" + changedLocalEntity.getLocalRevisionCode() + "]' in 'ENTITY[" + changedLocalEntity.getEntityCode() + "]' not in head, workspace out of date.");
                    return newLocalEntity;
                }
                if (!this.isAuthorized(entity)) {
                    int newLocalEntity = this.getLastErrorCode();
                    return newLocalEntity;
                }
                String topologyPlanCode = changedLocalEntity.getTopologyPlanCode();
                if (!StringUtils.isNotBlank((CharSequence)topologyPlanCode) || changedLocalEntity.getTopologyPlanMode() != 1) continue;
                VCSGisTopologyPlanStatus topologyPlanStatus = this.helper().topologyPlanStatusMap.get(topologyPlanCode);
                TopologyplanRepoTable.TopologyplanRow topologyplanRow = new TopologyplanRepoTable().getTopologyPlanByCode(this.getRepository(), topologyPlanCode);
                if (topologyPlanStatus == null || !StringUtils.equalsIgnoreCase((CharSequence)topologyPlanStatus.getHashCode(), (CharSequence)topologyplanRow.getHashCode())) {
                    int n = this.error(33, "Topology plan for entity '" + changedLocalEntity.getEntityCode() + "' is outdated.");
                    return n;
                }
                if (topologyPlanStatus.isPassed()) continue;
                int n = this.error(32, "Topology plan required for entity '" + changedLocalEntity.getEntityCode() + "'.");
                return n;
            }
            VCSGisRepositoryLocaldbImpl repository = (VCSGisRepositoryLocaldbImpl)this.helper().getRepository();
            FeatureStore storeEntities = repository.openFeatureStore("VCSGISREPO_ENTITIES", null, false);
            transaction.add((DataStore)storeEntities);
            storeEntities.edit(1);
            FeatureStore storeRevisions = repository.openFeatureStore("VCSGISREPO_REVISIONS", null, false);
            transaction.add((DataStore)storeRevisions);
            long nextRevisionNumber = revisionsTable.calculateNextRevisionNumber(storeRevisions);
            storeRevisions.edit(1);
            for (String string : this.helper().newLocalEntities) {
                VCSGisEntityEditable newLocalEntity = this.helper().getChangedLocalEntityByCode(string);
                EntitiesRepoTable.EntityRepoRow repositoryEntity2 = new EntitiesRepoTable.EntityRepoRow(this.getRepository());
                repositoryEntity2.copyfrom((VCSGisEntity)newLocalEntity);
                FeatureType ft = repositoryEntity2.getFeatureType();
                if (ft == null) {
                    repositoryEntity2.setGeometryFieldName(null);
                } else {
                    repositoryEntity2.setGeometryFieldName(ft.getDefaultGeometryAttributeName());
                }
                LOGGER.info("Process request: " + this.getRequestName() + " new entity '" + repositoryEntity2.getEntityName() + "'.");
                repositoryEntity2.insert(storeEntities);
                repositoryEntities.put(repositoryEntity2.getCode(), repositoryEntity2);
            }
            for (VCSGisEntityEditable vCSGisEntityEditable : this.helper().changedLocalEntities) {
                EntitiesRepoTable.EntityRepoRow repositoryEntity = repositoryEntities.get(vCSGisEntityEditable.getEntityCode());
                if (repositoryEntity == null) {
                    transaction.rollback();
                    int repositoryEntity2 = this.error(510, "Entity '" + vCSGisEntityEditable.getEntityCode() + "' not found, workspace out of date.");
                    return repositoryEntity2;
                }
                RevisionsRepoTable.RevisionRepoRow newRevision = new RevisionsRepoTable.RevisionRepoRow(this.getRepository());
                newRevision.newCode();
                newRevision.setOperationDate(this.helper().now());
                if (this.helper().getEfectiveDate() == null) {
                    newRevision.setEfectiveDate(this.helper().now());
                } else {
                    newRevision.setEfectiveDate(this.helper().getEfectiveDate());
                }
                if (this.getRepository().isAllowedToAssignTheRevisionDate() && this.helper().getRevisionDate() != null) {
                    newRevision.setRevisionDate(this.helper().getRevisionDate());
                } else {
                    newRevision.setRevisionDate(DataTypeUtils.toTimestamp((ChronoLocalDateTime)LocalDateTime.now()));
                }
                newRevision.setComment(this.helper().getComment());
                newRevision.setUserCode(this.helper().getUserCode());
                newRevision.setEntityCode(repositoryEntity.getEntityCode());
                newRevision.setRevisionNumber(nextRevisionNumber++);
                String topologyPlanCode = vCSGisEntityEditable.getTopologyPlanCode();
                if (StringUtils.isNotBlank((CharSequence)topologyPlanCode)) {
                    VCSGisTopologyPlanStatus topologyPlanStatus = this.helper().topologyPlanStatusMap.get(topologyPlanCode);
                    if (topologyPlanStatus.isPassed()) {
                        newRevision.setTopologyPlan(1);
                    } else {
                        newRevision.setTopologyPlan(2);
                    }
                } else {
                    newRevision.setTopologyPlan(0);
                }
                newRevision.insert(storeRevisions);
                revisions.put(newRevision.getCode(), newRevision);
                repositoryEntity.setRepositoryRevisionCode(newRevision.getCode());
                repositoryEntity.update(storeEntities);
                vCSGisEntityEditable.setRepositoryRevisionCode(newRevision.getCode());
            }
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            DisposableIterable<VCSGisChange> disposableIterable = this.helper().changes;
            if (disposableIterable != null) {
                FilteredLogger logger = new FilteredLogger(LOGGER, "Commit-insertchanges", 10);
                GeometryManager geometryManager = GeometryLocator.getGeometryManager();
                for (VCSGisChange change : disposableIterable) {
                    currentEntity = change.getEntityCode();
                    currentRelatedFeature = change.getRelatedFeatureData();
                    if (StringUtils.isBlank((CharSequence)change.getRelatedFeatureCode())) {
                        LOGGER.warn("Can't commit: feature code is blank " + change.getCode());
                        transaction.rollback();
                        int n = this.error(520, "Can't commit: feature code is blank " + change.getCode());
                        return n;
                    }
                    EntitiesRepoTable.EntityRepoRow repositoryEntity = repositoryEntities.get(change.getEntityCode());
                    RevisionsRepoTable.RevisionRepoRow revision = (RevisionsRepoTable.RevisionRepoRow)revisions.get(repositoryEntity.getRepositoryRevisionCode());
                    String data = change.getRelatedFeatureData();
                    int operation = change.getOperation();
                    if ((operation == 2 || operation == 1) && StringUtils.isBlank((CharSequence)data)) {
                        LOGGER.warn("Can't commit: feature data is blank (relatedFeatureCode=" + change.getRelatedFeatureCode() + ").");
                        transaction.rollback();
                        int n = this.error(520, "Can't commit: feature data is blank (relatedFeatureCode=" + change.getRelatedFeatureCode() + ").");
                        return n;
                    }
                    Geometry geom = CommitRequestLocaldb.buildBox2D(repository, (VCSGisEntity)repositoryEntity, change.getRelatedFeatureCode(), data, geometryManager, logger);
                    FeatureStore storeData = transaction.getFeatureStore(repositoryEntity.getDataTableName());
                    if (storeData == null) {
                        storeData = repository.openFeatureStore(repositoryEntity.getDataTableName(), null, repository.getDataTableBatchSize(), false);
                        transaction.add((DataStore)storeData, repositoryEntity.getDataTableName());
                        storeData.edit(2);
                    }
                    EditableFeature f = storeData.createNewFeature();
                    DataRepoTable.DataRepoRow row = new DataRepoTable.DataRepoRow(this.getRepository(), repositoryEntity.getDataTableName(), (Feature)f);
                    row.newCode();
                    row.setEntityCode(repositoryEntity.getEntityCode());
                    row.setRevisionCode(revision.getCode());
                    row.setRevisionNumber(revision.getNumber());
                    row.setEfectiveDate(revision.getEfectiveDate());
                    row.setOperation(change.getOperation());
                    row.setIdentifier(change.getRelatedFeatureCode());
                    row.setGeometry(geom);
                    row.setValues(data);
                    row.insert(storeData);
                    hashMap.put(revision.getCode(), hashMap.getOrDefault(revision.getCode(), 0L) + 1L);
                }
            }
            for (Map.Entry changesCounter : hashMap.entrySet()) {
                String revisionCode = (String)changesCounter.getKey();
                Long count = (Long)changesCounter.getValue();
                if (count <= 0L) continue;
                RevisionsRepoTable.RevisionRepoRow revision = (RevisionsRepoTable.RevisionRepoRow)revisions.get(revisionCode);
                revision.setChangesCount(count);
                revision.update(storeRevisions);
            }
            transaction.commit();
            for (VCSGisEntityEditable changedLocalEntity : this.helper().changedLocalEntities) {
                this.getRepository().notifyWatchers(this, changedLocalEntity.getEntityName(), changedLocalEntity.getRepositoryRevisionCode());
            }
            int n = 0;
            return n;
        }
        catch (Exception ex) {
            LOGGER.warn("Can't commit (" + currentEntity + ", " + currentRelatedFeature + ")", (Throwable)ex);
            DataTransaction.rollbackQuietly((DataTransaction)transaction);
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            int n = this.error(500, "Can't commit (" + currentEntity + ", " + currentRelatedFeature + "); " + sw.toString());
            return n;
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)transaction);
        }
    }

    public void add(VCSGisTopologyPlanStatus topologyPlanStatus) {
        this.helper().add(topologyPlanStatus);
    }

    public Collection<VCSGisTopologyPlanStatus> getTopologyPlanStatus() {
        return this.helper().getTopologyPlanStatus();
    }

    public boolean hasNewEntities() {
        return this.helper().hasNewEntities();
    }

    public static Geometry buildBox2D(VCSGisRepositoryLocaldb repository, VCSGisEntity entity, String relatedFeatureCode, String data, GeometryManager geometryManager, FilteredLogger logger) {
        boolean box2d_traces = ((VCSGisRepositoryLocaldbImpl)repository).buildBox2D_traces;
        if (!repository.getIndexGeometries()) {
            if (box2d_traces) {
                LOGGER.info("INDEX_GEOMETRIES false");
            }
            return null;
        }
        if (StringUtils.isBlank((CharSequence)data)) {
            if (box2d_traces) {
                LOGGER.info("String data is blank");
            }
            return null;
        }
        String geom_s = null;
        Geometry geom = null;
        try {
            if (repository.getCRS() == null) {
                if (box2d_traces) {
                    LOGGER.info("REPOSITORY_CRS is blank");
                }
                return null;
            }
            IProjection entityCRS = entity.getCRSAsProjection();
            if (entityCRS == null) {
                if (box2d_traces) {
                    LOGGER.info("Entity '" + entity.getEntityName() + "' CRS is null");
                }
                return null;
            }
            if (!entityCRS.equals(repository.getCRS())) {
                if (box2d_traces) {
                    LOGGER.info("Entity '" + entity.getEntityName() + "' CRS is not repository CRS");
                }
                return null;
            }
            String geometryFieldName = entity.getGeometryFieldName();
            if (StringUtils.isBlank((CharSequence)geometryFieldName)) {
                if (box2d_traces) {
                    LOGGER.info("Entity '" + entity.getEntityName() + "' geometry field name is blank");
                }
                return null;
            }
            JsonObject dataJson = Json.createObject((String)data);
            geom_s = dataJson.getString(geometryFieldName, null);
            try {
                geom = geometryManager.createFrom(geom_s);
            }
            catch (Exception ex) {
                if (box2d_traces) {
                    LOGGER.info("Can't build geometry from '" + geom_s + "'.", (Throwable)ex);
                }
                return null;
            }
            if (geom == null) {
                if (box2d_traces) {
                    LOGGER.info("Can't build geometry from '" + geom_s + "', geometry is null.");
                }
                return null;
            }
            geom = geom.getEnvelope().getBox2D();
            geom.setProjection(entityCRS);
            return geom;
        }
        catch (Exception ex) {
            if (box2d_traces) {
                LOGGER.info("Can't get geometry boundary of " + entity.getEntityCode() + "/" + relatedFeatureCode + ", geom_s='" + geom_s + "'.", (Throwable)ex);
            }
            if (logger == null) {
                LOGGER.warn("Can't get geometry boundary of " + entity.getEntityCode() + "/" + relatedFeatureCode + ".", (Throwable)ex);
            } else {
                logger.warn("Can't get geometry boundary of " + entity.getEntityCode() + "/" + relatedFeatureCode + ".", (Throwable)ex);
            }
            return null;
        }
    }

    private String sqldebug(String sql) throws SQLException {
        return this.getRepository().sqldebug(sql);
    }
}

