/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisRepositoryLogDataImpl;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisLogRequest;
import org.gvsig.vcsgis.lib.requests.LogRequestHelper;

public class LogRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisLogRequest {
    public LogRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        super(new LogRequestHelper(repository, entityName));
    }

    @Override
    public LogRequestHelper helper() {
        return (LogRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public void setFeatureRelatedCode(String featureRelatedCode) {
        this.helper().setFeatureRelatedCode(featureRelatedCode);
    }

    public String getFeatureRelatedCode() {
        return this.helper().getFeatureRelatedCode();
    }

    public DisposableIterable<VCSGisRepositoryLogData> getData() {
        return this.helper().getData();
    }

    public int execute() {
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' entity '" + this.helper().entityName + "', featureRelatedCode'" + this.helper().featureRelatedCode + "'.");
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow entity = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entity == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not exists.");
        }
        if (!this.isAuthorized((VCSGisEntity)entity)) {
            return this.getLastErrorCode();
        }
        DataRepoTable dataTable = this.getRepository().getDataRepoTable(entity.getDataTableName());
        DisposableIterable<Feature> features = dataTable.getDataOfEntityFromFeatureRelatedCode(this.getRepository(), entity.getDataTableName(), entity.getEntityCode(), this.helper().getFeatureRelatedCode());
        this.helper().data = new DisposableIterableAdapter<Feature, VCSGisRepositoryData>(features, new DisposableIterableAdapter.ItemConverter<Feature, VCSGisRepositoryData>(){

            @Override
            public VCSGisRepositoryData convert(Feature f) {
                VCSGisRepositoryLogDataImpl data = new VCSGisRepositoryLogDataImpl(f);
                return data;
            }
        });
        return this.error(0);
    }
}

