/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.requests;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.vcsgis.lib.DisposableIterableAdapter;
import org.gvsig.vcsgis.lib.EntityEditableImpl;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryData;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.requests.AbstractRequestLocaldb;
import org.gvsig.vcsgis.lib.repository.localdb.tables.DataRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.EntitiesRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.RevisionsRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.TopologyplanRepoTable;
import org.gvsig.vcsgis.lib.repository.localdb.tables.UsersRepoTable;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisUpdateRequest;
import org.gvsig.vcsgis.lib.requests.UpdateRequestHelper;

public class UpdateRequestLocaldb
extends AbstractRequestLocaldb
implements VCSGisUpdateRequest {
    public UpdateRequestLocaldb(VCSGisRepositoryLocaldbImpl repository, String entityName) {
        super(new UpdateRequestHelper(repository, entityName));
    }

    @Override
    public UpdateRequestHelper helper() {
        return (UpdateRequestHelper)super.helper();
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public String getLocalRevisionCode() {
        return this.helper().getLocalRevisionCode();
    }

    public void setLocalRevisionCode(String revisionCode) {
        this.helper().setLocalRevisionCode(revisionCode);
    }

    public VCSGisEntity getEntity() {
        return this.helper().getEntity();
    }

    public DisposableIterable<VCSGisRepositoryData> getData() {
        return this.helper().getData();
    }

    public int execute() {
        LOGGER.info("Process request: " + this.getRequestName() + " user '" + this.getUserCode() + "' entity '" + this.helper().entityName + "', localRevisionCode'" + this.helper().localRevisionCode + "'.");
        EntitiesRepoTable entitiesTable = new EntitiesRepoTable();
        EntitiesRepoTable.EntityRepoRow entityRow = entitiesTable.getByEntityName(this.getRepository(), this.helper().entityName);
        if (entityRow == null) {
            LOGGER.warn("Process request: " + this.getRequestName() + " entity '" + this.helper().entityName + "' not found.");
            return this.error(240, "Entity '" + this.helper().entityName + "' not exists.");
        }
        if (!this.isAuthorized((VCSGisEntity)entityRow)) {
            return this.getLastErrorCode();
        }
        this.helper().entity = new EntityEditableImpl();
        this.helper().entity.copyfrom((VCSGisEntity)entityRow);
        RevisionsRepoTable revisionsTable = new RevisionsRepoTable();
        DataRepoTable dataTable = this.getRepository().getDataRepoTable(this.helper().entity.getDataTableName());
        long revisionNumber = -1L;
        if (this.helper().localRevisionCode != null) {
            RevisionsRepoTable.RevisionRepoRow revision = revisionsTable.getByRevisionCode(this.getRepository(), this.helper().localRevisionCode);
            if (revision == null) {
                return this.error(15);
            }
            if (!StringUtils.equalsIgnoreCase((CharSequence)revision.getEntityCode(), (CharSequence)this.helper().entity.getEntityCode())) {
                return this.error(16, "Invalid revision for entity '" + this.helper().entity.getEntityName() + "'");
            }
            revisionNumber = revision.getNumber();
        }
        DisposableIterable<Feature> features = dataTable.getDataOfEntityFromRevisionNumber(this.getRepository(), this.helper().entity.getDataTableName(), this.helper().entity.getEntityCode(), revisionNumber);
        this.helper().data = new DisposableIterableAdapter<Feature, VCSGisRepositoryData>(features, f -> new DataRepoTable.DataRepoRow(this.getRepository(), this.helper().entity.getDataTableName(), (Feature)f));
        this.helper().usersHashCode = new UsersRepoTable().getHashCode(this.getRepository());
        this.helper().topologyPlansHashCode = new TopologyplanRepoTable().getHashCode(this.getRepository());
        return this.error(0);
    }

    public void notifyObservers(String tableName, String operation) {
    }

    public void addObserver(String tableName, String type, String operation, String command) {
    }

    public String getUsersHashCode() {
        return this.helper().getUsersHashCode();
    }

    public String getTopologyPlansHashCode() {
        return this.helper().getTopologyPlansHashCode();
    }
}

