/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.sql.Timestamp;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLocaldb;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRepoTable {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractRepoTable.class);
    private final String tableName;
    private final FeatureType featureType;

    public AbstractRepoTable(String tableName, FeatureType featureType) {
        this.tableName = tableName;
        this.featureType = featureType;
    }

    public String getTableName() {
        return this.tableName;
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public static abstract class AbstractRow {
        protected VCSGisRepositoryLocaldb repository;
        protected EditableFeature feature;
        private final String tableName;
        private final String codeName;

        public AbstractRow(VCSGisRepositoryLocaldb repository, String tableName, String codeName, Feature feature) {
            this.repository = repository;
            this.tableName = tableName;
            this.codeName = codeName;
            this.setFeature(feature);
        }

        public final void setFeature(Feature feature) {
            feature = feature == null ? this.create_feature() : feature.getCopy();
            this.feature = feature instanceof EditableFeature ? (EditableFeature)feature : feature.getEditable();
        }

        private Feature create_feature() {
            EditableFeature editableFeature;
            FeatureStore store = null;
            try {
                store = this.repository.getFeatureStore(this.tableName, false);
                EditableFeature f = store.createNewFeature();
                f.set(this.codeName, (Object)this.repository.createUniqueCode());
                editableFeature = f;
            }
            catch (Exception ex) {
                try {
                    throw new RuntimeException("Can't create a new feature for table '" + this.tableName + "'.", ex);
                }
                catch (Throwable throwable) {
                    DisposeUtils.disposeQuietly(store);
                    throw throwable;
                }
            }
            DisposeUtils.disposeQuietly((Disposable)store);
            return editableFeature;
        }

        protected String getString(String attrname) {
            return this.feature.getString(attrname);
        }

        protected Timestamp getTimestamp(String attrname) {
            return this.feature.getTimestamp(attrname);
        }

        protected int getInt(String attrname) {
            return this.feature.getIntOrDefault(attrname, -1);
        }

        protected int getInt(String attrname, int defaultValue) {
            return this.feature.getIntOrDefault(attrname, defaultValue);
        }

        protected long getLong(String attrname) {
            return this.feature.getLongOrDefault(attrname, -1L);
        }

        protected long getLong(String attrname, long defaultValue) {
            return this.feature.getLongOrDefault(attrname, defaultValue);
        }

        protected boolean getBoolean(String attrname) {
            return this.feature.getBooleanOrDefault(attrname, false);
        }

        protected boolean getBoolean(String attrname, boolean defaultValue) {
            return this.feature.getBooleanOrDefault(attrname, defaultValue);
        }

        protected void set(String attrname, String value) {
            this.feature.set(attrname, (Object)value);
        }

        protected void set(String attrname, int value) {
            this.feature.set(attrname, (Object)value);
        }

        protected void set(String attrname, long value) {
            this.feature.set(attrname, (Object)value);
        }

        protected void set(String attrname, boolean value) {
            this.feature.set(attrname, (Object)value);
        }

        protected void set(String attrname, Timestamp value) {
            this.feature.set(attrname, (Object)value);
        }

        public void insert() {
            FeatureStore store = null;
            try {
                store = this.repository.getFeatureStore(this.tableName, false);
                store.edit(3);
                this.insert(store);
                store.finishEditing();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't insert feature on '" + this.tableName + "'.", ex);
            }
            finally {
                if (store != null) {
                    store.cancelEditingQuietly();
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
            }
        }

        public void update() {
            FeatureStore store = null;
            try {
                store = this.repository.getFeatureStore(this.tableName, false);
                store.edit(3);
                this.update(store);
                store.finishEditing();
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
            }
            finally {
                if (store != null) {
                    store.cancelEditingQuietly();
                    DisposeUtils.disposeQuietly((Disposable)store);
                }
            }
        }

        public void insert(FeatureStore store) {
            try {
                EditableFeature f = store.createNewFeature((Feature)this.feature);
                store.insert(f);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't insert feature on '" + this.tableName + "'.", ex);
            }
        }

        public void update(FeatureStore store) {
            try {
                EditableFeature f = store.createNewFeature((Feature)this.feature);
                f.setUpdatable(true);
                store.update(f);
            }
            catch (Exception ex) {
                throw new RuntimeException("Can't update feature on '" + this.tableName + "'.", ex);
            }
        }

        public String getCode() {
            return this.feature.getString(this.codeName);
        }

        public void newCode() {
            this.feature.set(this.codeName, (Object)this.repository.createUniqueCode());
        }

        public void setCode(String code) {
            this.feature.set(this.codeName, (Object)code);
        }
    }
}

