/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.localdb.tables;

import java.security.MessageDigest;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.localdb.VCSGisRepositoryLocaldbImpl;
import org.gvsig.vcsgis.lib.repository.localdb.tables.AbstractRepoTable;

public class TopologyplanRepoTable
extends AbstractRepoTable {
    public static final String TABLE_NAME = "VCSGISREPO_TOPOLOGYPLANS";
    public static final String COD_TOPOLOGYPLAN = "COD_TOPOLOGYPLAN";
    public static final String TOPPLAN_NAME = "TOPP_NAME";
    private static final String TOPPLAN_DESCRIPTION = "TOPP_DESCRIPTION";
    private static final String TOPPLAN_DATA = "TOPP_DATA";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS TopologyPlans");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.getTags().set("dynform.height", (Object)300);
        ft.getTags().set("dynform.width", (Object)570);
        ft.getTags().set("dynform.layoutmode", (Object)"tabs");
        ft.add(COD_TOPOLOGYPLAN, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>");
        ft.add(TOPPLAN_NAME, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(200).setLabel("Name");
        ft.add(TOPPLAN_DESCRIPTION, 8).setDataProfileName("Text").setSize(4096).setLabel("Description");
        ft.add(TOPPLAN_DATA, 8).setTag("dynform.resizeWeight", (Object)60).setTag("dynform.label.empty", (Object)true).setDataProfileName("Text").setSize(4096).setLabel("Data").setGroup("Plan").setDescription("Topology plan serialized as Json");
        return ft.getNotEditableCopy();
    }

    public TopologyplanRepoTable() {
        super(TABLE_NAME, TopologyplanRepoTable.featureType());
    }

    public String getByCode(VCSGisRepositoryLocaldbImpl repository, String topologyPlanCode) {
        String string;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"COD_TOPOLOGYPLAN\"='" + topologyPlanCode + "'");
            if (f != null) break block5;
            String string2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return string2;
        }
        try {
            string = f.getString(TOPPLAN_DATA);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve topology plan '" + topologyPlanCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return string;
    }

    public TopologyplanRow getTopologyPlanByCode(VCSGisRepositoryLocaldbImpl repository, String topologyPlanCode) {
        TopologyplanRow topologyplanRow;
        Feature f;
        FeatureStore store;
        block5: {
            store = null;
            store = repository.getFeatureStore(TABLE_NAME, true);
            f = store.findFirst("\"COD_TOPOLOGYPLAN\"='" + topologyPlanCode + "'");
            if (f != null) break block5;
            TopologyplanRow topologyplanRow2 = null;
            DisposeUtils.disposeQuietly((Disposable)store);
            return topologyplanRow2;
        }
        try {
            topologyplanRow = new TopologyplanRow(repository, f);
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve topology plan '" + topologyPlanCode + "'.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)store);
        return topologyplanRow;
    }

    public DisposableFeatureSetIterable getAll(VCSGisRepositoryLocaldbImpl repository) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = repository.getFeatureStore(TABLE_NAME, true);
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet().iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve all topology plans.", ex);
        }
        finally {
            if (store != null) {
                DisposeUtils.dispose((Disposable)store);
            }
        }
    }

    public String getHashCode(VCSGisRepositoryLocaldbImpl repository) {
        String string;
        FeatureStore store = null;
        DisposableFeatureSetIterable changes = null;
        try {
            String hash;
            MessageDigest md = MessageDigest.getInstance("MD5");
            store = repository.getFeatureStore(TABLE_NAME, true);
            changes = store.getFeatureSet().iterable();
            for (Feature change : changes) {
                VCSGisUtils.updateMessageDigest(md, change, COD_TOPOLOGYPLAN);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_NAME);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_DESCRIPTION);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_DATA);
            }
            string = hash = Hex.encodeHexString((byte[])md.digest());
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve hash of topology plans.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.dispose(changes);
                DisposeUtils.dispose(store);
                throw throwable;
            }
        }
        DisposeUtils.dispose((Disposable)changes);
        DisposeUtils.dispose((Disposable)store);
        return string;
    }

    public static class TopologyplanRow
    extends AbstractRepoTable.AbstractRow
    implements VCSGisTopologyPlan {
        public TopologyplanRow(VCSGisRepositoryLocaldbImpl repository) {
            super(repository, TopologyplanRepoTable.TABLE_NAME, TopologyplanRepoTable.COD_TOPOLOGYPLAN, null);
        }

        public TopologyplanRow(VCSGisRepositoryLocaldbImpl repository, Feature feature) {
            super(repository, TopologyplanRepoTable.TABLE_NAME, TopologyplanRepoTable.COD_TOPOLOGYPLAN, feature);
        }

        public String getTopologyPlanCode() {
            return this.getString(TopologyplanRepoTable.COD_TOPOLOGYPLAN);
        }

        public String getName() {
            return this.getString(TopologyplanRepoTable.TOPPLAN_NAME);
        }

        public String getDescription() {
            return this.getString(TopologyplanRepoTable.TOPPLAN_DESCRIPTION);
        }

        public String getData() {
            return this.getString(TopologyplanRepoTable.TOPPLAN_DATA);
        }

        public String getLabel() {
            return this.getName();
        }

        public VCSGisTopologyPlan getValue() {
            return this;
        }

        public void copyFrom(VCSGisTopologyPlan other) {
            this.set(TopologyplanRepoTable.COD_TOPOLOGYPLAN, other.getTopologyPlanCode());
            this.set(TopologyplanRepoTable.TOPPLAN_NAME, other.getName());
            this.set(TopologyplanRepoTable.TOPPLAN_DESCRIPTION, other.getDescription());
            this.set(TopologyplanRepoTable.TOPPLAN_DATA, other.getData());
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisTopologyPlanImpl.toJsonBuilder(this);
        }

        public String toString() {
            return VCSGisTopologyPlanImpl.toString(this);
        }

        public String getHashCode() {
            return VCSGisTopologyPlanImpl.getHashCode(this);
        }
    }
}

