/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonValue;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkingCopyInformation;
import org.gvsig.vcsgis.lib.VCSGisPreparedWorkspaceInformationImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisListWCRequest;
import org.gvsig.vcsgis.lib.requests.ListWCRequestHelper;

public class ListWCRequestClient
extends AbstractRequestClient
implements VCSGisListWCRequest {
    public ListWCRequestClient(VCSGisRepositoryClientImpl repository) {
        super(new ListWCRequestHelper(repository), "listwc");
    }

    @Override
    public ListWCRequestHelper helper() {
        return (ListWCRequestHelper)super.helper();
    }

    public List<VCSGisPreparedWorkingCopyInformation> getWorkingCopiesInformation() {
        return this.helper().getWorkingCopiesInformation();
    }

    @Override
    public void requestProducer(Writer out) {
        this.error(0);
    }

    @Override
    public void responseConsumer(BufferedReader inputData) {
        try {
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer");
            ArrayList<VCSGisPreparedWorkingCopyInformation> theWorkspaces = new ArrayList<VCSGisPreparedWorkingCopyInformation>();
            JsonReader reader = Json.createReader((Reader)inputData);
            JsonObject jsonResponse = reader.readObject();
            JsonObject jsonParameters = jsonResponse.getJsonObject("Parameters");
            int statusCode = jsonParameters.getInt("StatusCode", 250);
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer status code " + statusCode);
            if (statusCode != 0) {
                this.error(statusCode, jsonParameters.getString("StatusMessage", VCSGisUtils.getErrorMessage(statusCode)));
                return;
            }
            this.cleanLastError();
            JsonArray jsonWorkspaces = jsonParameters.getJsonArray("WorkingCopiesInformation");
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer workspaces " + jsonWorkspaces.size());
            for (JsonValue x : jsonWorkspaces) {
                VCSGisPreparedWorkspaceInformationImpl w = new VCSGisPreparedWorkspaceInformationImpl((JsonObject)x);
                LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer workspace " + w.getName());
                theWorkspaces.add(w);
            }
            this.helper().workingCopiesInformation = theWorkspaces;
            LOGGER.debug("===: [" + this.getRequestName() + "] responseConsumer ok");
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't retrieve entities from '" + this.getRequestUrl() + "'.", (Throwable)ex);
            this.error(250, "Can't retrieve prepared workspaces from '" + this.getRequestUrl() + "'.");
        }
    }
}

