/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.repository.remoteclient.requests;

import java.io.BufferedReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Timestamp;
import javax.json.JsonObject;
import javax.json.JsonReader;
import org.apache.commons.io.IOUtils;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.vcsgis.lib.repository.remoteclient.VCSGisRepositoryClientImpl;
import org.gvsig.vcsgis.lib.repository.remoteclient.requests.AbstractRequestClient;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRowDeleteRequest;
import org.gvsig.vcsgis.lib.requests.RowDeleteRequestHelper;

public class RowDeleteRequestClient
extends AbstractRequestClient
implements VCSGisRowDeleteRequest {
    public RowDeleteRequestClient(VCSGisRepositoryClientImpl repository, String entityName, String localRevisionCode) {
        super(new RowDeleteRequestHelper(repository, entityName, localRevisionCode), "rowdelete");
    }

    @Override
    public RowDeleteRequestHelper helper() {
        return (RowDeleteRequestHelper)super.helper();
    }

    public Timestamp getEfectiveDate() {
        return this.helper().getEfectiveDate();
    }

    public void setEfectiveDate(Timestamp efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getComment() {
        return this.helper().getComment();
    }

    public void setComment(String comment) {
        this.helper().setComment(comment);
    }

    public String getEntityName() {
        return this.helper().getEntityName();
    }

    public void setEfectiveDate(String efectiveDate) {
        this.helper().setEfectiveDate(efectiveDate);
    }

    public String getEntityCode() {
        return this.helper().getEntityCode();
    }

    public String getEntityRevisionCode() {
        return this.helper().getEntityRevisionCode();
    }

    public String getRelatedFeatureCode() {
        return this.helper().getRelatedFeatureCode();
    }

    public void setRelatedFeatureCode(String relatedFeatureCode) {
        this.helper().setRelatedFeatureCode(relatedFeatureCode);
    }

    public String getLocalRevisionCode() {
        return this.helper().getLocalRevisionCode();
    }

    @Override
    public void requestProducer(Writer out) {
        try {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("EntityName", this.getEntityName());
            builder.add("LocalRevisionCode", this.getLocalRevisionCode());
            builder.add("RelatedFeatureCode", this.getRelatedFeatureCode());
            if (this.getEfectiveDate() == null) {
                builder.addNull("EfectiveDate");
            } else {
                builder.add("EfectiveDate", this.getEfectiveDate().toString());
            }
            builder.add("Comment", this.getComment());
            this.notifyRequestConsumers();
            IOUtils.write((String)builder.toString(), (Writer)out);
            this.error(0);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't produce Json data for " + this.getRequestName() + " request.", (Throwable)ex);
            this.error(600, "Can't produce Json data for " + this.getRequestName() + " request. " + ex.getMessage());
        }
        finally {
            IOUtils.closeQuietly((Writer)out);
        }
    }

    @Override
    public void responseConsumer(BufferedReader dataReader) {
        JsonReader reader = Json.createReader((Reader)dataReader);
        JsonObject jsonResponse = reader.readObject();
        JsonObject parameters = jsonResponse.getJsonObject("Parameters");
        this.error(parameters.getInt("StatusCode", 0), parameters.getString("StatusMessage", null));
        this.helper().entityCode = parameters.getString("EntityCode", null);
        this.helper().entityRevision = parameters.getString("RevisionCode", null);
        this.notifyResponseConsumers();
    }
}

