/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import java.util.Map;
import org.gvsig.vcsgis.lib.SupportError;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.requests.RequestHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRequest
implements VCSGisRequest,
SupportError {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractRequest.class);
    private final RequestHelper helper;

    public AbstractRequest(RequestHelper helper) {
        this.helper = helper;
    }

    public RequestHelper helper() {
        return this.helper;
    }

    public String getCode() {
        return this.helper.getCode();
    }

    public String getRequestName() {
        return this.helper.getRequestName();
    }

    public int getLastErrorCode() {
        return this.helper.getLastErrorCode();
    }

    public String getLastErrorMessage() {
        return this.helper.getLastErrorMessage();
    }

    public VCSGisRepository getRepository() {
        return this.helper.getRepository();
    }

    public int error(int code) {
        return this.helper.error(code, null);
    }

    public int error(int code, String message) {
        return this.helper.error(code, message);
    }

    public void dispose() {
        this.helper.dispose();
    }

    public void setEnabledStatus(boolean enable) {
        this.helper().setEnabledStatus(enable);
    }

    public void setAuthenticationTokenAndUser(Map<String, String> params) {
        this.setAuthenticationToken(params.get("auth"));
        this.setUserCode(params.get("user"));
    }

    public void cleanLastError() {
        this.helper().cleanLastError();
    }
}

