/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.requests;

import java.sql.Timestamp;
import org.gvsig.tools.dispose.DisposableIterable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisRevision;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisHistoryRequest;
import org.gvsig.vcsgis.lib.requests.AbstractRequestHelper;

public class HistoryRequestHelper
extends AbstractRequestHelper
implements VCSGisHistoryRequest {
    private static final String REQUEST_NAME = "History";
    public String entityName;
    public Timestamp minDate;
    public Timestamp maxDate;
    public long minRevisionNumber;
    public long maxRevisionNumber;
    public int maxNumberOfRevisions;
    public DisposableIterable<VCSGisRevision> revisions;

    public HistoryRequestHelper(VCSGisRepository repository, String entityName) {
        super(repository, REQUEST_NAME);
        this.entityName = entityName;
        this.minDate = null;
        this.maxDate = null;
        this.minRevisionNumber = -1L;
        this.maxRevisionNumber = -1L;
        this.maxNumberOfRevisions = 1000;
        this.revisions = null;
    }

    @Override
    public void dispose() {
        super.dispose();
        DisposeUtils.disposeQuietly(this.revisions);
        this.entityName = null;
        this.minDate = null;
        this.maxDate = null;
        this.minRevisionNumber = -1L;
        this.maxRevisionNumber = -1L;
        this.maxNumberOfRevisions = -1;
        this.revisions = null;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public DisposableIterable<VCSGisRevision> getRevisions() {
        if (this.revisions == null) {
            throw new IllegalStateException("The request needs to be executed before calling this method.");
        }
        return this.revisions;
    }

    public Timestamp getMinDate() {
        return this.minDate;
    }

    public Timestamp getMaxDate() {
        return this.maxDate;
    }

    public long getMinRevisionNumber() {
        return this.minRevisionNumber;
    }

    public long getMaxRevisionNumber() {
        return this.maxRevisionNumber;
    }

    public void setDateRange(Timestamp min, Timestamp max) {
        this.minDate = min;
        this.maxDate = max;
    }

    public void setRevisionNumberRange(long min, long max) {
        this.minRevisionNumber = min;
        this.maxRevisionNumber = max;
    }

    public void setMaxNumberOfRevisions(int maxNumberOfRevisions) {
        this.maxNumberOfRevisions = maxNumberOfRevisions;
    }
}

