/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.server.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import javax.json.JsonObjectBuilder;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.json.Json;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisRuntimeException;
import org.gvsig.vcsgis.lib.repository.VCSGisRepository;
import org.gvsig.vcsgis.lib.repository.requests.VCSGisRequest;
import org.gvsig.vcsgis.lib.server.VCSGisServerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVCSGisServertHandler
implements VCSGisServerHandler {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractVCSGisServertHandler.class);
    private final VCSGisRepository repository;
    private final String name;
    private final Object syncRequest;
    private final Object syncResponse;

    public AbstractVCSGisServertHandler(VCSGisRepository repository, String name) {
        this.repository = repository;
        this.name = name;
        this.syncRequest = new Object();
        this.syncResponse = new Object();
    }

    public String getContentType() {
        return "application/json";
    }

    public VCSGisRepository getRepository() {
        return this.repository;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitRequestProducer() throws InterruptedException {
        Object object = this.syncRequest;
        synchronized (object) {
            this.syncRequest.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRequestConsumers() {
        Object object = this.syncRequest;
        synchronized (object) {
            this.syncRequest.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitResponseProducer() throws InterruptedException {
        Object object = this.syncResponse;
        synchronized (object) {
            this.syncResponse.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyResponseConsumers() {
        Object object = this.syncResponse;
        synchronized (object) {
            this.syncResponse.notifyAll();
        }
    }

    public void createResponseToWriter(VCSGisRequest request, Writer out) throws IOException, InterruptedException {
        LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream 1");
        MutableObject exceptionOfProducer = new MutableObject(null);
        Thread task = new Thread(() -> {
            try {
                this.responseProducer(request, out);
            }
            catch (Exception ex) {
                exceptionOfProducer.setValue((Object)ex);
                LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream.task 2 notifyResponseConsumers");
                this.notifyResponseConsumers();
                LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream.task 3 throw ex");
                throw new VCSGisRuntimeException(8, "Can't build response for request (" + this.getName() + ")", (Throwable)ex);
            }
        }, this.getName() + "ResponseProducer");
        LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream 4 start");
        task.start();
        LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream 5 waitResponseProducer");
        this.waitResponseProducer();
        if (exceptionOfProducer.getValue() != null) {
            LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream 6 throw ex");
            throw new VCSGisRuntimeException(10, "Can't create response from data (" + this.getName() + ").", (Throwable)exceptionOfProducer.getValue());
        }
        LOGGER.debug("===: [" + this.getName() + "] createResponseAsInputStream 7 return");
    }

    public VCSGisRequest createRequestFromInputStream(Map<String, String> params, InputStream request_contents) throws IOException, InterruptedException {
        LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream 1");
        MutableObject request = new MutableObject();
        MutableObject exceptionOfProducer = new MutableObject(null);
        Thread task = new Thread(() -> {
            InputStreamReader isr = null;
            try {
                isr = new InputStreamReader(request_contents, StandardCharsets.UTF_8);
                this.requestProducer((MutableObject<VCSGisRequest>)request, params, isr);
            }
            catch (Exception ex) {
                try {
                    LOGGER.warn("Can't build request (" + this.getName() + ")", (Throwable)ex);
                    exceptionOfProducer.setValue((Object)ex);
                    LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream.task 3 notifyRequestConsumers");
                    this.notifyRequestConsumers();
                    LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream.task 3 throw ex");
                    throw new VCSGisRuntimeException(9, "Can't build request (" + this.getName() + ")", (Throwable)ex);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(isr);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Reader)isr);
        }, this.getName() + "RequestProducer");
        LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream 2 start");
        task.start();
        LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream 3 waitRequestProducer");
        this.waitRequestProducer();
        if (exceptionOfProducer.getValue() != null) {
            LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream 4 exeception");
            throw new VCSGisRuntimeException(10, "Can't create request from data (" + this.getName() + ").", (Throwable)exceptionOfProducer.getValue());
        }
        LOGGER.debug("===: [" + this.getName() + "] createRequestFromInputStream 5 return");
        return (VCSGisRequest)request.getValue();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handle(Writer console, Map<String, String> params, InputStream request_contents, Writer response_contents) {
        VCSGisRequest request = null;
        try {
            if (params == null) {
                params = Collections.EMPTY_MAP;
            }
            LOGGER.debug("===: [" + this.getName() + "] handle 1 createRequestFromInputStream");
            request = this.createRequestFromInputStream(params, request_contents);
            request.setEnabledStatus(false);
            LOGGER.debug("===: [" + this.getName() + "] handle 2 execute");
            switch (request.execute()) {
                case 0: {
                    LOGGER.debug("===: [" + this.getName() + "] handle 3 createResponseAsInputStream");
                    this.responseProducer(request, response_contents);
                    break;
                }
                default: {
                    LOGGER.warn("Process request: " + request.getRequestName() + ", " + request.getLastErrorCode() + " " + request.getLastErrorMessage());
                    this.responseErrorProducer(request, response_contents);
                    console.write(request.getRequestName() + " failed. error " + request.getLastErrorCode() + " , " + request.getLastErrorMessage());
                }
            }
            LOGGER.debug("===: [" + this.getName() + "] handle 6 return");
        }
        catch (VCSGisRuntimeException ex) {
            try {
                LOGGER.warn("Can't handle request (" + this.getName() + ").", (Throwable)ex);
                throw ex;
                catch (Exception ex2) {
                    LOGGER.warn("Can't handle request (" + this.getName() + ").", (Throwable)ex2);
                    throw new VCSGisRuntimeException(10, "Can't handle request (" + this.getName() + ").", (Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(request);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)request);
    }

    protected abstract void responseProducer(VCSGisRequest var1, Writer var2) throws IOException;

    protected abstract void requestProducer(MutableObject<VCSGisRequest> var1, Map<String, String> var2, Reader var3) throws IOException;

    protected void responseErrorProducer(VCSGisRequest req, Writer response_contents) throws IOException {
        LOGGER.debug("===: [" + this.getName() + "] responseErrorProducer  1");
        org.gvsig.json.JsonObjectBuilder jsonResponse = Json.createObjectBuilder();
        org.gvsig.json.JsonObjectBuilder jsonParameters = Json.createObjectBuilder();
        jsonParameters.add("StatusCode", req.getLastErrorCode());
        jsonParameters.add("StatusMessage", req.getLastErrorMessage());
        jsonResponse.add("Parameters", (JsonObjectBuilder)jsonParameters);
        IOUtils.write((String)jsonResponse.toString(), (Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseErrorProducer  2 flush");
        response_contents.flush();
        LOGGER.debug("===: [" + this.getName() + "] responseErrorProducer  3 close");
        IOUtils.closeQuietly((Writer)response_contents);
        LOGGER.debug("===: [" + this.getName() + "] responseErrorProducer  4 return");
    }
}

