/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace;

import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;

public class StoreProperties {
    private static final String STORE_PROPERTY_WORKSPACE = "VCSGIS_WORKSPACE";
    private static final String STORE_PROPERTY_ENTITY = "VCSGIS_ENTITY";
    private static final String STORE_NOT_IN_VCS = "STORE_NOT_IN_VCS";
    public static final int MODE_UNKNOWN = 0;
    public static final int MODE_VCS = 1;
    public static final int MODE_NOT_VCS = 2;

    public static void set(FeatureStore store, VCSGisWorkspace workspace, String entityName) {
        if (store == null) {
            return;
        }
        store.setProperty(STORE_PROPERTY_WORKSPACE, (Object)workspace.getCode());
        store.setProperty(STORE_PROPERTY_ENTITY, (Object)entityName);
    }

    public static void setNotVCSMode(FeatureStore store) {
        if (store == null) {
            return;
        }
        store.setProperty(STORE_PROPERTY_WORKSPACE, (Object)STORE_NOT_IN_VCS);
        store.setProperty(STORE_PROPERTY_ENTITY, (Object)STORE_NOT_IN_VCS);
    }

    public static void setUnknownVCSMode(FeatureStore store) {
        if (store == null) {
            return;
        }
        store.setProperty(STORE_PROPERTY_WORKSPACE, null);
        store.setProperty(STORE_PROPERTY_ENTITY, null);
    }

    public static int getVCSMode(FeatureStore store) {
        String workspace_code = (String)store.getProperty(STORE_PROPERTY_WORKSPACE);
        if (workspace_code == null) {
            return 0;
        }
        if (workspace_code.equalsIgnoreCase(STORE_NOT_IN_VCS)) {
            return 2;
        }
        return 1;
    }

    public static String getWorkspaceCode(FeatureStore store) {
        String workspace_code = (String)store.getProperty(STORE_PROPERTY_WORKSPACE);
        return workspace_code;
    }

    public static String getEntityName(FeatureStore store) {
        String entityName = (String)store.getProperty(STORE_PROPERTY_ENTITY);
        return entityName;
    }
}

