/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace.tables;

import java.sql.Timestamp;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dataTypes.DataTypeUtils;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.tools.dynobject.DynObjectValueItem;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.GetItemWithSizeIsEmptyAndIterator64;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.repository.VCSGisRepositoryLogData;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.AbstractTable;

public class LogsTable
extends AbstractTable {
    public static final String TABLE_NAME = "VCSGIS_LOGS";
    public static final String COD_LOG = "COD_LOG";
    public static final String COD_ENTITY = "COD_ENTITY";
    public static final String COD_REVISION = "COD_REVISION";
    public static final String COD_USER = "COD_USER";
    public static final String LOG_REVNUMBER = "LOG_REVNUMBER";
    public static final String LOG_OPERATION = "LOG_OPERATION";
    public static final String LOG_FEATURERELATEDCODE = "LOG_FEATURERELATEDCODE";
    public static final String LOG_FEATURE_DATA = "LOG_DATA";
    public static final String LOG_COMMENT = "LOG_COMMENT";
    public static final String LOG_EFECTIVEDATE = "LOG_EFECTIVEDATE";
    public static final String LOG_REVISIONDATE = "LOG_OPERATIONDATE";
    public static final String LOG_TAGS = "LOG_TAGS";
    public static final String LOG_TOPOLOGYPLAN = "LOG_TOPPLAN";
    public static final String LOG_CHANGESCOUNT = "LOG_CHANGESCOUNT";
    public static final int DATA_SIZE = 4096;

    public LogsTable() {
        super(TABLE_NAME, LogsTable.featureType());
    }

    public void deleteAll(VCSGisWorkspace workspace) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.delete("TRUE");
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete all remote changes.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public void delete(VCSGisWorkspace workspace, String featureRelatedCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            store.delete("\"LOG_FEATURERELATEDCODE\"='" + featureRelatedCode + "'");
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't delete logs.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public GetItemWithSize64<Feature> getByEntityCode(VCSGisWorkspace workspace, String featureRelatedCode) {
        FeatureStore store = null;
        try {
            GetItemWithSizeIsEmptyAndIterator64 changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureQuery query = store.createFeatureQuery();
            query.getOrder().add(LOG_EFECTIVEDATE, true);
            ExpressionBuilder builder = store.createExpressionBuilder();
            String filter = builder.eq((ExpressionBuilder.Value)builder.column(COD_ENTITY), (ExpressionBuilder.Value)builder.constant((Object)featureRelatedCode)).toString();
            query.setFilter(filter);
            query.retrievesAllAttributes();
            GetItemWithSizeIsEmptyAndIterator64 getItemWithSizeIsEmptyAndIterator64 = changes = store.getFeatures64(query, -1);
            return getItemWithSizeIsEmptyAndIterator64;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve logs.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS Remote changes");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_LOG, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setReadOnly(false).setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>");
        ft.add(COD_ENTITY, 8).setForeingkey(true, false, "VCSGIS_ENTITIES", COD_ENTITY, "ENT_NAME").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. entity");
        ft.add(COD_REVISION, 8).setForeingkey(true, false, "VCSGIS_LOCALREVISIONS", COD_REVISION, "FORMAT('r%d %s', REV_NUMBER, REV_OPERATIONDATE)").setSize(60).setLabel("Revision");
        ft.add(COD_USER, 8).setForeingkey(true, false, "VCSGIS_USERS", COD_USER, "USER_ID").setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(60).setLabel("Cod. user");
        ft.add(LOG_REVNUMBER, 5).setIsIndexed(true).setAllowIndexDuplicateds(true).setLabel("Revision number");
        ft.add(LOG_OPERATION, 4).setLabel("Operation").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)2, "Insert"), new DynObjectValueItem((Object)1, "Update"), new DynObjectValueItem((Object)0, "Delete")});
        ft.add(LOG_FEATURERELATEDCODE, 8).setAllowIndexDuplicateds(true).setIsIndexed(false).setSize(60).setLabel("Identifier").setDescription("Feature code");
        ft.add(LOG_FEATURE_DATA, 8).setSize(4096).setLabel("Data");
        ft.add(LOG_TOPOLOGYPLAN, 4).setIsIndexed(false).setLabel("Topology plan").setAvailableValues(new DynObjectValueItem[]{new DynObjectValueItem((Object)0, "Unknown"), new DynObjectValueItem((Object)1, "Passed"), new DynObjectValueItem((Object)2, "Not passed")});
        ft.add(LOG_TAGS, 8).setSize(200).setLabel("Tags");
        ft.add(LOG_COMMENT, 8).setDataProfileName("Text").setSize(500).setLabel("Comment");
        ft.add(LOG_CHANGESCOUNT, 5).setIsIndexed(false).setLabel("Changes count");
        ft.add(LOG_EFECTIVEDATE, 11).setLabel("Efective date");
        ft.add(LOG_REVISIONDATE, 11).setLabel("Revision date");
        return ft.getNotEditableCopy();
    }

    public DisposableFeatureSetIterable getGroupedByEntity(VCSGisWorkspace workspace) {
        FeatureStore store = null;
        try {
            DisposableFeatureSetIterable changes;
            store = workspace.getFeatureStore(TABLE_NAME);
            FeatureQuery query = store.createFeatureQuery();
            query.getOrder().add(COD_ENTITY, true);
            query.getGroupByColumns().add(COD_ENTITY);
            query.retrievesAllAttributes();
            DisposableFeatureSetIterable disposableFeatureSetIterable = changes = store.getFeatureSet(query).iterable();
            return disposableFeatureSetIterable;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve changes grouped by entity.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public boolean updateStateFromLocalChanges(VCSGisWorkspace workspace, int status) {
        String sql = String.format(VCSGisUtils.getSqlTemplate(workspace.getExplorer().getProviderName(), "updateStateFromLocalChanges", new Object[0]), status);
        workspace.getExplorer().execute(sql);
        return true;
    }

    public static class LogRow
    extends AbstractTable.AbstractRow
    implements VCSGisRepositoryLogData {
        protected VCSGisEntity entity;

        public LogRow(VCSGisWorkspace workspace) {
            super(workspace, LogsTable.TABLE_NAME, LogsTable.COD_LOG);
        }

        public LogRow(VCSGisWorkspace workspace, Feature feature) {
            super(workspace, LogsTable.TABLE_NAME, LogsTable.COD_LOG, feature);
        }

        public String getDataCode() {
            return this.getCode();
        }

        public String getEntityCode() {
            return this.getString(LogsTable.COD_ENTITY);
        }

        public String getRevisionCode() {
            return this.getString(LogsTable.COD_REVISION);
        }

        public long getRevisionNumber() {
            return this.getLong(LogsTable.LOG_REVNUMBER);
        }

        public Timestamp getEfectiveDate() {
            return this.getTimestamp(LogsTable.LOG_EFECTIVEDATE);
        }

        public Timestamp getRevisionDate() {
            return this.getTimestamp(LogsTable.LOG_REVISIONDATE);
        }

        public int getOperation() {
            return this.getInt(LogsTable.LOG_OPERATION);
        }

        public String getOperationLabel() {
            return VCSGisUtils.getOperationLabel(this.getOperation());
        }

        public String getData() {
            return this.getString(LogsTable.LOG_FEATURE_DATA);
        }

        public JsonObject getDataAsJson() {
            JsonObject json = Json.createObject((String)this.getString(LogsTable.LOG_FEATURE_DATA));
            return json;
        }

        public String getUserCode() {
            return this.getString(LogsTable.COD_USER);
        }

        public String getComment() {
            return this.getString(LogsTable.LOG_COMMENT);
        }

        public int getTopologyPlan() {
            return this.getInt(LogsTable.LOG_TOPOLOGYPLAN);
        }

        public String getTags() {
            return this.getString(LogsTable.LOG_TAGS);
        }

        public String getFeatureRelatedCode() {
            return this.getString(LogsTable.LOG_FEATURERELATEDCODE);
        }

        public VCSGisEntity getEntity() {
            if (this.entity == null) {
                this.entity = this.workspace.getWorkspaceEntityByCode(this.getEntityCode());
                if (this.entity == null) {
                    this.entity = this.workspace.getRepositoryEntityByCode(this.getEntityCode());
                }
            }
            return this.entity;
        }

        private static String convertJsonValueToString(JsonValue jsonValue) {
            if (jsonValue == null) {
                return "";
            }
            if (jsonValue instanceof JsonString) {
                String jsonString = jsonValue.toString();
                return jsonString.substring(1, jsonString.length() - 1);
            }
            return jsonValue.toString();
        }

        public JsonObjectBuilder toJsonBuilder() {
            JsonObjectBuilder builder = Json.createObjectBuilder();
            builder.add("DataCode", this.getDataCode());
            if (this.getEntityCode() != null) {
                builder.add("EntityCode", this.getEntityCode());
            }
            builder.add("RevisionCode", this.getRevisionCode());
            builder.add("RevisionNumber", this.getRevisionNumber());
            if (this.getEfectiveDate() == null) {
                builder.addNull("EfectiveDate");
            } else {
                builder.add("EfectiveDate", this.getEfectiveDate().toString());
            }
            builder.add("Operation", this.getOperation());
            builder.add("FeatureRelatedCode", this.getFeatureRelatedCode());
            builder.add("Data", this.getData());
            builder.add("UserCode", this.getUserCode());
            builder.add("RevisionDate", (Object)this.getRevisionDate());
            builder.add("Comment", this.getComment());
            builder.add("TopologyPlan", this.getTopologyPlan());
            builder.add("Tags", this.getTags());
            return builder;
        }

        public void fromJson(JsonObject jsonData) {
            this.set(LogsTable.COD_LOG, jsonData.getString("DataCode", null));
            this.set(LogsTable.COD_ENTITY, jsonData.getString("EntityCode", null));
            this.set(LogsTable.COD_REVISION, jsonData.getString("RevisionCode", null));
            this.set(LogsTable.LOG_OPERATION, jsonData.getInt("Operation", -1));
            this.set(LogsTable.LOG_REVNUMBER, jsonData.getInt("RevisionNumber", -1));
            this.set(LogsTable.LOG_EFECTIVEDATE, (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("EfectiveDate", null), null));
            this.set(LogsTable.LOG_FEATURERELATEDCODE, jsonData.getString("FeatureRelatedCode", null));
            this.set(LogsTable.LOG_FEATURE_DATA, jsonData.getString("Data", null));
            this.set(LogsTable.COD_USER, jsonData.getString("UserCode", null));
            this.set(LogsTable.LOG_COMMENT, jsonData.getString("Comment", null));
            this.set(LogsTable.LOG_TOPOLOGYPLAN, jsonData.getInt("TopologyPlan", 0));
            this.set(LogsTable.LOG_TAGS, jsonData.getString("Tags", null));
            this.set(LogsTable.LOG_REVISIONDATE, (Timestamp)DataTypeUtils.toTimestamp((Object)jsonData.getString("RevisionDate", null), null));
        }
    }
}

