/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.lib.workspace.tables;

import java.security.MessageDigest;
import javax.json.JsonObject;
import org.apache.commons.codec.binary.Hex;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DisposableFeatureSetIterable;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlan;
import org.gvsig.vcsgis.lib.VCSGisTopologyPlanImpl;
import org.gvsig.vcsgis.lib.VCSGisUtils;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.lib.workspace.tables.AbstractTable;

public class TopologyplanTable
extends AbstractTable {
    public static final String TABLE_NAME = "VCSGIS_TOPOLOGYPLANS";
    private static final String COD_TOPOLOGYPLAN = "COD_TOPOLOGYPLAN";
    private static final String TOPPLAN_NAME = "TOPP_NAME";
    private static final String TOPPLAN_DESCRIPTION = "TOPP_DESCRIPTION";
    private static final String TOPPLAN_DATA = "TOPP_DATA";

    public static final FeatureType featureType() {
        DataManager dataManager = DALLocator.getDataManager();
        EditableFeatureType ft = dataManager.createFeatureType();
        ft.setLabel("VCSGIS TopologyPlans");
        ft.getTags().set("ID", (Object)TABLE_NAME);
        ft.add(COD_TOPOLOGYPLAN, 8).setTag("dynform.readonly", (Object)true).setSize(60).setIsPrimaryKey(true).setLabel("Code").setDefaultFieldValue((Object)"<%=replace(UUID(),'-','')%>").setReadOnly(false);
        ft.add(TOPPLAN_NAME, 8).setIsIndexed(true).setAllowIndexDuplicateds(true).setSize(50).setLabel("Name");
        ft.add(TOPPLAN_DESCRIPTION, 8).setSize(4096).setLabel("Description");
        ft.add(TOPPLAN_DATA, 8).setSize(4096).setLabel("Serialized topology plan in json.");
        return ft.getNotEditableCopy();
    }

    public TopologyplanTable() {
        super(TABLE_NAME, TopologyplanTable.featureType());
    }

    public VCSGisTopologyPlan getByCode(VCSGisWorkspace workspace, String topologyPlanCode) {
        FeatureStore store = null;
        try {
            store = workspace.getFeatureStore(TABLE_NAME);
            Feature f = store.findFirst("\"COD_TOPOLOGYPLAN\"='" + topologyPlanCode + "'");
            if (f == null) {
                VCSGisTopologyPlan vCSGisTopologyPlan = null;
                return vCSGisTopologyPlan;
            }
            TopologyPlanRow topologyPlanRow = new TopologyPlanRow(workspace, f);
            return topologyPlanRow;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't retrieve topology plan '" + topologyPlanCode + "'.", ex);
        }
        finally {
            DisposeUtils.disposeQuietly((Disposable)store);
        }
    }

    public String getHashCode(VCSGisWorkspace workspace) {
        String string;
        FeatureStore store = null;
        DisposableFeatureSetIterable changes = null;
        try {
            String hash;
            MessageDigest md = MessageDigest.getInstance("MD5");
            store = workspace.getFeatureStore(TABLE_NAME);
            changes = store.getFeatureSet().iterable();
            for (Feature change : changes) {
                VCSGisUtils.updateMessageDigest(md, change, COD_TOPOLOGYPLAN);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_NAME);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_DESCRIPTION);
                VCSGisUtils.updateMessageDigest(md, change, TOPPLAN_DATA);
            }
            string = hash = Hex.encodeHexString((byte[])md.digest());
        }
        catch (Exception ex) {
            try {
                throw new RuntimeException("Can't retrieve hash of topology plans.", ex);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(changes);
                DisposeUtils.disposeQuietly(store);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)changes);
        DisposeUtils.disposeQuietly((Disposable)store);
        return string;
    }

    public static class TopologyPlanRow
    extends AbstractTable.AbstractRow
    implements VCSGisTopologyPlan {
        public TopologyPlanRow(VCSGisWorkspace workspace) {
            super(workspace, TopologyplanTable.TABLE_NAME, TopologyplanTable.COD_TOPOLOGYPLAN);
        }

        public TopologyPlanRow(VCSGisWorkspace workspace, Feature feature) {
            super(workspace, TopologyplanTable.TABLE_NAME, TopologyplanTable.COD_TOPOLOGYPLAN, feature);
        }

        public String getTopologyPlanCode() {
            return this.getString(TopologyplanTable.COD_TOPOLOGYPLAN);
        }

        public String getName() {
            return this.getString(TopologyplanTable.TOPPLAN_NAME);
        }

        public String getDescription() {
            return this.getString(TopologyplanTable.TOPPLAN_DESCRIPTION);
        }

        public String getData() {
            return this.getString(TopologyplanTable.TOPPLAN_DATA);
        }

        public String getLabel() {
            return this.getName();
        }

        public VCSGisTopologyPlan getValue() {
            return this;
        }

        public void copyFrom(VCSGisTopologyPlan other) {
            this.set(TopologyplanTable.COD_TOPOLOGYPLAN, other.getTopologyPlanCode());
            this.set(TopologyplanTable.TOPPLAN_NAME, other.getName());
            this.set(TopologyplanTable.TOPPLAN_DESCRIPTION, other.getDescription());
            this.set(TopologyplanTable.TOPPLAN_DATA, other.getData());
        }

        public JsonObject toJson() {
            return this.toJsonBuilder().build();
        }

        public JsonObjectBuilder toJsonBuilder() {
            return VCSGisTopologyPlanImpl.toJsonBuilder(this);
        }

        public String toString() {
            return VCSGisTopologyPlanImpl.toString(this);
        }

        public String getHashCode() {
            return VCSGisTopologyPlanImpl.getHashCode(this);
        }
    }
}

