/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.simpleimageviewer.app.mainplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.NumberFormat;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.imageviewer.ImageViewer;
import org.gvsig.simpleimageviewer.app.mainplugin.ImageViewerView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.jdesktop.swingx.JXImageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageViewerImpl
extends ImageViewerView
implements ImageViewer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageViewerImpl.class);
    private static final int ROTATE_RIGHT = 0;
    private static final int ROTATE_LEFT = 1;
    private JXImageView imageView;
    private boolean fit = true;
    private final ChangeListenerHelper changeListener = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
    private SimpleImage currentImage;

    public ImageViewerImpl() {
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.imageView = new JXImageView();
        this.ImageContainer.setLayout(new BorderLayout());
        this.ImageContainer.add((Component)this.imageView, "Center");
        toolsSwingManager.translate((AbstractButton)this.btnZoomIn);
        toolsSwingManager.translate((AbstractButton)this.btnZoomOut);
        toolsSwingManager.translate((AbstractButton)this.btnRotateLeft);
        toolsSwingManager.translate((AbstractButton)this.btnRotateRight);
        toolsSwingManager.translate((AbstractButton)this.btnFit);
        toolsSwingManager.translate((AbstractButton)this.btnZoom1_1);
        this.btnRotateLeft.addActionListener(e -> {
            this.fit = false;
            this.rotate(1);
        });
        this.btnRotateRight.addActionListener(e -> {
            this.fit = false;
            this.rotate(0);
        });
        this.btnFit.addActionListener(e -> {
            this.fit = true;
            this.adjustScale();
        });
        this.btnZoom1_1.addActionListener(e -> {
            this.fit = false;
            this.imageView.setScale(1.0);
        });
        this.btnZoomIn.addActionListener(e -> {
            this.fit = false;
            this.imageView.setScale(this.imageView.getScale() * 2.0);
        });
        this.btnZoomOut.addActionListener(e -> {
            this.fit = false;
            this.imageView.setScale(this.imageView.getScale() * 0.5);
        });
        this.imageView.addPropertyChangeListener("scale", evt -> this.onChangeScale());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                ImageViewerImpl.this.adjustScale();
            }
        });
        this.gridCustomActions.removeAll();
        this.gridCustomActions.setLayout(new FlowLayout(4, 4, 0));
    }

    @Override
    public ImageIcon loadImage(String imageName) {
        String iconName = FilenameUtils.getBaseName((String)imageName);
        IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
        IconTheme theme = iconThemeManager.getCurrent();
        if (theme.exists(iconName)) {
            return theme.get(iconName);
        }
        return super.loadImage(imageName);
    }

    private void rotate(int mode) {
        if (this.currentImage == null) {
            return;
        }
        double scale = this.imageView.getScale();
        switch (mode) {
            case 0: {
                this.currentImage = this.currentImage.rotate(90);
                break;
            }
            default: {
                this.currentImage = this.currentImage.rotate(-90);
            }
        }
        this.imageView.setImage((Image)this.currentImage.getBufferedImage());
        this.imageView.setScale(scale);
        this.changeListener.fireEvent();
    }

    private void onChangeScale() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(3);
        nf.setMinimumFractionDigits(3);
        String scale = nf.format(this.imageView.getScale());
        this.lblMessages.setText(i18n.getTranslation("_Scale_{0}", new String[]{scale}));
    }

    private void adjustScale() {
        if (!this.fit) {
            return;
        }
        double sx = 0.0;
        double sy = 0.0;
        try {
            double w = this.getWidth();
            double h = this.getHeight();
            sx = (w <= 0.0 ? this.getPreferredSize().getWidth() : w) / (double)this.imageView.getImage().getWidth(null);
            sy = (h <= 0.0 ? this.getPreferredSize().getHeight() : h) / (double)this.imageView.getImage().getHeight(null);
            if (sx > sy) {
                this.imageView.setScale(sy);
            } else {
                this.imageView.setScale(sx);
            }
        }
        catch (Exception ex) {
            LOGGER.trace("Error setting scale (sx=" + sx + ", sy=" + sy + ").");
        }
    }

    public void clean() {
        this.currentImage = null;
        this.imageView.setImage((Image)null);
        this.changeListener.fireEvent();
    }

    public void setImage(Object source) {
        if (source == null) {
            this.clean();
            return;
        }
        if (source instanceof SimpleImage) {
            this.setImage((SimpleImage)source);
            return;
        }
        SimpleImage img = ToolsSwingLocator.getToolsSwingManager().createSimpleImage(source);
        this.setImage(img);
    }

    private void setImage(SimpleImage image) {
        if (image == null) {
            this.clean();
            return;
        }
        this.currentImage = image;
        this.imageView.setImage((Image)this.currentImage.getBufferedImage());
        this.changeListener.fireEvent();
        this.onChangeScale();
        SwingUtilities.invokeLater(this::adjustScale);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addAction(Action action) {
        JComponent button = this.createButton(action);
        this.gridCustomActions.add(button);
    }

    private JComponent createButton(Action action) {
        JButton button = new JButton(action);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setBorderPainted(false);
        button.setFocusPainted(false);
        button.setContentAreaFilled(false);
        button.setCursor(new Cursor(12));
        return button;
    }

    public SimpleImage getImage() {
        return this.currentImage;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListener.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListener.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListener.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListener.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListener.hasChangeListeners();
    }
}

