/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.evaluator.sqljep;

import java.math.BigDecimal;
import java.util.Map;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.evaluator.EvaluatorFieldsInfo;
import org.gvsig.tools.evaluator.EvaluatorParseException;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.RowJEP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLJEPEvaluator
extends RowJEP
implements EvaluatorWithDescriptions,
Persistent {
    private static final Logger logger = LoggerFactory.getLogger(SQLJEPEvaluator.class);
    public static final String TODATE_FUNCTION_NAME = "to_timestamp";
    private EvaluatorData data = null;
    private boolean not_parsed = true;
    private static EvaluatorWithDescriptions.Description[] available_operators;
    private static EvaluatorWithDescriptions.Description[] available_functions;

    public SQLJEPEvaluator(String expresion) {
        super(expresion);
    }

    public String getName() {
        return "SQLJEP(" + this.expression + ")";
    }

    public String getSQL() {
        return this.expression;
    }

    public String getDescription() {
        return "SQLJEP-based evaluator";
    }

    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        this.data = data;
        Comparable value = null;
        try {
            if (this.not_parsed) {
                this.parseExpression();
                this.not_parsed = false;
            }
        }
        catch (ParseException e) {
            throw new EvaluatorParseException((Throwable)e);
        }
        try {
            value = this.getValue();
        }
        catch (Exception e) {
            throw new EvaluatorException((Throwable)e);
        }
        this.data = null;
        return value;
    }

    public Map.Entry getVariable(String name) throws ParseException {
        return new MyEntry(name);
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
        ps.set("expression", this.expression);
    }

    public void loadFromState(PersistentState ps) throws PersistenceException {
        this.clear();
        this.expression = ps.getString("expression");
    }

    public EvaluatorFieldsInfo getFieldsInfo() {
        return null;
    }

    public EvaluatorWithDescriptions.Description[] getAvailableOperators() {
        if (available_operators == null) {
            available_operators = new EvaluatorWithDescriptions.Description[]{new DefaultDescription("+", "Returns the sum (addition) of the left operand and the right operand.", " + ", 1), new DefaultDescription("-", "Returns the difference (subtraction) of the left operand minus the right operand. It can be used as unary operator to change the sign of the right operand.", " - ", 1), new DefaultDescription("*", "Returns the product (multiplication) of the left operand by the right operand.", " * ", 1), new DefaultDescription("/", "Returns the division of the left operand by the right operand.", " / ", 1), new DefaultDescription(">", "Returns TRUE if the left operand is greater than the right operand; FALSE otherwise.", " > ", 15), new DefaultDescription("<", "Returns TRUE if the left operand is smaller than the right operand; FALSE otherwise.", " < ", 15), new DefaultDescription(">=", "Returns TRUE if the left operand is greater or equal to the right operand; FALSE otherwise.", " >= ", 15), new DefaultDescription("<=", "Returns TRUE if the left operand is less or equal to the right operand; FALSE otherwise.", " <= ", 15), new DefaultDescription("=", "Returns TRUE if the left operand equals the right operand; FALSE otherwise.", " = ", 15), new DefaultDescription("!=", "Returns TRUE if the left operand is not equal to the right operand; FALSE otherwise.", " != ", 15), new DefaultDescription("And", "Returns TRUE if both operands are TRUE; FALSE otherwise.", " and <Right_value>", 8), new DefaultDescription("Or", "Returns TRUE if the left operand is TRUE or the right operand is TRUE; FALSE otherwise.", " or ", 8), new DefaultDescription("Not", "Returns the logical inverse of the right operand: TRUE if the right operand is FALSE; FALSE otherwise.", "not ", 8), new DefaultDescription("In", "Returns TRUE if the left operand equals one of the comma-separated values; FALSE otherwise.", " in ( <Comma_separated_values> )", 15), new DefaultDescription("Between", "Returns TRUE if the left operand is greater or equal than the first right operand and less or equal than the second right operand; FALSE otherwise.", " between <Right_value_1> and <Right_value_2>", 15), new DefaultDescription("Like", "Returns TRUE if the left operand matches the pattern expressed by the right operand; FALSE otherwise. Use '%' as wildcard.", " like <Right_value>", 2), new DefaultDescription("Is Null", "Returns TRUE if the left operand has NULL value; FALSE otherwise.", " is null", 15), new DefaultDescription("Is Not Null", "Returns TRUE if the left operand does not have NULL value; FALSE otherwise.", " is not null", 15)};
        }
        return available_operators;
    }

    public EvaluatorWithDescriptions.Description[] getAvailableFunctions() {
        if (available_functions == null) {
            available_functions = new EvaluatorWithDescriptions.Description[]{new DefaultDescription("Equals", "Returns TRUE if the two input values are equal; FALSE otherwise.", "equals( <Value_1> , <Value_2> )", 23), new DefaultDescription("GeomFromText", "Returns the geometry object equivalent to the input WKT string (single quotes).", "GeomFromText( <Geometry_in_WKT> )", 18), new DefaultDescription("Intersects", "Returns TRUE if the two input geometries intersect; FALSE otherwise.", "intersects( <Geometry_1> , <Geometry_2> )", 16), new DefaultDescription("Overlaps", "Returns TRUE if the two input geometries overlap; FALSE otherwise. Geometries overlap when they have some but not all points in common, they have the same dimension, and the intersection of the interiors of the two geometries has the same dimension as the geometries themselves.", "overlaps( <Geometry_1> , <Geometry_2> )", 16), new DefaultDescription("Boundary", "Returns a geometry which is the bounding box of the input geometry.", "boundary( <Geometry> )", 16), new DefaultDescription("To_timestamp", "Converts the input value to the timestamp type.", "to_timestamp( <Value> )", 4), new DefaultDescription("Abs", "Returns the absolute value of the input numeric value.", "abs( <Numeric_value> )", 1), new DefaultDescription("Power", "Takes two numeric inputs and returns numeric result as first argument raised to second argument.", "power( <Base> , <Exponent> )", 1), new DefaultDescription("Mod", "Returns the remainder of the first argument divided by the second argument.", "mod( <Numeric_value_1> , <Numeric_value_2> )", 1), new DefaultDescription("Substr", "Returns a substring of the first argument, starting at the character indicated by the second argument. The optional third argument indicates the length of the result.", "substr( <String> , <Start_index> [ , <Length> ] )", 2), new DefaultDescription("Sign", "Returns 1 for positive input values, -1 for negative values and 0 when input is 0.", "sign( <Numeric_value> )", 1), new DefaultDescription("Ceil", "Returns the smallest whole number greater than or equal to the input numeric value.", "ceil( <Numeric_value> )", 1), new DefaultDescription("Floor", "Returns the largest whole number equal to or less than the input numeric value.", "floor( <Numeric_value> )", 1), new DefaultDescription("Trunc", "Returns the first argument truncated to as many decimal places as indicated by the second optional argument (defaults to zero).", "trunc( <Numeric_value> [ , <Integer_value> ] )", 1), new DefaultDescription("Round", "Returns the first argument rounded to as many places to the right of the decimal point as indicated by the second optional argument (defaults to zero).", "round( <Numeric_value> [ , <Integer_value> ] )", 1), new DefaultDescription("Length", "Returns the length (number of characters) of the input string.", "length( <String> )", 2), new DefaultDescription("Concat", "Returns the concatenation of the two input strings.", "concat( <String_1> , <String_2> )", 2), new DefaultDescription("Instr", "Searches for a string using some parameters (similar to same function in Oracle).", "instr( <String_1> , <String_2> , <Int_1> , <Int_2> )", 2), new DefaultDescription("Trim", "Removes all leading and trailing spaces from the input string.", "trim( <String> )", 2), new DefaultDescription("Rtrim", "Removes all trailing (right-hand) spaces from the input string.", "Rtrim( <String> )", 2), new DefaultDescription("Ltrim", "Removes all leading (left-hand) spaces from the input string.", "Ltrim( <String> )", 2), new DefaultDescription("Rpad", "Appends <String_2> to <String_1> as many times as needed to reach length <L>. <String_2> defaults to a white space.", "rpad( <String_1> , <L> [ , <String_2> ] )", 2), new DefaultDescription("Lpad", "Prepends <String_2> to <String_1> as many times as needed to reach length <L>. <String_2> defaults to a white space.", "lpad( <String_1> , <L> [ , <String_2> ] )", 2), new DefaultDescription("Upper", "Returns the input string in upper case.", "upper( <String> )", 2), new DefaultDescription("Lower", "Returns the input string in lower case.", "lower( <String> )", 2), new DefaultDescription("Translate", "Replaces characters following the order of the second and third parameters.", "translate( <String_1> , <String_2> , <String_3> )", 2), new DefaultDescription("Replace", "Replaces in <String_1> the occurrences of <String_2> with <String_3>.", "replace( <String_1> , <String_2> , <String_3> )", 2), new DefaultDescription("Initcap", "Sets the first character in each word to uppercase and the rest to lowercase.", "initcap( <String> )", 2), new DefaultDescription("Value", "Returns the first non-null value from the input values. Can be used to avoid null values in a field.", "value( <Value_1> , <Value_2> ... )", 15), new DefaultDescription("Decode", "This function works like a IF-THEN-ELSE block.", "decode( <Expression> , <Search> , <Result> ... )", 15), new DefaultDescription("To_char", "Converts the input value to string.", "to_char( <Value> )", 15), new DefaultDescription("To_number", "Converts the input string to a number.", "to_number( <String> )", 3), new DefaultDescription("Imatch", "Returns a string representing the phonetic value of the input string. Similar to Soundex function in Oracle.", "imatch( <String> )", 2), new DefaultDescription("Case", "This function works like a CASE-WHEN block.", "case( <Expression> ... )", 8), new DefaultDescription("Index", "Returns the position of a substring in a string.", "index( <String> , <Substring> )", 2), new DefaultDescription("Num", "Returns the numeric value of the input string.", "num( <String> )", 8), new DefaultDescription("Chr", "Converts the input value to string.", "chr( <Value> )", 15), new DefaultDescription("Months_between", "Returns the number of months (as a float-point value) between <Earliest_date> and <Latest_date>.", "months_between( <Latest_date> , <Earliest_date>  )", 4), new DefaultDescription("Add_months", "Adds a number of months to the input date.", "add_months( <Input_date> , <Number_of_months_integer>)", 4), new DefaultDescription("Last_day", "Returns the date corresponding to the last day of the month of the input date.", "last_day( <Input_date> )", 4), new DefaultDescription("Next_day", "Returns the date of the first weekday named by the string <Day_of_the_week> that is later than <Input_date>.", "next_day( <Input_date> , <Day_of_the_week> )", 4), new DefaultDescription("To_date", "Converts the input string to a date following the optional format.", "to_date( <Input_string> [ , <Format> ] )", 4), new DefaultDescription("Adddate", "Returns a date which is <Number_of_days> days after the input date.", "adddate( <Input_date> , <Number_of_days> )", 4), new DefaultDescription("Subdate", "Returns a date which is <Number_of_days> days before the input date.", "subdate( <Input_date> , <Number_of_days> )", 4), new DefaultDescription("Addtime", "Adds the second input time <Add_time> to the first input time <Input_date>.", "addtime( <Input_time> , <Add_time> )", 4), new DefaultDescription("Subtime", "Subtracts the second input time <Sub_time> from the first input time <Input_date>.", "subtime( <Input_time> , <Sub_time> )", 4), new DefaultDescription("Year", "Returns a numeric value representing the year of the input date.", "year( <Input_date> )", 4), new DefaultDescription("Month", "Returns a numeric value representing the month of the input date.", "month( <Input_date> )", 4), new DefaultDescription("Day", "Returns a numeric value representing the day of the input date.", "day( <Input_date> )", 4), new DefaultDescription("Dayofmonth", "Returns a numeric value between 1 and 31 corresponding to the day of the month of the input date.", "dayofmonth( <Input_date> )", 4), new DefaultDescription("Hour", "Returns a numeric value representing the number of hours of the input time value.", "hour( <Time_value> )", 4), new DefaultDescription("Minute", "Returns a numeric value representing the number of minutes of the input time value.", "minute( <Time_value> )", 4), new DefaultDescription("Second", "Returns a numeric value representing the number of seconds of the input time value.", "second( <Time_value> )", 4), new DefaultDescription("Microsecond", "Returns the number of microseconds of the input timestamp value", "microseconds( <Timestamp_value> )", 4), new DefaultDescription("Datediff", "Returns the number of days between the two input dates.", "datediff( <Date_1> , <Date_2> )", 4), new DefaultDescription("Dayofweek", "Returns a numeric value between 1 (Monday) and 7 (Sunday) corresponding to the day of the week of the input date.", "dayofweek( <Input_date> )", 4), new DefaultDescription("Weekofyear", "Returns a numeric value between 1 and 53 corresponding to the number of the week of the input date.", "weekofyear( <Input_date> )", 4), new DefaultDescription("Dayname", "Returns the name of the day corresponding to the input date ('Sunday', 'Monday', etc).", "dayname( <Input_date> )", 4), new DefaultDescription("Monthname", "Returns the name of the month corresponding to the input date ('January', 'February', etc).", "monthname( <Input_date> )", 4), new DefaultDescription("Makedate", "Returns a date corresponding to the day denoted by <Day_integer> (between 1 and 366) of the year <Year_integer>.", "makedate( <Year_integer> , <Day_integer> )", 4), new DefaultDescription("Maketime", "Creates a time value with the input number of hours, minutes and seconds.", "maketime( <Hours> , <Minutes> , <Seconds> )", 4)};
        }
        return available_functions;
    }

    private class DefaultDescription
    implements EvaluatorWithDescriptions.Description {
        private String name;
        private String desc;
        private String template;
        private int categories;

        public DefaultDescription(String name, String desc, String template, int datatype_categories) {
            this.name = name;
            this.desc = desc;
            this.template = template;
            this.categories = datatype_categories;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.desc;
        }

        public String getTemplate() {
            return this.template;
        }

        public int getDataTypeCategories() {
            return this.categories;
        }
    }

    private class MyEntry
    implements Map.Entry {
        private String key;

        public MyEntry(String key) {
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            Object resp = null;
            if (SQLJEPEvaluator.this.data.hasDataValue(this.key)) {
                resp = SQLJEPEvaluator.this.data.getDataValue(this.key);
                resp = this.fixDecimal(resp);
                return resp;
            }
            resp = SQLJEPEvaluator.this.data.getDataValue(this.key);
            resp = this.fixDecimal(resp);
            return resp;
        }

        private Object fixDecimal(Object obj) {
            if (obj instanceof Double) {
                Double dou = (Double)obj;
                String doustr = Double.toString(dou);
                return new BigDecimal(doustr);
            }
            if (obj instanceof Float) {
                Float flo = (Float)obj;
                String flostr = Float.toString(flo.floatValue());
                return new BigDecimal(flostr);
            }
            return obj;
        }

        public Object setValue(Object arg0) {
            return null;
        }
    }
}

