/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.evaluator.sqljep.function;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.tools.locator.LocatorException;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeomFromText
extends PostfixCommand {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(GeomFromText.class);
    private static Object lock = new Object();
    public static final String NAME = "GeomFromText";
    private static String lastTextGeometry = "";
    private static String lastSRS = "";
    private static Geometry lastGeometry = null;

    public final int getNumberOfParameters() {
        return 2;
    }

    public void evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
        node.childrenAccept(runtime.ev, null);
        String srs = (String)runtime.stack.pop();
        String text = (String)runtime.stack.pop();
        runtime.stack.push(GeomFromText.geometryFromText(text, srs));
    }

    private static Geometry geometryFromText(String text, String srs) throws ParseException {
        if (!lastTextGeometry.equals(text) || !lastSRS.equals(srs)) {
            try {
                lastGeometry = geomManager.createFrom(text, srs);
            }
            catch (CreateGeometryException e) {
                throw new ParseException(NAME, (Throwable)e);
            }
            catch (LocatorException e) {
                throw new ParseException(NAME, (Throwable)e);
            }
            catch (GeometryException e) {
                throw new ParseException(NAME, (Throwable)e);
            }
            lastTextGeometry = text;
            lastSRS = srs;
        }
        return lastGeometry;
    }
}

