/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.evaluator.sqljep.function;

import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.primitive.OrientablePrimitive;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.CoercionException;
import org.medfoster.sqljep.ASTFunNode;
import org.medfoster.sqljep.BaseJEP;
import org.medfoster.sqljep.JepRuntime;
import org.medfoster.sqljep.ParseException;
import org.medfoster.sqljep.function.PostfixCommand;
import org.medfoster.sqljep.function.PostfixCommandI;

public class OpenGISFunctions {
    public static BaseFunction[] functions = new BaseFunction[]{new ST_Distance(), new ST_Disjoint(), new ST_Touches(), new ST_Crosses(), new ST_Within(), new ST_Overlaps(), new ST_Contains(), new ST_Covers(), new ST_CoveredBy(), new ST_Intersects(), new ST_Centroid(), new ST_Area(), new ST_Buffer(), new ST_ConvexHull(), new ST_Intersection(), new ST_Difference(), new ST_Union(), new ST_AsText(), new ST_Dimension(), new ST_Envelope(), new ST_IsSimple(), new ST_NumGeometries(), new ST_GeometryN(), new ST_NumPoints(), new ST_PointN(), new ST_StartPoint(), new ST_EndPoint(), new ST_X(), new ST_Y(), new ST_Z(), new ST_GeomFromText(), new ST_isValid()};

    public static void registerFunctions() {
        for (int i = 0; i < functions.length; ++i) {
            BaseFunction f = functions[i];
            BaseJEP.addFunction((String)f.getName(), (PostfixCommandI)f);
        }
    }

    public static class ST_isValid
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return Boolean.valueOf(geom1.isValid());
        }
    }

    public static class ST_GeomFromText
    extends Function_string {
        @Override
        public Comparable evaluate(String value) throws Exception {
            GeometryManager manager = GeometryLocator.getGeometryManager();
            return manager.createFrom(value);
        }
    }

    public static class ST_Z
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            Point p = (Point)geom1;
            if (p.getGeometryType().getSubType() == 1) {
                return Double.valueOf(p.getCoordinateAt(2));
            }
            return null;
        }
    }

    public static class ST_Y
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return Double.valueOf(((Point)geom1).getY());
        }
    }

    public static class ST_X
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return Double.valueOf(((Point)geom1).getX());
        }
    }

    public static class ST_EndPoint
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            if (geom1 instanceof OrientablePrimitive) {
                int n = ((OrientablePrimitive)geom1).getNumVertices();
                return ((OrientablePrimitive)geom1).getVertex(n - 1);
            }
            return null;
        }
    }

    public static class ST_StartPoint
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            if (geom1 instanceof OrientablePrimitive) {
                return ((OrientablePrimitive)geom1).getVertex(0);
            }
            return null;
        }
    }

    public static class ST_PointN
    extends Function_geom1_int {
        @Override
        public Comparable evaluate(Geometry geom1, int value) throws Exception {
            if (geom1 instanceof OrientablePrimitive) {
                return ((OrientablePrimitive)geom1).getVertex(value);
            }
            return null;
        }
    }

    public static class ST_NumPoints
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            if (geom1 instanceof OrientablePrimitive) {
                int n = ((OrientablePrimitive)geom1).getNumVertices();
                return Integer.valueOf(n);
            }
            return null;
        }
    }

    public static class ST_GeometryN
    extends Function_geom1_int {
        @Override
        public Comparable evaluate(Geometry geom1, int value) throws Exception {
            if (geom1 instanceof Aggregate) {
                return ((Aggregate)geom1).getPrimitiveAt(value);
            }
            return null;
        }
    }

    public static class ST_NumGeometries
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            if (geom1 instanceof Aggregate) {
                int n = ((Aggregate)geom1).getPrimitivesNumber();
                return Integer.valueOf(n);
            }
            return null;
        }
    }

    public static class ST_IsSimple
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return Boolean.valueOf(geom1.isSimple());
        }
    }

    public static class ST_Envelope
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return geom1.getEnvelope().getGeometry();
        }
    }

    public static class ST_Dimension
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            GeometryType type = geom1.getGeometryType();
            if (type.isSubTypeOf(1) || type.isSubTypeOf(7)) {
                return Integer.valueOf(0);
            }
            if (type.isSubTypeOf(2) || type.isSubTypeOf(8)) {
                return Integer.valueOf(1);
            }
            if (type.isSubTypeOf(3) || type.isSubTypeOf(9)) {
                return Integer.valueOf(2);
            }
            if (type.isSubTypeOf(4)) {
                return Integer.valueOf(3);
            }
            return Integer.valueOf(-1);
        }
    }

    public static class ST_AsText
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return geom1.convertToWKT();
        }
    }

    public static class ST_Union
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return geom1.union(geom2);
        }
    }

    public static class ST_Difference
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return geom1.difference(geom2);
        }
    }

    public static class ST_Intersection
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return geom1.intersection(geom2);
        }
    }

    public static class ST_ConvexHull
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return geom1.convexHull();
        }
    }

    public static class ST_Buffer
    extends Function_geom1_double {
        @Override
        public Comparable evaluate(Geometry geom1, double value) throws Exception {
            return geom1.buffer(value);
        }
    }

    public static class ST_Area
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return Double.valueOf(geom1.area());
        }
    }

    public static class ST_Centroid
    extends Function_geom1 {
        @Override
        public Comparable evaluate(Geometry geom1) throws Exception {
            return geom1.centroid();
        }
    }

    public static class ST_Intersects
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.intersects(geom2));
        }
    }

    public static class ST_CoveredBy
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.coveredBy(geom2));
        }
    }

    public static class ST_Covers
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.covers(geom2));
        }
    }

    public static class ST_Contains
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.contains(geom2));
        }
    }

    public static class ST_Overlaps
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.overlaps(geom2));
        }
    }

    public static class ST_Within
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.within(geom2));
        }
    }

    public static class ST_Crosses
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.crosses(geom2));
        }
    }

    public static class ST_Touches
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.touches(geom2));
        }
    }

    public static class ST_Disjoint
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Boolean.valueOf(geom1.disjoint(geom2));
        }
    }

    public static class ST_Distance
    extends Function_geom1_geom2 {
        @Override
        public Comparable evaluate(Geometry geom1, Geometry geom2) throws Exception {
            return Double.valueOf(geom1.distance(geom2));
        }
    }

    public static abstract class Function_string
    extends BaseFunction {
        public final int getNumberOfParameters() {
            return 1;
        }

        @Override
        public Comparable evaluate(JepRuntime runtime) throws Exception {
            String value = this.pop_string(runtime);
            return this.evaluate(value);
        }

        public abstract Comparable evaluate(String var1) throws Exception;
    }

    public static abstract class Function_geom1_int
    extends BaseFunction {
        public final int getNumberOfParameters() {
            return 2;
        }

        @Override
        public Comparable evaluate(JepRuntime runtime) throws Exception {
            Geometry geom1 = this.pop_geometry(runtime);
            int value = this.pop_int(runtime);
            return this.evaluate(geom1, value);
        }

        public abstract Comparable evaluate(Geometry var1, int var2) throws Exception;
    }

    public static abstract class Function_geom1_double
    extends BaseFunction {
        public final int getNumberOfParameters() {
            return 2;
        }

        @Override
        public Comparable evaluate(JepRuntime runtime) throws Exception {
            Geometry geom1 = this.pop_geometry(runtime);
            double value = this.pop_double(runtime);
            return this.evaluate(geom1, value);
        }

        public abstract Comparable evaluate(Geometry var1, double var2) throws Exception;
    }

    public static abstract class Function_geom1
    extends BaseFunction {
        public final int getNumberOfParameters() {
            return 1;
        }

        @Override
        public Comparable evaluate(JepRuntime runtime) throws Exception {
            Geometry geom1 = this.pop_geometry(runtime);
            return this.evaluate(geom1);
        }

        public abstract Comparable evaluate(Geometry var1) throws Exception;
    }

    public static abstract class Function_geom1_geom2
    extends BaseFunction {
        public final int getNumberOfParameters() {
            return 2;
        }

        @Override
        public Comparable evaluate(JepRuntime runtime) throws Exception {
            Geometry geom1 = this.pop_geometry(runtime);
            Geometry geom2 = this.pop_geometry(runtime);
            return this.evaluate(geom1, geom2);
        }

        public abstract Comparable evaluate(Geometry var1, Geometry var2) throws Exception;
    }

    public static abstract class BaseFunction
    extends PostfixCommand {
        public String getName() {
            String name = ((Object)((Object)this)).getClass().getName();
            int index = name.lastIndexOf(".");
            if (index < 1) {
                return name;
            }
            return name.substring(index + 1);
        }

        public Geometry pop_geometry(JepRuntime runtime) throws ParseException {
            return (Geometry)runtime.stack.pop();
        }

        public double pop_double(JepRuntime runtime) throws ParseException {
            Double value = null;
            try {
                value = (Double)ToolsLocator.getDataTypesManager().coerce(7, runtime.stack.pop());
            }
            catch (CoercionException ex) {
                throw new ParseException(this.getName(), (Throwable)ex);
            }
            return value;
        }

        public int pop_int(JepRuntime runtime) throws ParseException {
            Integer value = null;
            try {
                value = (Integer)ToolsLocator.getDataTypesManager().coerce(4, runtime.stack.pop());
            }
            catch (CoercionException ex) {
                throw new ParseException(this.getName(), (Throwable)ex);
            }
            return value;
        }

        public String pop_string(JepRuntime runtime) throws ParseException {
            String value = null;
            try {
                value = (String)ToolsLocator.getDataTypesManager().coerce(8, runtime.stack.pop());
            }
            catch (CoercionException ex) {
                throw new ParseException(this.getName(), (Throwable)ex);
            }
            return value;
        }

        public void evaluate(ASTFunNode node, JepRuntime runtime) throws ParseException {
            try {
                Comparable value = this.evaluate(runtime);
                runtime.stack.push(value);
            }
            catch (Exception ex) {
                throw new ParseException(this.getName(), (Throwable)ex);
            }
        }

        public abstract Comparable evaluate(JepRuntime var1) throws Exception;
    }
}

