/*
 * Decompiled with CFR 0.152.
 */
package org.cresques.ui.cts;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.cresques.Messages;
import org.cresques.cts.IProjection;
import org.cresques.ui.LoadableComboBox;
import org.cresques.ui.cts.CSSelectionModel;

public class CSSelectionPanel
extends JPanel {
    private static final long serialVersionUID = -3370601314380922368L;
    private LoadableComboBox datumComboBox = null;
    private LoadableComboBox projComboBox = null;
    private LoadableComboBox huseComboBox = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private String tit;
    private CSSelectionModel model;

    public CSSelectionPanel(String tit) {
        if (tit == null && (tit = Messages.getText((String)"reference_system")) == null) {
            tit = "Reference System";
        }
        this.tit = tit;
        this.setModel(new CSSelectionModel());
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(2, 5, 2, 5);
        c.gridy = -1;
        this.setBorder(BorderFactory.createCompoundBorder(null, BorderFactory.createTitledBorder(null, Messages.getText((String)"reference_system"), 0, 0, null, null)));
        this.jLabel = new JLabel(Messages.getText((String)"datum") + ":");
        this.addRow(c, this.jLabel, this.getDatumComboBox());
        this.jLabel1 = new JLabel(Messages.getText((String)"projection") + ":");
        this.addRow(c, this.jLabel1, this.getProjComboBox());
        this.jLabel2 = new JLabel(Messages.getText((String)"zone") + ":");
        this.addRow(c, this.jLabel2, this.getHuseComboBox());
        this.setHuseComboBoxEnabled(false);
    }

    public void setModel(CSSelectionModel model) {
        this.model = model;
        this.getHuseComboBox().loadData(model.getZoneList());
        this.getDatumComboBox().loadData(model.getDatumList());
        this.getProjComboBox().loadData(model.getProjectionList());
    }

    private void setHuseComboBoxEnabled(boolean enabled) {
        if (this.jLabel2 != null) {
            this.jLabel2.setEnabled(enabled);
        }
        this.getHuseComboBox().setEnabled(enabled);
    }

    private void setDatumComboBoxEnabled(boolean enabled) {
        if (this.jLabel != null) {
            this.jLabel.setEnabled(enabled);
        }
        this.getDatumComboBox().setEnabled(enabled);
    }

    public void setProjection(IProjection proj) {
        this.model.setProjection(proj);
        this.setDatumComboBoxEnabled(true);
        this.getDatumComboBox().setSelectedIndex(this.model.getSelectedDatum());
        this.getProjComboBox().removeAllItems();
        this.getProjComboBox().loadData(this.model.getProjectionList());
        this.model.setProjection(proj);
        this.getProjComboBox().setSelectedIndex(this.model.getSelectedProj());
        this.model.setProjection(proj);
        if (this.model.getSelectedZone() >= 0) {
            this.setHuseComboBoxEnabled(true);
            this.getHuseComboBox().removeAllItems();
            this.getHuseComboBox().loadData(this.model.getZoneList());
            this.model.setProjection(proj);
            this.getHuseComboBox().setSelectedIndex(this.model.getSelectedZone());
        } else {
            this.setHuseComboBoxEnabled(false);
            this.getHuseComboBox().setSelectedIndex(0);
        }
    }

    private LoadableComboBox getDatumComboBox() {
        if (this.datumComboBox == null) {
            this.datumComboBox = new LoadableComboBox();
            this.datumComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CSSelectionPanel.this.model.setSelectedDatum(e.getItem());
                    CSSelectionPanel.this.getProjComboBox().removeAllItems();
                    CSSelectionPanel.this.getProjComboBox().loadData(CSSelectionPanel.this.model.getProjectionList());
                }
            });
        }
        return this.datumComboBox;
    }

    private LoadableComboBox getProjComboBox() {
        if (this.projComboBox == null) {
            this.projComboBox = new LoadableComboBox();
            this.projComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CSSelectionPanel.this.model.setSelectedProj(e.getItem());
                    if (CSSelectionPanel.this.model.getSelectedProjType() == CSSelectionModel.TRANSVERSAL) {
                        CSSelectionPanel.this.setHuseComboBoxEnabled(true);
                        CSSelectionPanel.this.getHuseComboBox().removeAllItems();
                        CSSelectionPanel.this.getHuseComboBox().loadData(CSSelectionPanel.this.model.getZoneList());
                    } else {
                        CSSelectionPanel.this.setHuseComboBoxEnabled(false);
                    }
                }
            });
        }
        return this.projComboBox;
    }

    private LoadableComboBox getHuseComboBox() {
        if (this.huseComboBox == null) {
            this.huseComboBox = new LoadableComboBox();
            this.huseComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    CSSelectionPanel.this.model.setSelectedZone(e.getItem());
                }
            });
        }
        return this.huseComboBox;
    }

    public IProjection getProjection() {
        return this.model.getProjection();
    }

    private void addRow(GridBagConstraints c, JComponent label, JComponent text) {
        c.anchor = 17;
        c.weightx = 0.0;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)label, c);
        c.fill = 2;
        c.weightx = 1.0;
        c.gridx = 1;
        this.add((Component)text, c);
    }
}

