/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.gui.panels;

import java.lang.reflect.InvocationTargetException;
import org.cresques.cts.IProjection;
import org.gvsig.app.gui.panels.CRSSelectPanel;
import org.gvsig.app.gui.panels.crs.ICrsUIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CRSSelectPanelFactory {
    private static Logger logger = LoggerFactory.getLogger(CRSSelectPanelFactory.class);
    private static Class panelClass = null;
    private static Class uiFactory = null;

    public static void registerPanelClass(Class panelClass) {
        CRSSelectPanelFactory.panelClass = panelClass;
    }

    public static void registerUIFactory(Class uiFactory) {
        CRSSelectPanelFactory.uiFactory = uiFactory;
    }

    public static CRSSelectPanel getPanel(IProjection proj) {
        CRSSelectPanel panel = null;
        Class[] args = new Class[]{IProjection.class};
        Object[] params = new Object[]{proj};
        try {
            panel = (CRSSelectPanel)panelClass.getConstructor(args).newInstance(params);
        }
        catch (IllegalArgumentException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("Error creating CRS selection button", (Throwable)e);
        }
        return panel;
    }

    public static ICrsUIFactory getUIFactory() {
        ICrsUIFactory factory = null;
        try {
            factory = (ICrsUIFactory)uiFactory.newInstance();
        }
        catch (InstantiationException e) {
            logger.error("Error creating CRS UI factory. Switching to default factory", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("Error creating CRS UI factory. Switching to default factory", (Throwable)e);
        }
        return factory;
    }
}

