/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lizardtech.io;

import es.gva.cit.jmrsid.MrSIDException;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.tile.FileTileServer;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.raster.lizardtech.io.LizardTechDataParameters;
import org.gvsig.raster.lizardtech.io.LizardTechFilesystemServerExplorer;
import org.gvsig.raster.lizardtech.io.LizardTechNative;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LizardTechProvider
extends AbstractRasterProvider {
    private static final Logger logger = LoggerFactory.getLogger(LizardTechProvider.class);
    public static String NAME = "LizardTech Store";
    public static String DESCRIPTION = "LizardTech Raster file";
    public static final String METADATA_DEFINITION_NAME = "LizardTechStore";
    protected LizardTechNative lztNative = null;
    private Extent viewRequest = null;
    private DataStoreColorInterpretation colorInterpr = null;
    protected DataStoreTransparency fileTransparency = null;
    private boolean open = false;
    protected static String[] formatList = null;

    public static void register() {
        RasterLocator.getManager().getProviderServices().registerFileProvidersTiled(LizardTechProvider.class);
        LizardTechProvider.registerFormats();
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, LizardTechProvider.class, LizardTechDataParameters.class);
        }
        if (DALFileLocator.getFilesystemServerExplorerManager() != null) {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(NAME, DESCRIPTION, LizardTechFilesystemServerExplorer.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[]{"sid"};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i], LizardTechProvider.class);
        }
    }

    public String[] getFormatList() {
        return formatList;
    }

    public boolean isExtensionSupported(String ext) {
        if (ext.indexOf(".") != -1) {
            ext = ext.substring(ext.lastIndexOf(".") + 1, ext.length());
        }
        for (int i = 0; i < formatList.length; ++i) {
            if (formatList[i].compareTo(ext) != 0) continue;
            return true;
        }
        return false;
    }

    public LizardTechProvider() {
    }

    public LizardTechProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of LizardTechProvider constructor");
        if (params instanceof String) {
            URI uriObj;
            LizardTechDataParameters p = new LizardTechDataParameters();
            try {
                uriObj = new URI(params);
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create uri from " + params, (Throwable)e);
            }
            p.setURI(uriObj);
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((AbstractRasterDataParameters)p, null);
        }
    }

    public LizardTechProvider(URI uri) throws NotSupportedExtensionException {
        super(uri);
        LizardTechDataParameters p = new LizardTechDataParameters();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)p, null);
    }

    public LizardTechProvider(LizardTechDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)params, storeServices);
    }

    public void init(AbstractRasterDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        this.setParam(storeServices, (DataStoreParameters)params);
        try {
            this.lztNative = new LizardTechNative(new File(params.getURI()).getAbsolutePath());
            this.load();
            this.bandCount = this.lztNative.nbands;
            int[] dt = new int[this.bandCount];
            for (int i = 0; i < dt.length; ++i) {
                dt[i] = 0;
            }
            this.setDataType(dt);
            super.init();
            try {
                this.loadFromRmf(this.getRmfBlocksManager());
            }
            catch (ParsingException parsingException) {}
        }
        catch (Exception e) {
            System.out.println("Error en constructor de MrSID");
            e.printStackTrace();
            this.lztNative = null;
        }
        this.open = true;
    }

    public RasterProvider load() {
        this.ownTransformation = this.lztNative.getOwnTransformation();
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        if (this.lztNative != null) {
            this.lztNative.close();
            this.lztNative = null;
        }
        this.open = false;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public double getWidth() {
        return this.lztNative.width;
    }

    public double getHeight() {
        return this.lztNative.height;
    }

    protected void setRGBLine(BufferedImage image, int startX, int startY, int w, int h, int[] rgbArray, int offset, int scansize) {
        image.setRGB(startX, startY, w, h, rgbArray, offset, scansize);
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if (this.lztNative != null) {
            if (x < 0 || y < 0 || x >= this.lztNative.width || y >= this.lztNative.height) {
                throw new InvalidSetViewException("Request out of grid");
            }
            Object[] data = this.lztNative.getData(x, y);
            return data[band];
        }
        throw new FileNotOpenException("MrSIDNative not exist");
    }

    public int getBlockSize() {
        return this.lztNative.blocksize;
    }

    public boolean isSupersampling() {
        return this.lztNative.isSupersampling;
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
        this.setView(query.getAdjustedRequestBoundingBox());
        int width = query.getAdjustedBufWidth();
        int height = query.getAdjustedBufHeight();
        this.lztNative.setView(this.viewRequest.getULX(), this.viewRequest.getULY(), this.viewRequest.getLRX(), this.viewRequest.getLRY(), width, height);
        int[] pRGBArray = new int[width * height];
        try {
            RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
            this.lztNative.readScene(pRGBArray, task);
            this.loadBuffer(height, width, query.getBandList(), query.getBufferForProviders(), pRGBArray);
        }
        catch (MrSIDException e) {
            throw new RasterDriverException("Error reading data");
        }
    }

    private void loadBuffer(int h, int w, BandList bandList, Buffer rasterBuf, int[] pRGBArray) throws ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        String absolutePath = new File(this.getURIOfFirstProvider()).getAbsolutePath();
        int[] drawableBandsR = bandList.getBufferBandToDraw(absolutePath, 0);
        int[] drawableBandsG = bandList.getBufferBandToDraw(absolutePath, 1);
        int[] drawableBandsB = bandList.getBufferBandToDraw(absolutePath, 2);
        int element = 0;
        for (int row = 0; row < h; ++row) {
            for (int col = 0; col < w; ++col) {
                int i;
                element = pRGBArray[row * w + col];
                if (drawableBandsR != null) {
                    for (i = 0; i < drawableBandsR.length; ++i) {
                        if (drawableBandsR[i] < 0 || drawableBandsR[i] >= rasterBuf.getBandCount()) continue;
                        rasterBuf.setElem(row, col, drawableBandsR[i], (byte)((element & 0xFF0000) >> 16));
                    }
                }
                if (drawableBandsG != null) {
                    for (i = 0; i < drawableBandsG.length; ++i) {
                        if (drawableBandsG[i] < 0 || drawableBandsG[i] >= rasterBuf.getBandCount()) continue;
                        rasterBuf.setElem(row, col, drawableBandsG[i], (byte)((element & 0xFF00) >> 8));
                    }
                }
                if (drawableBandsB == null) continue;
                for (i = 0; i < drawableBandsB.length; ++i) {
                    if (drawableBandsB[i] < 0 || drawableBandsB[i] >= rasterBuf.getBandCount()) continue;
                    rasterBuf.setElem(row, col, drawableBandsB[i], (byte)(element & 0xFF));
                }
            }
            if (task.getEvent() == null) continue;
            task.manageEvent(task.getEvent());
        }
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        if (pos < 0) {
            throw new InvalidSetViewException("Request out of grid");
        }
        if (pos + blockHeight > this.lztNative.height) {
            blockHeight = Math.abs(this.lztNative.height - pos);
        }
        Point2D begin = this.rasterToWorld(new Point2D.Double(0.0, pos));
        Point2D end = this.rasterToWorld(new Point2D.Double(this.lztNative.width, pos + blockHeight));
        int w = this.lztNative.width;
        this.lztNative.setView(begin.getX(), begin.getY(), end.getX(), end.getY(), w, blockHeight);
        int[] pRGBArray = new int[this.lztNative.width * blockHeight];
        try {
            this.lztNative.readScene(pRGBArray, task);
            byte[][][] buf = new byte[3][blockHeight][w];
            for (int row = 0; row < blockHeight; ++row) {
                for (int col = 0; col < w; ++col) {
                    buf[0][row][col] = (byte)((pRGBArray[row * w + col] & 0xFF0000) >> 16);
                    buf[1][row][col] = (byte)((pRGBArray[row * w + col] & 0xFF00) >> 8);
                    buf[2][row][col] = (byte)(pRGBArray[row * w + col] & 0xFF);
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
            return buf;
        }
        catch (MrSIDException e) {
            throw new RasterDriverException("Error reading data");
        }
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        if ((double)line > this.getHeight() || band > this.getBandCount()) {
            throw new InvalidSetViewException("Request out of grid");
        }
        try {
            Extent extent = this.getExtent();
            Point2D pt = this.rasterToWorld(new Point2D.Double(extent.minX(), line));
            this.lztNative.setView(extent.minX(), pt.getY(), extent.maxX(), pt.getY(), (int)this.getWidth(), 1);
            int[] pRGBArray = new int[(int)this.getWidth()];
            this.lztNative.readScene(pRGBArray, task);
            return pRGBArray;
        }
        catch (MrSIDException e) {
            throw new RasterDriverException("Error reading data from MrSID library");
        }
        catch (ProcessInterruptedException processInterruptedException) {
            return null;
        }
    }

    public DataStoreTransparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency((ColorInterpretation)this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public DataStoreColorInterpretation getColorInterpretation() {
        if (this.colorInterpr == null) {
            this.colorInterpr = new DataStoreColorInterpretation();
            this.colorInterpr.initColorInterpretation(this.getBandCount());
            if (this.getBandCount() == 1) {
                this.colorInterpr = DataStoreColorInterpretation.createGrayInterpretation();
            }
            if (this.getBandCount() == 3) {
                this.colorInterpr = DataStoreColorInterpretation.createRGBInterpretation();
            }
            if (this.getBandCount() >= 4) {
                this.colorInterpr = DataStoreColorInterpretation.createRGBAInterpretation();
            }
        }
        return this.colorInterpr;
    }

    public String getWktProjection() {
        return null;
    }

    public void setAffineTransform(AffineTransform t) {
        super.setAffineTransform(t);
        this.lztNative.setExternalTransform(t);
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        try {
            return this.lztNative.getNumLevels();
        }
        catch (MrSIDException e) {
            throw new RasterDriverException("");
        }
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public String getProviderName() {
        return NAME;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof LizardTechProvider) {
            // empty if block
        }
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new FileTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

