/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontrol.MapControl;

public class SelectAllExtension
extends Extension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-all", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        IWindow view;
        if (actionCommand.equals("SELALL") && (view = PluginServices.getMDIManager().getActiveWindow()) instanceof IView) {
            MapControl mc = ((IView)view).getMapControl();
            FLayer[] activeLayers = mc.getMapContext().getLayers().getActives();
            for (int i = 0; i < activeLayers.length; ++i) {
                FLayer layer = activeLayers[i];
                if (!layer.isAvailable() || !(layer instanceof FLyrVect)) continue;
                FLyrVect lyrVect = (FLyrVect)layer;
                try {
                    FeatureStore fs = lyrVect.getFeatureStore();
                    fs.getFeatureSelection().selectAll();
                    continue;
                }
                catch (DataException e) {
                    NotificationManager.showMessageError((String)"Data exception", (Exception)((Object)e));
                }
            }
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasActiveVectorLayers();
    }
}

