/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension;

import java.util.ArrayList;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.selectiontools.app.extension.tools.buffer.gui.BufferConfigurationPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectByBufferExtension
extends Extension {
    private static Logger logger = LoggerFactory.getLogger(SelectByBufferExtension.class);
    public static final String BUFFER_SELECTION_TOOL_NAME = "bufferSelection";

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-buffer", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-buffer", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return;
        }
        ViewDocument document = view.getViewDocument();
        if (actionCommand.equals("SELBUFFER")) {
            MapContext mapContext = document.getMapContext();
            FLayer[] layers = mapContext.getLayers().getActives();
            ArrayList<FLyrVect> usefulLayers = new ArrayList<FLyrVect>();
            int emptySelectionLayers = 0;
            for (int i = 0; i < layers.length; ++i) {
                FLayer layer = layers[i];
                if (!(layer instanceof FLyrVect) || !layer.isAvailable() || !layer.isActive()) continue;
                FLyrVect layervect = (FLyrVect)layer;
                usefulLayers.add(layervect);
                if (!layervect.getFeatureStore().isFeatureSelectionEmpty()) continue;
                ++emptySelectionLayers;
            }
            if (usefulLayers.isEmpty() || emptySelectionLayers == usefulLayers.size()) {
                application.messageDialog(application.translate("_There_are_no_geometries_selected", new String[0]), application.translate("Warning", new String[0]), 2);
                return;
            }
            application.getUIManager().addWindow((IWindow)new BufferConfigurationPanel(usefulLayers, view));
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        FLayer[] layers = mapa.getLayers().getActives();
        for (int i = 0; i < layers.length; ++i) {
            FLyrVect layervect;
            FeatureStore store;
            FLayer layer = layers[i];
            if (!(layer instanceof FLyrVect) || !layer.isAvailable() || !layer.isActive() || (store = (layervect = (FLyrVect)layer).getFeatureStore()) == null || store.isFeatureSelectionEmpty()) continue;
            return true;
        }
        return false;
    }
}

