/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.selectiontools.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolylineBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.selectiontools.app.extension.tools.PolyLineSelectListener;

public class SelectByPolylineExtension
extends Extension {
    public static final String POLYLINE_SELECTION_TOOL_NAME = "polylineSelection";

    public void initialize() {
        IconThemeHelper.registerIcon((String)"action", (String)"selection-select-by-polyline", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-select-by-polyline", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return;
        }
        if (actionCommand.equals("SELPOLYLINE")) {
            MapControl mc = view.getMapControl();
            if (!mc.getNamesMapTools().containsKey(POLYLINE_SELECTION_TOOL_NAME)) {
                PolyLineSelectListener polylineSelListener = new PolyLineSelectListener(mc);
                mc.addBehavior(POLYLINE_SELECTION_TOOL_NAME, new Behavior[]{new PolylineBehavior((PolylineListener)polylineSelListener), new MouseMovementBehavior((PointListener)new StatusBarListener(mc))});
            }
            mc.setTool(POLYLINE_SELECTION_TOOL_NAME);
        }
    }

    public boolean isVisible() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        MapContext mapa = document.getMapContext();
        return mapa.getLayers().getLayersCount() > 0;
    }

    public boolean isEnabled() {
        ApplicationManager application = ApplicationLocator.getManager();
        IView view = (IView)application.getActiveComponent(ViewDocument.class);
        if (view == null) {
            return false;
        }
        ViewDocument document = view.getViewDocument();
        return document.getMapContext().hasActiveVectorLayers();
    }
}

