/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.FilteredModel;
import org.gvsig.tools.swing.api.FilteredTableModel;
import org.gvsig.tools.util.CompareUtils;

class FilteredTableModelImpl
extends AbstractTableModel
implements FilteredTableModel {
    private final TableModel baseModel;
    private final int filterColumn;
    private String filter;
    private List<Integer> filteredElements;
    private FilteredModel.FilterFunction filterfn;
    private boolean caseSensitive;

    public FilteredTableModelImpl(TableModel tableModel, int theFilterColumn) {
        this.baseModel = tableModel;
        this.filterColumn = theFilterColumn;
        this.filteredElements = null;
        this.setFilter(null);
        this.baseModel.addTableModelListener(e -> this.fireContentsChanged());
        this.filterfn = (model, row, filter1) -> {
            int i = (Integer)row;
            Object value = this.baseModel.getValueAt(i, this.filterColumn);
            return CompareUtils.match((Object)value, (String)filter1);
        };
    }

    public void setFilterFunction(FilteredModel.FilterFunction filter) {
        this.filterfn = filter;
    }

    @Override
    public String getColumnName(int column) {
        return this.baseModel.getColumnName(column);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.baseModel.getColumnClass(columnIndex);
    }

    public final void setFilter(String filter) {
        if (StringUtils.isBlank((CharSequence)filter)) {
            this.filter = null;
            this.filteredElements = new ArrayList<Integer>(this.baseModel.getRowCount());
            for (int i = 0; i < this.baseModel.getRowCount(); ++i) {
                this.filteredElements.add(i);
            }
        } else {
            this.filter = StringUtils.containsAny((CharSequence)filter, (CharSequence)"*?") ? filter : filter + "*";
            this.filteredElements = new ArrayList<Integer>();
            for (int i = 0; i < this.baseModel.getRowCount(); ++i) {
                if (!this.filterfn.test((Object)this.baseModel, (Object)i, this.filter)) continue;
                this.filteredElements.add(i);
            }
        }
        this.fireContentsChanged();
    }

    private void fireContentsChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this::fireContentsChanged);
            return;
        }
        this.fireTableDataChanged();
    }

    public String getFilter() {
        return this.filter;
    }

    public void sort(boolean ascending) {
        this.sortBackground(ascending);
    }

    private void sortBackground(boolean ascending) {
        Thread th = new Thread(() -> this.sortForeground(ascending), "FilteredTableModelSorter");
        th.start();
    }

    private void sortForeground(boolean ascending) {
        this.filteredElements.sort((row1, row2) -> {
            try {
                Comparable o1 = (Comparable)this.baseModel.getValueAt((int)row1, this.filterColumn);
                Comparable o2 = (Comparable)this.baseModel.getValueAt((int)row2, this.filterColumn);
                int r = this.isCaseSensitive() ? CompareUtils.compare((Comparable)o1, (Comparable)o2) : ObjectUtils.compare((Comparable)o1, (Comparable)o2);
                if (ascending) {
                    return r;
                }
                return r * -1;
            }
            catch (Exception ex) {
                return 0;
            }
        });
        this.fireContentsChanged();
    }

    @Override
    public int getRowCount() {
        return this.filteredElements.size();
    }

    @Override
    public int getColumnCount() {
        return this.baseModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        int row = this.filteredElements.get(rowIndex);
        return this.baseModel.getValueAt(row, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        int row = this.filteredElements.get(rowIndex);
        this.baseModel.setValueAt(aValue, row, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int row = this.filteredElements.get(rowIndex);
        return this.baseModel.isCellEditable(row, columnIndex);
    }

    public void setCaseSensitive(boolean sensitive) {
        this.caseSensitive = sensitive;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }
}

