/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import org.gvsig.tools.swing.api.IconGetter;
import org.gvsig.tools.swing.impl.TreeComboUtils;

public class TreeComboCellRenderer
extends JLabel
implements ListCellRenderer {
    private static final long serialVersionUID = 3732251042879578480L;
    private static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);
    private static final int OFFSET = 16;
    private final Icon leafIcon = (Icon)UIManager.get("Tree.leafIcon");
    private final Icon nodeIcon = (Icon)UIManager.get("Tree.openIcon");
    private final TreeComboUtils.TreeModelToComboBoxModelAdapter model;
    private final IconGetter icons;

    public TreeComboCellRenderer(ComboBoxModel model) {
        this.setOpaque(true);
        this.model = (TreeComboUtils.TreeModelToComboBoxModelAdapter)model;
        this.icons = this.model instanceof IconGetter ? (IconGetter)this.model : null;
    }

    @Override
    public final void setOpaque(boolean isOpaque) {
        super.setOpaque(isOpaque);
    }

    public Component getListCellRendererComponent(JList listbox, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        DefaultMutableTreeNode entry = this.model.getNode(value);
        if (entry != null) {
            this.setText(this.getCellText(entry));
            if (this.icons == null) {
                this.setIcon(this.getCellIcon(entry));
            } else {
                this.setIcon(this.icons.getIcon(value));
            }
            Border border = index != -1 ? new EmptyBorder(0, 16 * entry.getLevel(), 0, 0) : emptyBorder;
            if (UIManager.getLookAndFeel().getName().equals("CDE/Motif")) {
                if (index == -1) {
                    this.setOpaque(false);
                } else {
                    this.setOpaque(true);
                }
            } else {
                this.setOpaque(true);
            }
            this.setBorder(border);
            if (isSelected) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
        } else {
            this.setText("");
        }
        return this;
    }

    public Icon getCellIcon(DefaultMutableTreeNode node) {
        return node.getAllowsChildren() ? this.nodeIcon : this.leafIcon;
    }

    public String getCellText(DefaultMutableTreeNode node) {
        return node.getUserObject().toString();
    }
}

