/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bookmarkshistory;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.tools.swing.impl.DefaultActionListenerSupport;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultBookmarksPanel;

public class DefaultBookmarksController<T>
extends DefaultActionListenerSupport
implements BookmarksController<T> {
    private final JButton btnBookmarks;
    public Bookmarks<T> bookmarks;
    private Predicate filter = null;
    private Boolean allowAddBookmarks = true;
    private int LIMIT_BOOKMARKS_TO_SHOW = 15;
    private List<JComponent> extraMenuItems;

    public DefaultBookmarksController(Bookmarks<T> bookmarks, JButton btnBookmarks) {
        this.bookmarks = bookmarks;
        this.btnBookmarks = btnBookmarks;
        if (this.btnBookmarks != null) {
            ToolsSwingUtils.configurePickersButton((AbstractButton)this.btnBookmarks, null, (String)"picker-bookmarks", e -> this.doBookmarks(), null);
        }
    }

    public void setBookmarks(Bookmarks bookmarks) {
        this.bookmarks = bookmarks;
    }

    public static void selfRegister() {
        ToolsSwingUtils.registerIcons(DefaultBookmarksController.class, (String)"/org/gvsig/tools/swing/bookmarkandhistory", (String)"ToolsSwing", (String[][])new String[][]{{"picker", "picker-bookmarks", "Bookmarks"}});
        ToolsSwingUtils.registerSubgroupIconDescription((String)"picker", (String)"Bookmarks", (String)"Permite acceder a los favoritos o bookmars de una herramienta, por ejemplo los de la ficha de b\u00fasqueda.");
    }

    private void doBookmarks() {
        JPopupMenu popup = this.createMenu().getPopupMenu();
        Point p = this.btnBookmarks.getLocationOnScreen();
        popup.show(this.btnBookmarks, 0, this.btnBookmarks.getHeight());
    }

    public JMenu createMenu() {
        boolean needSeparator = false;
        I18nManager i18n = ToolsLocator.getI18nManager();
        JMenu menu = new JMenu(i18n.getTranslation("_Bookmarks"));
        if (this.allowAddBookmarks.booleanValue()) {
            JMenuItem addToBookmarks = new JMenuItem(i18n.getTranslation("_Add_to_bookmarks"));
            addToBookmarks.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BookmarkEventImpl event = new BookmarkEventImpl(DefaultBookmarksController.this, 1002, "update-current-value");
                    DefaultBookmarksController.this.fireActionEvent(event);
                    DefaultBookmarksController.this.doShowBookmarksDialog(event.getBookmarkName(), event.getCurrentValue());
                }
            });
            menu.add(addToBookmarks);
            needSeparator = true;
        }
        if (!this.bookmarks.isEmpty()) {
            if (needSeparator) {
                menu.addSeparator();
                needSeparator = false;
            }
            int count = 0;
            for (Bookmark bookmark : this.bookmarks.getOrdered()) {
                JMenuItem item;
                if (count >= this.LIMIT_BOOKMARKS_TO_SHOW) {
                    item = menu.add("... " + i18n.getTranslation("_There_are_hidden_values"));
                    item.setEnabled(false);
                    break;
                }
                ++count;
                item = this.createBookmarkMenuItem(bookmark);
                if (this.filter != null && !this.filter.test(bookmark)) {
                    item.setEnabled(false);
                }
                menu.add(item);
                needSeparator = true;
            }
        }
        if (needSeparator) {
            menu.addSeparator();
            needSeparator = true;
        }
        JMenuItem showAllBookmarks = new JMenuItem(i18n.getTranslation("_Show_all_bookmarks"));
        showAllBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultBookmarksController.this.doShowBookmarksDialog(null, null);
            }
        });
        menu.add(showAllBookmarks);
        needSeparator = true;
        if (!CollectionUtils.isEmpty(this.extraMenuItems)) {
            if (needSeparator) {
                menu.addSeparator();
            }
            for (JComponent extraMenuItem : this.extraMenuItems) {
                menu.add(extraMenuItem);
            }
        }
        return menu;
    }

    private JMenuItem createBookmarkMenuItem(Bookmark<T> bookmark) {
        JMenuItem item = new JMenuItem(StringUtils.abbreviate((String)bookmark.getName(), (int)45));
        item.addActionListener(e -> {
            BookmarkEventImpl<Object> event = new BookmarkEventImpl<Object>(this, 1001, "set-value");
            Object value = bookmark.getValue();
            if (value != null) {
                event.setCurrentBookmark(bookmark);
                event.setCurrentValue(value);
                this.fireActionEvent(event);
            }
        });
        return item;
    }

    private void doShowBookmarksDialog(String name, T value) {
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final Bookmark newbookmark = value != null ? this.bookmarks.add(name, value) : null;
        final DefaultBookmarksPanel panel = new DefaultBookmarksPanel(this.bookmarks, this);
        I18nManager i18n = ToolsLocator.getI18nManager();
        final Dialog dialog = winManager.createDialog(panel, i18n.getTranslation("Bookmarks"), null, 3);
        dialog.setAutoclose(false);
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    default: {
                        if (newbookmark == null) break;
                        DefaultBookmarksController.this.bookmarks.remove(newbookmark);
                        break;
                    }
                    case 1: {
                        if (panel.getState() == 1) {
                            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog("_Bookmark_is_being_edit_accept_or_discard_modification_before_exit", "_Bookmark_not_saved", 2);
                            return;
                        }
                        Bookmark bookmark = panel.getSelectedValue();
                        if (bookmark == null) break;
                        BookmarkEventImpl<Object> event = new BookmarkEventImpl<Object>(DefaultBookmarksController.this, 1001, "set-value");
                        event.setCurrentBookmark(bookmark);
                        Object v = bookmark.getValue();
                        if (v == null) break;
                        event.setCurrentValue(v);
                        DefaultBookmarksController.this.fireActionEvent(event);
                    }
                }
                dialog.asJComponent().setVisible(false);
            }
        });
        if (newbookmark != null) {
            SwingUtilities.invokeLater(() -> {
                panel.setSelected(newbookmark);
                panel.changeStateTo(1);
            });
        }
        dialog.show(WindowManager.MODE.DIALOG);
    }

    public void setFilter(Predicate filter) {
        this.filter = filter;
    }

    public void setAllowAddBookmarks(Boolean allowAddBookmarks) {
        this.allowAddBookmarks = allowAddBookmarks;
    }

    public Bookmarks<T> get() {
        return this.bookmarks;
    }

    public void addMenuItem(JComponent menuItem) {
        if (this.extraMenuItems == null) {
            this.extraMenuItems = new ArrayList<JComponent>();
        }
        this.extraMenuItems.add(menuItem);
    }

    public static class BookmarkEventImpl<T>
    extends ActionEvent
    implements BookmarksController.BookmarkEvent<T> {
        private T currentValue;
        private Bookmark<T> currentBookmark;
        private String bookmarkName;

        public BookmarkEventImpl(Object source, int id, String command) {
            super(source, id, command);
        }

        public void setCurrentValue(T value) {
            this.currentValue = value;
        }

        public void setBookmarkName(String bookmarkName) {
            this.bookmarkName = bookmarkName;
        }

        public T getCurrentValue() {
            return this.currentValue;
        }

        public Bookmark<T> getBookmark() {
            return this.currentBookmark;
        }

        public String getBookmarkName() {
            return this.bookmarkName;
        }

        public void setCurrentBookmark(Bookmark<T> bookmark) {
            this.currentBookmark = bookmark;
        }
    }
}

