/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bookmarkshistory;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.bookmarksandhistory.BookmarksAndHistoryManager;
import org.gvsig.tools.bookmarksandhistory.History;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.bookmarkshistory.ActionEventWithCurrentValue;
import org.gvsig.tools.swing.api.bookmarkshistory.BookmarksController;
import org.gvsig.tools.swing.api.bookmarkshistory.HistoryController;
import org.gvsig.tools.swing.api.bookmarkshistory.TextFieldWithHistoryAndBookmarkController;
import org.gvsig.tools.swing.icontheme.IconThemeManager;

public class TextFieldWithHistoryAndBookmarkControllerImpl
implements TextFieldWithHistoryAndBookmarkController {
    private final History<TextFieldWithHistoryAndBookmarkData> history;
    private final Bookmarks<TextFieldWithHistoryAndBookmarkData> bookmarks;
    private HistoryController<TextFieldWithHistoryAndBookmarkData> historyController;
    private BookmarksController<TextFieldWithHistoryAndBookmarkData> bookmarksController;
    private final String name;
    private final JTextComponent text;
    private final JButton btnApply;
    private final JButton btnHistory;
    private final JButton btnBookmarks;
    private final ChangeListenerHelper changeListenerHelper;
    private final ActionListenerSupport actionListenerHelper;
    private Timer alarm;

    public TextFieldWithHistoryAndBookmarkControllerImpl(String name, JTextComponent text, JButton btnApply, JButton btnHistory, JButton btnBookmarks) {
        this.name = name;
        this.text = text;
        this.btnApply = btnApply == null ? new JButton() : btnApply;
        this.btnHistory = btnHistory == null ? new JButton() : btnHistory;
        this.btnBookmarks = btnBookmarks == null ? new JButton() : btnBookmarks;
        BookmarksAndHistoryManager manager = ToolsLocator.getBookmarksAndHistoryManager();
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        this.btnBookmarks.setCursor(Cursor.getPredefinedCursor(12));
        this.btnHistory.setCursor(Cursor.getPredefinedCursor(12));
        this.btnApply.setCursor(Cursor.getPredefinedCursor(12));
        this.bookmarks = manager.getBookmarksGroup(name);
        this.history = manager.getHistoryGroup(name);
        this.changeListenerHelper = toolsSwingManager.createChangeListenerHelper();
        this.actionListenerHelper = toolsSwingManager.createActionListenerSupport();
        this.initComponents();
    }

    private void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        IconThemeManager iconManager = ToolsSwingLocator.getIconThemeManager();
        this.alarm = new Timer(3000, e -> this.changeListenerHelper.fireEvent());
        this.alarm.setCoalesce(true);
        this.alarm.setRepeats(false);
        toolsSwingManager.addClearButton(this.text);
        toolsSwingManager.setDefaultPopupMenu(this.text);
        this.btnApply.setIcon(iconManager.getCurrent().get("common-applychanges"));
        if (this.btnApply.getText().equals("...")) {
            this.btnApply.setText("");
        }
        this.bookmarksController = toolsSwingManager.createBookmarksController(this.bookmarks, this.btnBookmarks);
        this.historyController = toolsSwingManager.createHistoryController(this.history, this.btnHistory);
        this.historyController.setFilter(null);
        ActionListener bookmarksAndHistoryListener = e -> {
            ActionEventWithCurrentValue b = (ActionEventWithCurrentValue)e;
            switch (b.getID()) {
                case 1002: {
                    b.setCurrentValue((Object)new TextFieldWithHistoryAndBookmarkData(this.text.getText()));
                    break;
                }
                case 1001: {
                    if (b.getCurrentValue() == null) {
                        this.text.setText("");
                        return;
                    }
                    String s = ((TextFieldWithHistoryAndBookmarkData)b.getCurrentValue()).getValue();
                    this.text.setText(s);
                    this.text.requestFocus();
                    this.text.setCaretPosition(s.length());
                    this.actionListenerHelper.fireActionEvent(new ActionEvent(this, 1, "BookmarkHistoryEvent"));
                }
            }
        };
        this.historyController.addActionListener(bookmarksAndHistoryListener);
        this.bookmarksController.addActionListener(bookmarksAndHistoryListener);
        this.text.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TextFieldWithHistoryAndBookmarkControllerImpl.this.alarm.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TextFieldWithHistoryAndBookmarkControllerImpl.this.alarm.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TextFieldWithHistoryAndBookmarkControllerImpl.this.alarm.restart();
            }
        });
        this.text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    TextFieldWithHistoryAndBookmarkControllerImpl.this.actionListenerHelper.fireActionEvent(new ActionEvent(TextFieldWithHistoryAndBookmarkControllerImpl.this, 0, "EnterKey"));
                }
            }
        });
        this.btnApply.addActionListener(e -> this.actionListenerHelper.fireActionEvent(new ActionEvent(this, 1, "Apply")));
        TextFieldWithHistoryAndBookmarkData latest = (TextFieldWithHistoryAndBookmarkData)this.history.getLatest();
        if (latest != null) {
            this.text.setText(latest.getValue());
        }
    }

    public String getText() {
        String s = this.text.getText();
        return s;
    }

    public void addHistory(String value) {
        this.history.add((Object)new TextFieldWithHistoryAndBookmarkData(value));
    }

    public void addActionListener(ActionListener listener) {
        this.actionListenerHelper.addActionListener(listener);
    }

    public ActionListener[] getActionListeners() {
        return this.actionListenerHelper.getActionListeners();
    }

    public void removeActionListener(ActionListener listener) {
        this.actionListenerHelper.removeActionListener(listener);
    }

    public void removeAllActionListener() {
        this.actionListenerHelper.removeAllActionListener();
    }

    public void fireActionEvent(ActionEvent event) {
        this.actionListenerHelper.fireActionEvent(event);
    }

    public boolean hasActionListeners() {
        return this.actionListenerHelper.hasActionListeners();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListenerHelper.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListenerHelper.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListenerHelper.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListenerHelper.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListenerHelper.hasChangeListeners();
    }

    public void setEnabled(boolean enabled) {
        this.btnApply.setEnabled(enabled);
        this.btnBookmarks.setEnabled(enabled);
        this.btnHistory.setEnabled(enabled);
        this.text.setEnabled(enabled);
        this.text.setEditable(enabled);
    }

    public boolean isEnabled() {
        return this.text.isEditable();
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition("TextFieldWithHistoryAndBookmarkData") == null) {
            DynStruct definition = manager.addDefinition(TextFieldWithHistoryAndBookmarkData.class, "TextFieldWithHistoryAndBookmarkData", "TextFieldWithHistoryAndBookmarkData persistence definition", null, null);
            definition.addDynFieldString("value");
        }
    }

    public static class TextFieldWithHistoryAndBookmarkData
    implements Persistent {
        private String value;

        public TextFieldWithHistoryAndBookmarkData() {
        }

        public TextFieldWithHistoryAndBookmarkData(String value) {
            this.value = value;
        }

        public void saveToState(PersistentState state) throws PersistenceException {
            state.set("value", this.value);
        }

        public void loadFromState(PersistentState state) throws PersistenceException {
            this.value = state.getString("value");
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TextFieldWithHistoryAndBookmarkData)) {
                return false;
            }
            return StringUtils.equals((CharSequence)this.getValue(), (CharSequence)((TextFieldWithHistoryAndBookmarkData)obj).getValue());
        }

        public String toString() {
            return this.value;
        }
    }
}

