/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.hexeditor.swing;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.Action;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import org.gvsig.tools.swing.impl.hexeditor.event.HexEditorEvent;
import org.gvsig.tools.swing.impl.hexeditor.event.HexEditorListener;
import org.gvsig.tools.swing.impl.hexeditor.event.SelectionChangedListener;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorRowHeader;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexEditorTransferHandler;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexTable;
import org.gvsig.tools.swing.impl.hexeditor.swing.HexTableModel;

public class HexEditorComponent
extends JScrollPane {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_ALTERNATE_COLUMN_BG = "alternateColBG";
    public static final String PROPERTY_ALTERNATE_ROW_BG = "alternateRowBG";
    public static final String PROPERTY_ASCII_DUMP_HIGHLIGHT_COLOR = "asciiDumpHighlightColor";
    public static final String PROPERTY_HIGHLIGHT_ASCII_DUMP = "highlightAsciiDump";
    public static final String PROPERTY_PAD_LOW_BYTES = "padLowBytes";
    public static final String PROPERTY_SHOW_GRID = "showGrid";
    private HexTable table;
    private boolean alternateRowBG;
    private boolean alternateColumnBG;
    private boolean highlightSelectionInAsciiDump;
    private Color highlightSelectionInAsciiDumpColor;
    private boolean padLowBytes;
    private static final TransferHandler DEFAULT_TRANSFER_HANDLER = new HexEditorTransferHandler();
    static final int DUMP_COLUMN_WIDTH = 140;

    public HexEditorComponent() {
        HexTableModel model = new HexTableModel(this);
        this.table = new HexTable(this, model);
        this.setViewportView(this.table);
        this.setShowRowHeader(true);
        this.setAlternateRowBG(false);
        this.setAlternateColumnBG(false);
        this.setHighlightSelectionInAsciiDump(true);
        this.setHighlightSelectionInAsciiDumpColor(new Color(255, 255, 192));
        this.setPadLowBytes(true);
        this.setCellEditable(true);
        this.setTransferHandler(DEFAULT_TRANSFER_HANDLER);
    }

    public void addHexEditorListener(HexEditorListener l) {
        this.listenerList.add(HexEditorListener.class, l);
    }

    public void addSelectionChangedListener(SelectionChangedListener l) {
        this.table.addSelectionChangedListener(l);
    }

    public int cellToOffset(int row, int col) {
        return this.table.cellToOffset(row, col);
    }

    public void copy() {
        this.invokeAction(TransferHandler.getCopyAction());
    }

    public void cut() {
        this.invokeAction(TransferHandler.getCutAction());
    }

    public void delete() {
        if (this.table.leadSelectionIndex == -1 || this.table.anchorSelectionIndex == -1) {
            UIManager.getLookAndFeel().provideErrorFeedback(this.table);
            return;
        }
        int start = this.table.getSmallestSelectionIndex();
        int end = this.table.getLargestSelectionIndex();
        int len = end - start + 1;
        this.removeBytes(start, len);
    }

    protected void fireHexEditorEvent(int offset, int added, int removed) {
        HexEditorEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != HexEditorListener.class) continue;
            if (e == null) {
                e = new HexEditorEvent(this, offset, added, removed);
            }
            ((HexEditorListener)listeners[i + 1]).hexBytesChanged(e);
        }
    }

    public boolean getAlternateColumnBG() {
        return this.alternateColumnBG;
    }

    public boolean getAlternateRowBG() {
        return this.alternateRowBG;
    }

    public byte getByte(int offset) {
        return this.table.getByte(offset);
    }

    public int getByteCount() {
        return this.table.getByteCount();
    }

    public byte[] getBytes() {
        return this.table.getBytes();
    }

    public boolean getHighlightSelectionInAsciiDump() {
        return this.highlightSelectionInAsciiDump;
    }

    public Color getHighlightSelectionInAsciiDumpColor() {
        return this.highlightSelectionInAsciiDumpColor;
    }

    public int getLargestSelectionIndex() {
        return this.table.getLargestSelectionIndex();
    }

    public boolean getPadLowBytes() {
        return this.padLowBytes;
    }

    public int getSmallestSelectionIndex() {
        return this.table.getSmallestSelectionIndex();
    }

    HexTable getTable() {
        return this.table;
    }

    private void invokeAction(Action a) {
        a.actionPerformed(new ActionEvent(this, 1001, (String)a.getValue("Name"), EventQueue.getMostRecentEventTime(), 0));
    }

    public Point offsetToCell(int offset) {
        return this.table.offsetToCell(offset);
    }

    public void open(String fileName) throws IOException {
        this.table.open(fileName);
    }

    public void open(InputStream in) throws IOException {
        this.table.open(in);
    }

    public void paste() {
        this.invokeAction(TransferHandler.getPasteAction());
    }

    public boolean redo() {
        return this.table.redo();
    }

    public void removeBytes(int offs, int len) {
        this.table.removeBytes(offs, len);
        this.table.changeSelectionByOffset(offs, false);
    }

    public void removeHexEditorListener(HexEditorListener l) {
        this.listenerList.remove(HexEditorListener.class, l);
    }

    public void removeSelectionChangedListener(SelectionChangedListener l) {
        this.table.removeSelectionChangedListener(l);
    }

    public void replaceBytes(int offset, int len, byte[] bytes) {
        if (len == 1) {
            len = 0;
        }
        this.table.replaceBytes(offset, len, bytes);
        this.table.changeSelectionByOffset(this.table.anchorSelectionIndex, false);
        int count = bytes == null ? 0 : bytes.length;
        this.table.setSelectionByOffsets(offset, offset + count - 1);
    }

    public void replaceSelection(byte[] bytes) {
        int offset = this.table.getSmallestSelectionIndex();
        int len = this.table.getLargestSelectionIndex() - offset + 1;
        this.replaceBytes(offset, len, bytes);
    }

    public void setAlternateColumnBG(boolean alternate) {
        if (alternate != this.alternateColumnBG) {
            this.alternateColumnBG = alternate;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ALTERNATE_COLUMN_BG, !alternate, alternate);
        }
    }

    public void setAlternateRowBG(boolean alternate) {
        if (alternate != this.alternateRowBG) {
            this.alternateRowBG = alternate;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ALTERNATE_ROW_BG, !alternate, alternate);
        }
    }

    public void setCellEditable(boolean cellEditable) {
        this.table.setCellEditable(cellEditable);
    }

    public void setHighlightSelectionInAsciiDump(boolean highlight) {
        if (highlight != this.highlightSelectionInAsciiDump) {
            this.highlightSelectionInAsciiDump = highlight;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_HIGHLIGHT_ASCII_DUMP, !highlight, highlight);
        }
    }

    public void setHighlightSelectionInAsciiDumpColor(Color c) {
        if (c != null && !c.equals(this.highlightSelectionInAsciiDumpColor)) {
            Color old = this.highlightSelectionInAsciiDumpColor;
            this.highlightSelectionInAsciiDumpColor = c;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_ASCII_DUMP_HIGHLIGHT_COLOR, old, c);
        }
    }

    public void setPadLowBytes(boolean pad) {
        if (this.padLowBytes != pad) {
            this.padLowBytes = pad;
            this.table.repaint();
            this.firePropertyChange(PROPERTY_PAD_LOW_BYTES, !pad, pad);
        }
    }

    public void setSelectedRange(int startOffs, int endOffs) {
        this.table.setSelectionByOffsets(startOffs, endOffs);
    }

    public void setShowColumnHeader(boolean show) {
        this.setColumnHeaderView(show ? this.table.getTableHeader() : null);
    }

    public void setShowGrid(boolean show) {
        if (show != this.table.getShowHorizontalLines()) {
            this.table.setShowGrid(show);
            this.firePropertyChange(PROPERTY_SHOW_GRID, !show, show);
        }
    }

    public void setShowRowHeader(boolean show) {
        this.setRowHeaderView(show ? new HexEditorRowHeader(this.table) : null);
    }

    public boolean undo() {
        return this.table.undo();
    }
}

