/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.icontheme;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gvsig.tools.observer.ComplexObserver;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.gvsig.tools.swing.impl.icontheme.BaseIconTheme;
import org.gvsig.tools.swing.impl.icontheme.FolderIconTheme;
import org.gvsig.tools.util.FolderSet;
import org.gvsig.tools.util.impl.DefaultFolderSet;

public class DefaultIconThemeManager
implements IconThemeManager,
ComplexObserver {
    private static IconThemeManager iconThemeManager = null;
    private IconTheme defaultTheme = null;
    private IconTheme currentTheme = this.defaultTheme = new BaseIconTheme();
    private Map<String, IconTheme> themesByName = null;
    private List<IconTheme> themes = null;
    private FolderSet repository = new DefaultFolderSet();
    private double scaleFactor = 1.0;

    public static IconThemeManager getIconThemeManager() {
        if (iconThemeManager == null) {
            iconThemeManager = new DefaultIconThemeManager();
        }
        return iconThemeManager;
    }

    public DefaultIconThemeManager() {
        this.repository.addObserver((Observer)this);
    }

    public IconTheme getDefault() {
        return this.defaultTheme;
    }

    public int getCount() {
        return this.getThemes().size();
    }

    @Deprecated
    public void setCurrent(IconTheme iconTheme) {
        this.currentTheme = iconTheme;
    }

    public void setActive(IconTheme iconTheme) {
        this.currentTheme = iconTheme;
    }

    @Deprecated
    public IconTheme getCurrent() {
        return this.currentTheme;
    }

    public IconTheme getActive() {
        return this.currentTheme;
    }

    public IconTheme get(String themeID) {
        IconTheme t = this.getThemes().get(themeID);
        if (t != null) {
            return t;
        }
        for (IconTheme theme : this.getThemes().values()) {
            if (!theme.matchID(themeID)) continue;
            return theme;
        }
        return null;
    }

    public IconTheme get(int index) {
        return this.getListOfThemes().get(index);
    }

    public Iterator<IconTheme> iterator() {
        return this.getThemes().values().iterator();
    }

    public boolean contains(IconTheme theme) {
        return this.getThemes().containsValue(theme);
    }

    public boolean add(IconTheme theme) {
        this.getThemes().put(theme.getID(), theme);
        return true;
    }

    public boolean remove(IconTheme theme) {
        return this.getThemes().remove(theme) != null;
    }

    public void clear() {
        this.themesByName = null;
        this.themes = null;
    }

    public FolderSet getRepository() {
        return this.repository;
    }

    public void update(Observable observable, Object notification) {
        if (observable != this.repository) {
            return;
        }
        this.clear();
    }

    private void buildThemes() {
        File[] folders;
        HashMap<String, IconTheme> themesByName = new HashMap<String, IconTheme>();
        for (File folder : folders = this.repository.listFiles()) {
            if (!folder.isDirectory()) continue;
            FolderIconTheme theme = new FolderIconTheme(this.getDefault());
            try {
                theme.load(folder);
                themesByName.put(theme.getID(), theme);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ArrayList<IconTheme> themes = new ArrayList<IconTheme>();
        themes.addAll(themesByName.values());
        this.themes = themes;
        this.themesByName = themesByName;
    }

    private List<IconTheme> getListOfThemes() {
        if (this.themes == null) {
            this.buildThemes();
        }
        return this.themes;
    }

    private Map<String, IconTheme> getThemes() {
        if (this.themesByName == null) {
            this.buildThemes();
        }
        return this.themesByName;
    }

    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setScaleFactor(double scaleFactor) {
        this.scaleFactor = scaleFactor;
    }
}

